

***-----------------------------------------------------------------------------------------------------------------------------***	
***   				Barrage, Chyn, Hastings (2019, AEJ:Policy)		     				        ***
***					FIGURES 3A & 3B & TABLE A10								***	
***-----------------------------------------------------------------------------------------------------------------------------***	
	
/* This do-file replicates Table A10 and the display of its coefficients in Figures 3A and 3B.
Inputs:   BCH_Replication_Figure3_TableA10.dta
Outputs:  BCH_Figure3A_market_share_abovemedian.eps
	  BCH_Figure3B_market_share_belowmedian.eps
	  BCH_TableA10.xlsx
*/
	
	
clear all
set more off

*Install programs:
cap net install outreg2, from(http://fmwww.bc.edu/repec/bocode/o/)

*Set directory:
include 1_SET_DIRECTORY.do

*Open data:
use BCH_Replication_Figure3_TableA10.dta, clear


************************* 
** Table A10 Column 1  **           
*************************
	
areg bp_share prespill1-prespill15 spill1-spill8 if ads_p50==1, absorb(random_zip) cluster(random_zip)
	
egen id_tag=tag(random_zip) if e(sample)==1
count if id_tag==1
local zips=`r(N)'
drop id_tag   

cap outreg2 using TableA10_BCH.xls, replace excel stats(coef se) adjr2 label ctitle("BP Mkt. Share, Above Median Ad. Spend") dec(3) ///
title("Table A10: BP Station Market Share Impact, By Advertising Level") nocons ///
addstat(# of zips,`e(N_clust)', # of zips,`zips') 
	
**Prepare Figure 3A Elements:
 gen beta1=0 if (month==monthly("04-2010", "MY"))
 gen lb1=0   if (month==monthly("04-2010", "MY"))
 gen ub1=0   if (month==monthly("04-2010", "MY"))

*Pre-spill coefficients:	
 forvalues i=1(1)15 {
            local month = 587+`i'       /* 588 is 2009 Jan */
            replace beta=_b[prespill`i'] if month==`month'
            replace lb=_b[prespill`i']-1.96*_se[prespill`i'] if month==`month'
            replace ub=_b[prespill`i']+1.96*_se[prespill`i'] if month==`month' 
         } 
*	 
*Spill coefficients:
forvalues i=1(1)8 {
            local month = 603+`i'       /* 604 is May */
            replace beta=_b[spill`i'] if month==`month'
            replace lb=_b[spill`i']-1.96*_se[prespill`i'] if month==`month'
            replace ub=_b[spill`i']+1.96*_se[prespill`i'] if month==`month'  
         } 
*	

************************ 
**      Figure 3A     **           
************************

preserve
		 
keep month_form beta1 lb1 ub1  
duplicates drop
rename month_form month
format month %tmMon_YY
sort month 		 	 

	twoway (connected lb1 month , m(square_hollow) mlcolor(dknavy*.45) mfcolor(dknavy*.45) lc(dknavy*.35) lpattern(londash_dot)) ///
        (connected ub1 month , m(square_hollow) mlcolor(dknavy*.45) mfcolor(dknavy*.45) lc(dknavy*.35) lpattern(londash_dot)) ///
	(connected beta1 month, msymbol(square) color(dknavy)), ///		 
        yline(0, lcolor(black)) yscale(range(-.01 .01)) ylabel(-.01(.005).01) ///
        xline(603) xtitle("") /// 
	legend(order(3 "Point Estimate" 2 "95-Percent Conf. Interval") region(lcolor(white))) ///
	graphregion(color(white) fcolor(white) icolor(white) ifcolor(white) lcolor(white) ilcolor(white)) plotregion(color(white) fcolor(white) icolor(white) ifcolor(white) lcolor(white) ilcolor(white))

         graph export Figure3A_market_share_abovemedian.eps, replace
		 
restore
		 
************************* 
** Table A10 Column 2  **           
*************************	

areg bp_share prespill1-prespill15 spill1-spill8 if ads_p50==0, absorb(random_zip) cluster(random_zip)

egen id_tag=tag(random_zip) if e(sample)==1
count if id_tag==1
local zips=`r(N)'
drop id_tag   

cap outreg2 using TableA10_BCH.xls, append excel stats(coef se) adjr2 label ctitle("BP Mkt. Share, Below Median Ad. Spend") dec(3) ///
title("Table A10: BP Station Market Share Impact, By Advertising Level") nocons ///
addstat(# of zips,`e(N_clust)', # of zips,`zips') 

	
**Prepare Figure 3B Elements:
gen beta2=0 if (month==monthly("04-2010", "MY"))
gen lb2=0   if (month==monthly("04-2010", "MY"))
gen ub2=0   if (month==monthly("04-2010", "MY"))

*Pre-spill coefficients:	
 forvalues i=1(1)15 {
            local month = 587+`i'       /* 588 is 2009 Jan */
            replace beta2=_b[prespill`i'] if month==`month'
            replace lb2=_b[prespill`i']-1.96*_se[prespill`i'] if month==`month'
            replace ub2=_b[prespill`i']+1.96*_se[prespill`i'] if month==`month'
	    }
*	 

*Spill coefficients:
forvalues i=1(1)8 {
            local month = 603+`i'       /* 604 is May */
            replace beta2=_b[spill`i'] if month==`month'
            replace lb2=_b[spill`i']-1.96*_se[prespill`i'] if month==`month'
            replace ub2=_b[spill`i']+1.96*_se[prespill`i'] if month==`month'  
         } 
*			 

************************ 
**      Figure 3B     **           
************************

preserve
		 
keep month_form beta2 lb2 ub2  
duplicates drop
rename month_form month
format month %tmMon_YY
sort month 		 	 

	twoway (connected lb2 month , m(square_hollow) mlcolor(maroon*.45) mfcolor(maroon*.45) lc(maroon*.35) lpattern(londash_dot)) ///
        (connected ub2 month , m(square_hollow) mlcolor(maroon*.45) mfcolor(maroon*.45) lc(maroon*.35) lpattern(londash_dot)) ///
	(connected beta2 month, msymbol(maroon) color(maroon)), ///		 
        yline(0, lcolor(black)) yscale(range(-.01 .01)) ylabel(-.01(.005).01) ///
        xline(603) xtitle("") /// 
	legend(order(3 "Point Estimate" 2 "95-Percent Conf. Interval") region(lcolor(white))) ///
	graphregion(color(white) fcolor(white) icolor(white) ifcolor(white) lcolor(white) ilcolor(white)) plotregion(color(white) fcolor(white) icolor(white) ifcolor(white) lcolor(white) ilcolor(white))

         graph export Figure3B_market_share_belowmedian.eps, replace
	 		 
restore		 











