******************************************************************************************************
* This dofile produces all tables and figures in the print publication of Bohlmark and Willén (2018) *
******************************************************************************************************
* Verified: November 16, 2018

************
* FIGURE 1 *
************


* Preliminary commands
	clear
	set mem 64m
	set matsize 6000

* Loading the data 
	use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000.dta", clear
	sort k2

* Generating necessary variables (threshold dummy & polynomials)
	foreach type in fpneg {
			gen d1_`type'   = Frac_nonWest - `type'_search1990_mstar
			gen d2_`type'=d1_`type'^2
			gen d3_`type'=d1_`type'^3
			gen d4_`type'=d1_`type'^4
			gen past_`type'=(d1_`type'>0)
	 }
	
* Constraining the sample 
	keep if searchsamp==0
	keep if k2==1 | k2==12 | k2==8

* Generating the figure
		pause on
		preserve
		gen TP_norm=Frac_nonWest-fpneg_search1990_mstar
	
		replace Dn1990=Dn1990*100
		rename Dn1990 DN1990
		rename TP_norm tp_norm
		gen TP_norm=round(tp_norm)
		
		forvalues i=-99(2)99 {
		replace TP_norm=TP_norm+1 if TP_norm==`i'
		}
		
		bysort TP_norm: egen Dn1990=mean(DN1990)
		egen mgrowth=mean(Dn1990)
		mkmat mgrowth, matrix(mg)
		scalar temp_mg=mg[1,1]
		local mNgr=temp_mg	
		
		gen TP_normp=TP_norm if TP_norm<=0
		gen Dn1990p=Dn1990 if TP_norm<=0
		gen TP_normpost=TP_norm if TP_norm>0
		gen Dn1990post=Dn1990 if TP_norm>0
		drop if TP_norm>40

		* i. Figure 1A
		twoway (scatter Dn1990 TP_norm, xline(0) yline(7.2) ylabel(-30(10)30, angle(0))) (lpoly Dn1990p TP_normp [aw=sN_tot1990] if inrange(TP_norm,-30,0), degree(1) bwidth(4)) (lpoly Dn1990post TP_normpost [aw=sN_tot1990], degree(1) bwidth(4))
		
		* ii. Figure 1B
		twoway (scatter Dn1990 TP_norm [w=sN_tot1990], xline(0) yline(7.2) ylabel(-30(10)30, angle(0))) (lpoly Dn1990p TP_normp [aw=sN_tot1990] if inrange(TP_norm,-30,0), degree(1) bwidth(4)) (lpoly Dn1990post TP_normpost [aw=sN_tot1990], degree(1) bwidth(4))

		
************
* FIGURE 2 *
************

* Preliminary commands
	clear
	set mem 64m
	set matsize 6000

* Loading the data
	use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000.dta", clear
	sort kommun

* Generating necessary treat variables
	gen d1_fpneg   = Frac_nonWest - fpneg_search1990_mstar
	gen past_fpneg=(d1_fpneg>0)
 
* Constraining the sample 
	keep if kommun==1 | kommun==1280 | kommun==1480
	keep if searchsamp==0

* Density plot
		gen cob=1/1556  /* To get correct frequency counts */
		gen TP_norm=Frac_nonWest-fpneg_search1990_mstar
		rename TP_norm tp_norm
		gen TP_norm=round(tp_norm)
		
		forvalues i=-99(2)99 {
		replace TP_norm=TP_norm+1 if TP_norm==`i'
		}
		
		bysort TP_norm: egen freq=sum(cob)
		
		
		gen TP_normp=TP_norm if TP_norm<=0
		gen freqp=freq if TP_norm<=0
		gen TP_normpost=TP_norm if TP_norm>=0
		gen freqpost=freq if TP_norm>=0
		
		* Figure 2
		twoway (scatter freq TP_norm, xline(0)) (lpoly freqp TP_normp, degree(1) bwidth(4)) (lpoly freqpost TP_normpost, degree(1) bwidth(4))
		
************
* FIGURE 3 *
************

		****																			***
		* Note: change SQ to NQ on row 179 to run figure for the Economic Activity Index. * 
		****																			***

* Preliminary commands
	clear
	set mem 64m
	set matsize 6000

* Loading the data
	use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000.dta", clear
	sort k2

* Generating necessary treat variables
	foreach type in fpneg {
			gen d1_`type'   = Frac_nonWest - `type'_search1990_mstar
			gen d2_`type'=d1_`type'^2
			gen d3_`type'=d1_`type'^3
			gen d4_`type'=d1_`type'^4
			gen past_`type'=(d1_`type'>0)
	 }
 	
	* Constraining the sample  
	keep if searchsamp==0
	keep if kommun==1 | kommun==1280 | kommun==1480

	merge 1:1 kommun sams using "P:\2016\79\DTA files segregation\NQuality" // merging with neighborhood quality variables (NeighborhoodQuality3)
	keep if searchsamp==0
	keep if city>0
	
	gen Frac_imm00=sN_immback_nonWest2000/sN_tot2000
	
	replace female_00=female_00-.5
	gen Fem_00=abs(female_00)
	
	replace socbidr_00=socbidr_00*-1
	replace Frac_imm00=Frac_imm00*-1
	replace age_00=age_00*-1
	replace Fem_00=Fem_00*-1
	replace sN_tot2000=sN_tot2000/mN_tot2000
	replace inc_00=ln(inc_00)

	* Normalizing individual variable components
	estimates clear
	local var "sN_tot2000 genuniv_00 inc_00 anstalld_00 ys_00 socbidr_00 Frac_imm00 age_00 Fem_00"
	foreach x of local var {
	sum `x', detail
	replace `x'=(`x'-r(min))/(r(max)-r(min))
	}

	* Generating the NQ and the SQ variables that the referees requested 
	gen cluster2=round(d1_fpneg,1)
	gen NQ=inc_00+anstalld_00+ys_00
	sum NQ
	replace NQ=(NQ-r(mean))/(r(sd))
	
	gen SQ=Frac_imm00+age_00+Fem_00+socbidr_00
	sum SQ
	replace SQ=(SQ-r(mean))/(r(sd))
	
	* Creating the figures 
		gen TP_norm=Frac_nonWest-fpneg_search1990_mstar
		replace Dn1990=SQ
		rename Dn1990 DN1990
		rename TP_norm tp_norm
		gen TP_norm=round(tp_norm)
		
		forvalues i=-99(2)99 {
			replace TP_norm=TP_norm+1 if TP_norm==`i'
			}
		
		bysort TP_norm: egen Dn1990=mean(DN1990)
		egen mgrowth=mean(Dn1990)
		mkmat mgrowth, matrix(mg)
		scalar temp_mg=mg[1,1]
		local mNgr=temp_mg	
		
		gen TP_normp=TP_norm if TP_norm<=0
		gen Dn1990p=Dn1990 if TP_norm<=0
		gen TP_normpost=TP_norm if TP_norm>0
		gen Dn1990post=Dn1990 if TP_norm>0
		drop if TP_norm>40
		sum SQ
		
		twoway (scatter Dn1990 TP_norm, xline(0) yline(0.033) ylabel(-2(1)1, angle(0))) (lpoly Dn1990p TP_normp [aw=sN_tot1990] if inrange(TP_norm,-18,0), degree(1) bwidth(5)) (lpoly Dn1990post TP_normpost[aw=sN_tot1990], degree(1) bwidth(5))

		
***********
* TABLE 1 *
***********

* 1990
	quietly {
	use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000.dta", clear
	sort k2

* Using the same groups as Card, Mas and Rothstein: 
	gen Group_fraction=0
	replace Group_fraction=1 if Frac_nonWest<5
	replace Group_fraction=2 if Frac_nonWest<20 & Frac_nonWest>=5
	replace Group_fraction=3 if Frac_nonWest<40 & Frac_nonWest>=20
	replace Group_fraction=4 if Frac_nonWest>=40

* Keeping analysis municipalities 
	keep if k2==1 | k2==8 | k2==12

* Percent sams areas in sample, native growth, total growth
	forvalues i=1(1)4 {
		su Dn1990 if Group_fraction==`i'
		scalar obs1_`i'=r(N)
		scalar mean1_`i'=r(mean)
		scalar sd1_`i'=r(sd) 
		}
	forvalues i=1(1)4 {
		su Dtot_sams1990 if Group_fraction==`i'
		scalar obs2_`i'=r(N)
		scalar mean2_`i'=r(mean)
		scalar sd2_`i'=r(sd) 
		}
}
* Displaying results 
scalar list obs1_1 mean1_1 sd1_1 obs1_2 mean1_2 sd1_2 obs1_3 mean1_3 sd1_3 obs1_4 mean1_4 sd1_4
display obs1_1+obs1_2+obs1_3+obs1_4
scalar list obs2_1 mean2_1 sd2_1 obs2_2 mean2_2 sd2_2 obs2_3 mean2_3 sd2_3 obs2_4 mean2_4 sd2_4
display obs2_1+obs2_2+obs2_3+obs2_4

* 2000
quietly {
use "P:\2016\79\DTA files segregation\[I]_TP_2000_2010.dta", clear
sort k2

* Using the same groups as Card, Mas and Rothstein
gen Group_fraction=0
replace Group_fraction=1 if Frac_nonWest<5
replace Group_fraction=2 if Frac_nonWest<20 & Frac_nonWest>=5
replace Group_fraction=3 if Frac_nonWest<40 & Frac_nonWest>=20
replace Group_fraction=4 if Frac_nonWest>=40

* Keeping analysis municipalities
keep if k2==1 | k2==8 | k2==13


* Percent sams areas in sample, native growth, total growth
forvalues i=1(1)4 {
	su Dn2000 if Group_fraction==`i'
	scalar obs1_`i'=r(N)
	scalar mean1_`i'=r(mean)
	scalar sd1_`i'=r(sd) 
	}
forvalues i=1(1)4 {
	su Dtot_sams2000 if Group_fraction==`i'
	scalar obs2_`i'=r(N)
	scalar mean2_`i'=r(mean)
	scalar sd2_`i'=r(sd) 
	}
}
* Displaying results
scalar list obs1_1 mean1_1 sd1_1 obs1_2 mean1_2 sd1_2 obs1_3 mean1_3 sd1_3 obs1_4 mean1_4 sd1_4
display obs1_1+obs1_2+obs1_3+obs1_4
scalar list obs2_1 mean2_1 sd2_1 obs2_2 mean2_2 sd2_2 obs2_3 mean2_3 sd2_3 obs2_4 mean2_4 sd2_4
display obs2_1+obs2_2+obs2_3+obs2_4



***********
* TABLE 2 *
***********

* YOUNG COHORT

	* Parental IDs from the multigenerational registry to identify parental charactersitcs (young cohort not in louise 1990 since below age 16)
 	  quietly {
		use "P:\2016\79\Leverans\Flergen_2009.dta", clear
		destring dnr201597, replace
		rename fodelsear fodar
		destring kon, replace
		destring fodar, replace 
		
		* Restricting to those that are not in Louise in 1990
		keep if fodar>=1975&fodar<=1990
		
		* Looking for duplicates
		bysort dnr201597: gen dup=cond(_N==1,0,_n)
		tabulate dup	
		drop if dup>0
		
		* Generating parental ID variable. Assume child lives with mother, unless information about mother is missing, in which case we assume child lives with father.
		destring dnr201597m dnr201597f, replace
		gen parentid=0
		replace parentid=dnr201597m
		replace parentid=dnr201597f if parentid==.
		
		* Saving 
		keep dnr201597 dnr201597m dnr201597f parentid kon fodar 
		save "P:\2016\79\DTA files segregation\temp", replace

	* Parental characteristics
		use "P:\2016\79\Leverans\Louisegeo1990.dta", clear
		destring dnr201597, replace
		destring sams, force replace
		drop if sams==.
	
		* Deleting duplicates (0)
		bysort dnr201597: gen dup=cond(_N==1,0,_n)
		drop if dup>0
		drop dup
	
		* Education and salary information 
		replace loneink=loneink*100	
		ren hutbsun sun
		sort sun
		merge sun using "P:\2016\79\DTA files segregation\sun2000_converter", nokeep		
		drop sun _merge 
	
		gen ys=int(sun2000niva/10)
		replace ys=9 if ys==10|ys==20
		replace ys=10 if ys==31
		replace ys=11 if ys==32
		replace ys=12 if ys==33
		replace ys=13 if ys==41
		replace ys=14 if ys==52
		replace ys=15 if ys==53
		replace ys=16 if ys==54
		replace ys=17 if ys==55
		replace ys=18 if ys==60
		replace ys=19 if ys==62
		replace ys=21 if ys==64
	
		* Saving two data sets for later merge
		preserve
		rename ys ysmamma
		rename loneink loneinkmamma
		rename dnr201597 dnr201597m
		rename sams samsmamma
		rename kommun kommunmamma
		keep ysmamma loneinkmamma dnr201597m samsmamma kommunmamma
		save "P:\2016\79\DTA files segregation\mammabakgrund.dta", replace	
		restore
		
		preserve
		rename ys yspappa
		rename loneink loneinkpappa
		rename dnr201597 dnr201597f
		rename sams samspappa
		rename kommun kommunpappa
		keep yspappa loneinkpappa dnr201597f samspappa kommunpappa
		save "P:\2016\79\DTA files segregation\pappabakgrund.dta", replace	
		restore
	
		* Merging
		use "P:\2016\79\DTA files segregation\temp", clear
		destring dnr201597m dnr201597f, replace
		merge m:1 dnr201597m using "P:\2016\79\DTA files segregation\mammabakgrund.dta"
		drop if _merge==2
		drop _merge
		merge m:1 dnr201597f using "P:\2016\79\DTA files segregation\pappabakgrund.dta"
		drop if _merge==2
		drop _merge
		
		* Getting descriptives
		gen female=0
		replace female=1 if kon==2

		* Age restriction
		keep if fodar>1979
		gen age=2009-fodar-19
		
		* parental income
		gen p_inc=loneinkmamma+loneinkpappa
		replace p_inc=p_inc/2 if loneinkmamma!=. & loneinkpappa!=. 
		replace p_inc=p_inc*(280.4/207.8)
		}
			* Hela Landet
			sum female ysmamma yspappa p_inc age
			
			* Vara stader
			quietly {
			gen kommun=.
			replace kommun=kommunmamma
			replace kommun=kommunpappa if kommun==. 
			gen county=int(kommun/100)
			replace kommun=county if county==1 
			keep if kommun==1 | kommun==1280 | kommun==1480
			}
			sum female ysmamma yspappa p_inc age
		
			* Vart sample  
			quietly {
			use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
			keep if fodar>1979
		
			gen p_inc=loneinkmamma+loneinkpappa
			replace p_inc=p_inc/2 if loneinkmamma!=. & loneinkpappa!=.
			replace p_inc=p_inc*(280.4/207.8)
			
			keep if kommun90==1 | kommun90==1280 | kommun90==1480
			gen female=0
			replace female=1 if kon==2
			gen age=2009-fodar-19
			}
			sum female ysmamma yspappa p_inc age
		
	*****************
	* MIDDLE COHORT *
	*****************
		
		* Those born before 1975 are in LOUISE in 1990, and we can thus identify them directly
		quietly {
		use "P:\2016\79\Leverans\Flergen_2009.dta", clear
		destring dnr201597, replace
		rename fodelsear fodar
		destring kon, replace
		destring fodar, replace
		
		keep if fodar>=1973&fodar<=1983
		
		* Looking for duplicates
		bysort dnr201597: gen dup=cond(_N==1,0,_n)
		tabulate dup	
		drop if dup>0
		
		* Generating ID variables 
		destring dnr201597m dnr201597f, replace
		gen parentid=0
		replace parentid=dnr201597m
		replace parentid=dnr201597f if parentid==.
		
		* Saving 
		keep dnr201597 dnr201597m dnr201597f parentid kon fodar 
		save "P:\2016\79\DTA files segregation\temp", replace		
	
	* Parental characteristics 
		use "P:\2016\79\Leverans\Louisegeo1990.dta", clear
		destring dnr201597, replace
		destring sams, force replace
		drop if sams==.
	
		* Deleting duplicates (0)
		bysort dnr201597: gen dup=cond(_N==1,0,_n)
		drop if dup>0
		drop dup
	
		* Education and salary information 
		replace loneink=loneink*100	
		ren hutbsun sun
		sort sun
		merge sun using "P:\2016\79\DTA files segregation\sun2000_converter", nokeep		
		tab _merge
		drop sun _merge 
	
		gen ys=int(sun2000niva/10)
		replace ys=9 if ys==10|ys==20
		replace ys=10 if ys==31
		replace ys=11 if ys==32
		replace ys=12 if ys==33
		replace ys=13 if ys==41
		replace ys=14 if ys==52
		replace ys=15 if ys==53
		replace ys=16 if ys==54
		replace ys=17 if ys==55
		replace ys=18 if ys==60
		replace ys=19 if ys==62
		replace ys=21 if ys==64
	
		* Saving two data sets for later merge
		preserve
		rename ys ysmamma
		rename loneink loneinkmamma
		rename dnr201597 dnr201597m
		rename sams samsmamma
		rename kommun kommunmamma
		keep ysmamma loneinkmamma dnr201597m samsmamma kommunmamma
		save "P:\2016\79\DTA files segregation\mammabakgrund.dta", replace	
		restore
		
		preserve
		rename ys yspappa
		rename loneink loneinkpappa
		rename dnr201597 dnr201597f
		rename sams samspappa
		rename kommun kommunpappa
		keep yspappa loneinkpappa dnr201597f samspappa kommunpappa
		save "P:\2016\79\DTA files segregation\pappabakgrund.dta", replace	
		restore
	
		* Merging
		use "P:\2016\79\DTA files segregation\temp", clear
		destring dnr201597m dnr201597f, replace
		merge m:1 dnr201597m using "P:\2016\79\DTA files segregation\mammabakgrund.dta"
		tab _merge
		drop if _merge==2
		drop _merge
		merge m:1 dnr201597f using "P:\2016\79\DTA files segregation\pappabakgrund.dta"
		tab _merge
		drop if _merge==2
		drop _merge
		
		* Getting descriptives
		gen female=0
		replace female=1 if kon==2

		* Age restriction
		destring fodar, replace
		keep if fodar>=1973 & fodar<=1983
		gen age=2009-fodar-19
		
		* parental income
		gen p_inc=loneinkmamma+loneinkpappa
		replace p_inc=p_inc/2 if loneinkmamma!=. & loneinkpappa!=. 
		replace p_inc=p_inc*(280.4/207.8)
		}
			* Hela Landet
			sum female ysmamma yspappa p_inc age
			
			* Vara stader
			quietly {
			gen kommun2=.
			replace kommun2=kommunmamma
			replace kommun2=kommunpappa if kommun2==. 
			gen county=int(kommun2/100)
			replace kommun2=county if county==1 
			
			preserve
			use "P:\2016\79\Leverans\Louisegeo1990.dta", clear
			destring dnr201597, replace
			keep dnr201597 kommun
			save "P:\2016\79\DTA files segregation\holder", replace
			restore 
			
			merge 1:1 dnr201597 using "P:\2016\79\DTA files segregation\holder"
			drop if _merge==2
			drop _merge
			
			drop county
			gen county=int(kommun/100)
			replace kommun=county if county==1 
			replace kommun=kommun2 if kommun2!=. 
			keep if kommun==1 | kommun==1280 | kommun==1480
			}
			
			sum female ysmamma yspappa p_inc age
		
			* Vart analysis sample  
			quietly {
			use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear 
			keep if fodar>=1973&fodar<=1983
		
			gen p_inc=loneinkmamma+loneinkpappa
			replace p_inc=p_inc/2 if loneinkmamma!=. & loneinkpappa!=.
			replace p_inc=p_inc*(280.4/207.8)
			gen female=0
			replace female=1 if kon==2
		
			gen age=1990-fodar
			
			keep if kommun90==1 | kommun90==1280 | kommun90==1480
			}
			sum female ysmamma yspappa parinc age
		
		
	**************
	* OLD COHORT *
	**************
	
			quietly {
			use "P:\2016\79\Leverans\Louisegeo1990.dta", clear
			destring dnr201597, replace
			destring fodar, replace
			keep if fodar>=1948&fodar<=1958
			
			gen county=int(kommun/100)
			replace kommun=county if county==1 

			* Education and salary information 
			ren hutbsun sun
			sort sun
			merge sun using "P:\2016\79\DTA files segregation\sun2000_converter", nokeep		
			tab _merge
			drop sun _merge 
		
			gen ys=int(sun2000niva/10)
			replace ys=9 if ys==10|ys==20
			replace ys=10 if ys==31
			replace ys=11 if ys==32
			replace ys=12 if ys==33
			replace ys=13 if ys==41
			replace ys=14 if ys==52
			replace ys=15 if ys==53
			replace ys=16 if ys==54
			replace ys=17 if ys==55
			replace ys=18 if ys==60
			replace ys=19 if ys==62
			replace ys=21 if ys==64
			
			* Other variables 
			gen employed=0
			replace employed=1 if syssstatg==1

			gen female=0
			replace female=1 if kon==2
		
			gen age=1990-fodar
			replace loneink=loneink*100
			replace arbers=arbers*100
			
			gen yearssincemigration=1990-seninvar
			save "P:\2016\79\DTA files segregation\temp1", replace
			
					* Getting parental information 
					use "P:\2016\79\Leverans\Flergen_2009.dta", clear
					destring dnr201597, replace
					rename fodelsear fodar
					destring kon, replace
					destring fodar, replace
					
					* Restricting to age group
					keep if fodar>=1948 & fodar<=1958
					
					* Looking for duplicates
					bysort dnr201597: gen dup=cond(_N==1,0,_n)
					tabulate dup	
					drop if dup>0
					
					* Generating ID variables 
					destring dnr201597m dnr201597f, replace
					gen parentid=0
					replace parentid=dnr201597m
					replace parentid=dnr201597f if parentid==.
					
					* Saving 
					keep dnr201597 dnr201597m dnr201597f parentid kon fodar 
					save "P:\2016\79\DTA files segregation\temp2", replace

				* Second, need to get parental characteristics in 1990 
					use "P:\2016\79\Leverans\Louisegeo1990.dta", clear
					destring dnr201597, replace
					destring sams, force replace
					drop if sams==.
				
					* Deleting duplicates (0)
					bysort dnr201597: gen dup=cond(_N==1,0,_n)
					drop if dup>0
					drop dup
				
					* Education and salary information 
					replace loneink=loneink*100	
					ren hutbsun sun
					sort sun
					merge sun using "P:\2016\79\DTA files segregation\sun2000_converter", nokeep		
					tab _merge
					drop sun _merge 
				
					gen ys=int(sun2000niva/10)
					replace ys=9 if ys==10|ys==20
					replace ys=10 if ys==31
					replace ys=11 if ys==32
					replace ys=12 if ys==33
					replace ys=13 if ys==41
					replace ys=14 if ys==52
					replace ys=15 if ys==53
					replace ys=16 if ys==54
					replace ys=17 if ys==55
					replace ys=18 if ys==60
					replace ys=19 if ys==62
					replace ys=21 if ys==64
				
					* Saving two data sets for later merge
					preserve
					rename ys ysmamma
					rename loneink loneinkmamma
					rename dnr201597 dnr201597m
					rename sams samsmamma
					rename kommun kommunmamma
					keep ysmamma loneinkmamma dnr201597m samsmamma kommunmamma
					save "P:\2016\79\DTA files segregation\mammabakgrund.dta", replace	
					restore
					
					preserve
					rename ys yspappa
					rename loneink loneinkpappa
					rename dnr201597 dnr201597f
					rename sams samspappa
					rename kommun kommunpappa
					keep yspappa loneinkpappa dnr201597f samspappa kommunpappa
					save "P:\2016\79\DTA files segregation\pappabakgrund.dta", replace	
					restore
				
				
					* Merging
					use "P:\2016\79\DTA files segregation\temp2", clear
					destring dnr201597m dnr201597f, replace
					merge m:1 dnr201597m using "P:\2016\79\DTA files segregation\mammabakgrund.dta"
					drop if _merge==2
					drop _merge
					merge m:1 dnr201597f using "P:\2016\79\DTA files segregation\pappabakgrund.dta"
					drop if _merge==2
					drop _merge
						
					gen p_inc=loneinkmamma+loneinkpappa
					replace p_inc=p_inc/2 if loneinkmamma!=. & loneinkpappa!=.
			
					keep dnr201597 ysmamma yspappa p_inc
					save "P:\2016\79\DTA files segregation\temp2", replace
					
			use "P:\2016\79\DTA files segregation\temp1", clear
			merge 1:1 dnr201597 using "P:\2016\79\DTA files segregation\temp2"
			drop if _merge==2
			drop _merge
			
			* Deflating values
			replace loneink=loneink*(280.4/207.8)
			replace p_inc=p_inc*(280.4/207.8)
			
			replace socbidrpersf=socbidrpersf*100
			replace socbidrpersf=socbidrpersf*(280.4/207.8)
			
			replace arbers=arbers*29700
			replace arbers=arbers*(280.4/207.8)
			
			gen socialbidrag=socbidrpersf!=0
			replace socialbidrag=. if socbidrpersf==.
}
	* Getting descriptive statistics 
	
		* Whole country
		sum employed female age loneink arbers socbidrpersf socialbidrag ysmamma yspappa p_inc

		* Our cities 
		keep if kommun==1 | kommun==1280 | kommun==1480
		sum employed female age loneink arbers socbidrpersf socialbidrag ysmamma yspappa p_inc
		
		* Our sample 
		quietly {
		use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
		keep if fodar>=1948&fodar<=1958
		keep if kommun90==1 | kommun90==1280 | kommun90==1480

		
		* Variables 
		gen employed=0
		replace employed=1 if syssstatg90==1

		gen female=0
		replace female=1 if kon==2
		
		gen age=1990-fodar
	
		gen p_inc=loneinkmamma+loneinkpappa
		replace p_inc=p_inc/2 if loneinkmamma!=. & loneinkpappa!=.
		replace p_inc=p_inc*(280.4/207.8)
		}
		
		replace socbidrpersf90=socbidrpersf90*100
		replace socbidrpersf90=socbidrpersf90*(280.4/207.8)
		
		gen socialbidrag=socbidrpersf90!=0
		replace socialbidrag=. if socbidrpersf90==.
			
		sum employed female age loneink90 arbers90 socbidrpersf90 socialbidrag ysmamma yspappa p_inc

		
***********
* TABLE 3 *
***********

* Preliminary commands
	clear
	set mem 64m
	use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000_partialexposure.dta", clear
	sort k2	
	
* Constraining the sample 
	keep if searchsamp==0
	keep if main==1
	estimates clear

* Estimating the regression
	local var "Dn1990 Di1990 Dtot_sams1990"
	foreach x of local var {
	
	reg `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg loginc ys female i.kommun [aw=sN_tot1990], cluster(cluster2)
	estimates store `x'_1
	
	ivregress 2sls `x' (treat=past_fpneg) d1_fpneg d2_fpneg d3_fpneg d4_fpneg loginc ys female i.kommun [aw=sN_tot1990], cluster(cluster2)
	estimates store `x'_3

		}
* Displaying the results
	estimates table _all, se stats(N r2) keep(past_fpneg treat)
	estimates table _all, star(0.1 0.05 0.01) keep(past_fpneg treat)



***********
* TABLE 4 *
***********

* Obtaining baseyear characteristics

	* Preliminary commands
	use "P:\2016\79\Leverans\Louisegeo1990.dta", clear 
	destring sams, force replace 
	gen county=int(kommun/100)
	replace kommun=county if county==1

		* Employment variable 
		gen anstalld=.
		replace anstalld=1 if syssstatg==1
		replace anstalld=0 if syssstatg==5 | syssstatg==6

		* Arbers. Converting and deflating with KPI (2005) values
		replace arbers=arbers*(280.4/207.8)

		* Education variables 
		ren hutbsun sun
		sort sun
		merge sun using "P:\2016\79\DTA files segregation\sun2000_converter", nokeep		 /*This one matches new sun2000 codes to the old sun codes*/
		tab _merge
		drop sun _merge
		
		gen jHSdropout=.	// junior HS
		replace jHSdropout=1 if sun2000niva<200
		replace jHSdropout=0 if sun2000niva>200 & sun2000niva!=999

		gen HSdropout=. 	// HS
		replace HSdropout=1 if sun2000niva>299 & sun2000niva!=999
		replace HSdropout=0 if sun2000niva<300

		* Gender
		gen female=0
		replace female=1 if kon==2

		* Age
		gen age=1990-fodar

		* University enrollment
		destring sun2000niva, replace
		gen EDU22=sun2000niva 
		gen genuniv=(EDU22==412|EDU22==522|EDU22==526|EDU22==532|EDU22==536|EDU22==546|EDU22==556|EDU22==600|EDU22==620|EDU22==640)
		drop EDU22
		replace genuniv=. if sun2000niva==999

		* Years of schooling
		replace sun2000niva=. if sun2000niva==999
		gen ys=int(sun2000niva/10)
		replace ys=9 if ys==10|ys==20
		replace ys=10 if ys==31
		replace ys=11 if ys==32
		replace ys=12 if ys==33
		replace ys=13 if ys==41
		replace ys=14 if ys==52
		replace ys=15 if ys==53
		replace ys=16 if ys==54
		replace ys=17 if ys==55
		replace ys=18 if ys==60
		replace ys=19 if ys==62
		replace ys=21 if ys==64

		* Social Bidrag
		gen socialbidrag=socbidrpersf!=0
		replace socialbidrag=. if socbidrpersf==.
		

		* Number of children
		ren dnr201597 persid
		gen year=1990
		merge 1:1 year persid using "P:\2016\79\DTA files segregation\hemmabarn_per_person"  /*matchar p塡ntal hemmabarn under 15 沠per rad (individ och 沩: OBS - hemmabarn finns inns inte f򲠱985-1989*/
		tab _merge
		drop _merge

		bysort year famid: gen N=_N
		replace N=0 if famid==""
		bysort year famid female: egen mfodar=min(fodar)
		replace Nhemmabarn0_15=0 if (fodar!=mfodar)&N>2&famid!=""

		* Income
		replace loneink=loneink*100
		replace loneink=loneink*(280.4/207.8)

		* Keeping baseyera and saving
		keep if year==1990

	
* Identifying non-western immigrants and natives
destring persid, force replace
merge m:1 persid using "P:\2016\79\DTA files segregation\Flergen_2009_noduplicates", keepusing(fader_flandgrp moder_flandgrp)   /*fodrarnas fodelseland*/
keep if _merge==3
drop _merge

merge m:1 persid using "P:\2016\79\DTA files segregation\country_of_birth"		 /*eget fodelseland*/
keep if _merge==3
drop _merge

drop if flandkod==.&fader_flandgrp==""&moder_flandgrp=="" /*Vi maste veta nagot om bakgrund*/
gen West=flandkod<=25|flandkod==26|flandkod==27|flandkod==28|flandkod==32|flandkod==33|flandkod==38|flandkod==39|flandkod==52		

destring fader_flandgrp moder_flandgrp, replace
gen Westfa=fader_flandgrp<=25|fader_flandgrp==26|fader_flandgrp==27|fader_flandgrp==28|fader_flandgrp==32|fader_flandgrp==33|fader_flandgrp==38|fader_flandgrp==39|fader_flandgrp==52	
gen Westmo=moder_flandgrp<=25|fader_flandgrp==26|moder_flandgrp==27|moder_flandgrp==28|moder_flandgrp==32|moder_flandgrp==33|moder_flandgrp==38|moder_flandgrp==39|moder_flandgrp==52	

ren West Native

gen immback_nonWest=Native==0  

replace immback_nonWest=1 if (Westfa==0&Westmo==0&moder_flandgrp!=.&fader_flandgrp!=.)
replace Native=0 if immback_nonWest==1

drop flandkod  fader_flandgrp moder_flandgrp Westfa Westmo

* Merging with treatment variable
merge m:1 sams kommun using "P:\2016\79\DTA files segregation\[I]_TP_1990_2000_partialexposure.dta"
keep if _merge==3
drop _merge

save "P:\2016\79\DTA files segregation\jumpcheck", replace

replace ysm=. if (1990-fodar)<ysm // years since migration cant be greater than age

* Aggregating to analysis level
collapse (sum) fem2=female (mean) searchsamp past_fpneg d1_fpneg loneink Nhemmabarn0_15 anstalld arbers jHSdropout HSdropout female age genuniv ys socialbidrag, by(sams kommun Native)

* Estimation
quietly {

	* Generating threshold dummy & polynomials
		foreach type in fpneg {
				gen d2_`type'=d1_`type'^2
				gen d3_`type'=d1_`type'^3
				gen d4_`type'=d1_`type'^4
				}
 
	* Constraining the sample and generating cluster variable
		keep if kommun==1 | kommun==1280 | kommun==1480
		keep if searchsamp==0
		gen cluster2=round(d1_fpneg,1)
		}

	  * Covariate test 
		estimates clear
		keep if Native==0 // switch to 1 to see for natives
		
		* Final outcome variable: Percent female over immigrant female
		merge 1:1 sams kommun using "P:\2016\79\DTA files segregation\[I]_TP_1990_2000_partialexposure.dta"
		keep if _merge==3
		replace fem2=(fem2/sN_tot1990)*100

		* Running regressions
		local var "age fem2 ys socialbidrag arbers loneink anstalld jHSdropout HSdropout genuniv Nhemmabarn0_15"
		foreach x of local var {

		reg `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg i.kommun [aw=sN_tot1990], cluster(cluster2)
		estimates store `x'
		}
	
	* Displaying the results
		estimates table _all, se stats(N r2) keep(past_fpneg)
		estimates table _all, star(0.1 0.05 0.01) keep(past_fpneg)


********************
* TABLE 5 and 6    *
********************

* Note: This code sequence currently produces results for natives. To produce results for 
* non-western immigrants, change sample selection from immback==0 to immback==1 for each of the
* cohort stratifications below. 

****************
* YOUNG COHORT *
****************
use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
estimates clear 

* Keeping analysis sample, generating treatment variables, creating cluster for se, and creating dummies for missing parental characteristics
	keep if kommun90==1 | kommun90==1280 | kommun90==1480
	gen d2_fpneg=d1_fpneg*d1_fpneg
	gen d3_fpneg=d1_fpneg^3
	gen d4_fpneg=d1_fpneg^4

	foreach i in ysmamma yspappa parint parage {
	gen miss`i'=`i'==.
	replace `i'=0 if miss`i'==1
	}

	gen cluster2=round(d1_fpneg,1)

* Cohort and Nativity Selection
	keep if immback==0
	keep if fodar>1979
	keep if searchsamp==0

	* PANEL A - 9th grade outcomes
		local var "pmeritvarde pen_ak9 pma_ak9 psv_ak9"
		foreach x of local var {
		estimates clear
		eststo: regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90, cluster(cluster2)
		esttab using "P:\2016\79\YoungNat9.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
		}

		* To Estimate Percentage changes
			local var "pmeritvarde pen_ak9 pma_ak9 psv_ak9"
			foreach x of local var {
			sum `x' if past_fpneg==0 & d1_fpneg>-2 & d1_fpneg<0
			}

	* PANEL B - high school outcomes
		estimates clear 
		gen argyes=arg!=.
		replace argyes=. if fodar<1973|fodar>1987

			local var "ptotgymn teorig NVNT newgymngpa"
			foreach x of local var {
			estimates clear
			regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90, cluster(cluster2) level(90)
			esttab using "P:\2016\79\YoungNatHS.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
			}

				* To Estimate Percentage changes
				local var " NVNT ptotgymn teorig"
				foreach x of local var {
				sum `x' if past_fpneg==0 & d1_fpneg>-2 & d1_fpneg<0
				}

			local var "genuniv11 univ20p11 ys11"
			foreach x of local var {
			estimates clear
			regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90,  cluster(cluster2) level(90)
			esttab using "P:\2016\79\YoungNatHS.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
			}

				* To Estimate Percentage changes
				local var "genuniv11 ys11"
				foreach x of local var {
				sum `x' if past_fpneg==0 & d1_fpneg>-2 & d1_fpneg<0
				}
				
	* PANEL D - labor market outcomes
	
		* Intensive margin
		local var "forvers11 arbers11 fink11"
		foreach x of local var {
		estimates clear
		regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90, cluster(cluster2) level(90)
		esttab using "P:\2016\79\YoungNatLab.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
		}

			* To Estimate Percentage changes
			local var "forvers11 arbers11 fink11"
			foreach x of local var {
			sum `x' if past_fpneg==0 & d1_fpneg>-2 & d1_fpneg<0
			}

		* Extensive Margin
		local var "forvers11_prob arbers11_prob fink11_prob"
		foreach x of local var {
		estimates clear
		regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90,  cluster(cluster2) level(90)

		esttab using "P:\2016\79\YoungNatLab.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
		}

			* To Estimate Percentage changes
			local var "forvers11_prob arbers11_prob fink11_prob"
			foreach x of local var {
			sum `x' if past_fpneg==0 & d1_fpneg>-2 & d1_fpneg<0
			}

*****************
* MIDDLE COHORT *
*****************

* Obtaining data, restricting to analysis sample, missing parental characteristics dummies, creating standard error cluster variable, generating treatment variables
	use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
	estimates clear 
	keep if kommun90==1 | kommun90==1280 | kommun90==1480

	gen d2_fpneg=d1_fpneg*d1_fpneg
	gen d3_fpneg=d1_fpneg^3
	gen d4_fpneg=d1_fpneg^4

	foreach i in ysmamma yspappa parint parage {
	gen miss`i'=`i'==.
	replace `i'=0 if miss`i'==1
	}

	gen cluster2=round(d1_fpneg,1)

	keep if immback==0
	keep if fodar>=1973&fodar<=1983
	keep if searchsamp==0

	* PANEL A - 9th grade outcomes
	local var "pmeritvarde pen_ak9 pma_ak9 psv_ak9"
	foreach x of local var {
	estimates clear
	eststo: regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90, cluster(cluster2)
	esttab using "P:\2016\79\MidNat9.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
	}

		* To Estimate Percentage changes
		local var "pmeritvarde pen_ak9 pma_ak9 psv_ak9"
		foreach x of local var {
		sum `x' if past_fpneg==0 & d1_fpneg>-2 & d1_fpneg<0
		}

	* PANEL B - High School Outcomes
	estimates clear 
	gen argyes=arg!=.
	replace argyes=. if fodar<1973|fodar>1987

		local var "ptotgymn teorig NVNT newgymngpa"
		foreach x of local var {
		estimates clear
		regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90,  cluster(cluster2) level(90)
		esttab using "P:\2016\79\MidNatHS.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
		}

			* To Estimate Percentage changes
			local var " NVNT ptotgymn teorig"
			foreach x of local var {
			sum `x' if past_fpneg==0 & d1_fpneg>-2 & d1_fpneg<0
			}

	* PANEL C - university outcomes
	local var " genuniv11 ys11"
	foreach x of local var {
	estimates clear
	regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90,  cluster(cluster2) level(90)
	esttab using "P:\2016\79\MidNatHS.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
	}

		* To Estimate Percentage changes
		local var "genuniv11 ys11"
		foreach x of local var {
		sum `x' if past_fpneg==0 & d1_fpneg>-2 & d1_fpneg<0
		}

	* PANEL D - labor market outcomes
	local var "forvers11 arbers11 fink11"
	foreach x of local var {
	estimates clear
	regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90,  cluster(cluster2) level(90)
	esttab using "P:\2016\79\MidNatLab.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
	}

		* To Estimate Percentage changes
		local var "forvers11 arbers11 fink11"
		foreach x of local var {
		sum `x' if past_fpneg==0 & d1_fpneg>-2 & d1_fpneg<0
		}

	* Extensive Margin
	local var "forvers11_prob arbers11_prob fink11_prob"
	foreach x of local var {
	estimates clear
	regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90,  cluster(cluster2) level(90)
	esttab using "P:\2015\97\MadNatLab.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
	}

		* To Estimate Percentage changes
		local var "forvers11_prob arbers11_prob fink11_prob"
		foreach x of local var {
		sum `x' if treat==0 & d1_fpneg>-2 & d1_fpneg<0
		}
*/
*/
**************
* OLD COHORT *
**************

	* Obtaining data, keeping analysis sample, generating treatment variable and cluster for standard error, dummies for missing parental characteristics
	use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
	estimates clear 
	keep if kommun90==1 | kommun90==1280 | kommun90==1480

	gen d2_fpneg=d1_fpneg*d1_fpneg
	gen d3_fpneg=d1_fpneg^3
	gen d4_fpneg=d1_fpneg^4
	gen cluster2=round(d1_fpneg,1)

	foreach i in ys90 inc_NOarbers90 {
	gen miss`i'=`i'==.
	replace `i'=0 if miss`i'==1
	}

	keep if immback==0
	keep if fodar>=1948&fodar<=1958
	keep if searchsamp==0

		* PANEL D - Labor market outcomes
		local var "forvers11 arbers11 fink11"
		foreach x of local var {
		estimates clear
		regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ys90 inc_NOarbers90 miss* kon i.fodar i.kommun90, cluster(cluster2) level(90)
		esttab using "P:\2016\79\OldNatLab.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
		}

			* To Estimate Percentage changes
			local var "forvers11 arbers11 fink11"
			foreach x of local var {
			sum `x' if past_fpneg==0 & d1_fpneg>-2 & d1_fpneg<0
			}

		* Extensive Margin
		local var "forvers11_prob arbers11_prob fink11_prob"
		foreach x of local var {
		estimates clear
		regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ys90 inc_NOarbers90 miss* kon i.fodar i.kommun90,  cluster(cluster2) level(90)
		esttab using "P:\2015\97\OldNatLab.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
		}
		
			* To Estimate Percentage changes
			local var "forvers11_prob fink11_prob"
			foreach x of local var {
			sum `x' if treat==0 & d1_fpneg>-2 & d1_fpneg<0
			}



***********
* TABLE 7 *
***********

* Note: File currently runs for native leavers. To obtain results for non-western immigrants, 
* replace immback==0 with immback==1


* 1. LEAVERS 

	****************
	* YOUNG COHORT * 
	****************

	* Obtaining data, generating treatment variables, creating cluster for se and dummies for missing parental characteristics
		use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
		estimates clear 
		keep if kommun90==1 | kommun90==1280 | kommun90==1480
		gen d2_fpneg=d1_fpneg*d1_fpneg
		gen d3_fpneg=d1_fpneg^3
		gen d4_fpneg=d1_fpneg^4

		foreach i in ysmamma yspappa parint parage {
		gen miss`i'=`i'==.
		replace `i'=0 if miss`i'==1
		}

		gen cluster2=round(d1_fpneg,1)

	* Cohort and Nativity Selection
		keep if immback==0
		keep if fodar>1979
		keep if searchsamp==0
		keep if sams90!=sams00 & past_fpneg==1  | past_fpneg==0

	* Running regressions
		local var "pmeritvarde psv_ak9 pma_ak9 pen_ak9 teorig NVNT ptotgymn"
		foreach x of local var {
		estimates clear
		eststo: regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90, cluster(cluster2)
		esttab using "P:\2016\79\YoungNatL.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
		}

	*****************
	* MIDDLE COHORT *
	*****************

	* Obtaining data, generating treatment variables, creating cluster for se and dummies for missing parental charactersitics
		use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
		estimates clear 
		keep if kommun90==1 | kommun90==1280 | kommun90==1480

		gen d2_fpneg=d1_fpneg*d1_fpneg
		gen d3_fpneg=d1_fpneg^3
		gen d4_fpneg=d1_fpneg^4

		foreach i in ysmamma yspappa parint parage {
		gen miss`i'=`i'==.
		replace `i'=0 if miss`i'==1
		}

		gen cluster2=round(d1_fpneg,1)

	* Cohort and Nativity Selection
		keep if immback==0
		keep if fodar>=1973&fodar<=1983
		keep if searchsamp==0
		keep if sams90!=sams00 & past_fpneg==1  | past_fpneg==0

	* Running regressions
		local var "pmeritvarde psv_ak9 pma_ak9 pen_ak9 teorig NVNT ptotgymn"
		foreach x of local var {
		estimates clear
		eststo: regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90, cluster(cluster2)
		esttab using "P:\2016\79\MidNatL.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
		}


* 2. STAYERS

	****************
	* YOUNG COHORT * 
	****************

	* Obtaining data, generating treatment variables, creating cluster for se and dummies for missing parental characteristics
		use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
		estimates clear 
		keep if kommun90==1 | kommun90==1280 | kommun90==1480
		gen d2_fpneg=d1_fpneg*d1_fpneg
		gen d3_fpneg=d1_fpneg^3
		gen d4_fpneg=d1_fpneg^4

		foreach i in ysmamma yspappa parint parage {
		gen miss`i'=`i'==.
		replace `i'=0 if miss`i'==1
		}

		gen cluster2=round(d1_fpneg,1)

	* Cohort and Nativity Selection
		keep if immback==0
		keep if fodar>1979
		keep if searchsamp==0
		keep if sams90==sams00 & past_fpneg==1  | past_fpneg==0

	* Running regressions
		local var "pmeritvarde psv_ak9 pma_ak9 pen_ak9 teorig NVNT ptotgymn"
		foreach x of local var {
		estimates clear
		eststo: regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90, cluster(cluster2)
		esttab using "P:\2016\79\YoungNatS.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
		}

	*****************
	* MIDDLE COHORT *
	*****************

	* Obtaining data, generating treatment variables, creating cluster for se and dummies for missing parental charactersitics
		use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
		estimates clear 
		keep if kommun90==1 | kommun90==1280 | kommun90==1480

		gen d2_fpneg=d1_fpneg*d1_fpneg
		gen d3_fpneg=d1_fpneg^3
		gen d4_fpneg=d1_fpneg^4

		foreach i in ysmamma yspappa parint parage {
		gen miss`i'=`i'==.
		replace `i'=0 if miss`i'==1
		}

		gen cluster2=round(d1_fpneg,1)

	* Cohort and Nativity Selection
		keep if immback==0
		keep if fodar>=1973&fodar<=1983
		keep if searchsamp==0
		keep if sams90==sams00 & past_fpneg==1  | past_fpneg==0

	* Running regressions
		local var "pmeritvarde psv_ak9 pma_ak9 pen_ak9 teorig NVNT ptotgymn"
		foreach x of local var {
		estimates clear
		eststo: regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90, cluster(cluster2)
		esttab using "P:\2016\79\MidNatS.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
		}
