% Prepare data for Panel C of Table 3
clear
warning('off','all')

% Load
clc
A = importdata('examiner_data.txt',',',1);

artunit_year_id = A.data(:,1);
N = max(artunit_year_id);

examiner_id = A.data(:,2);

cases = A.data(:,3);
cases_cell = cell(N,1);
for i=1:N
    cases_cell{i} = cases(artunit_year_id == i);  
end

litigated = A.data(:,4);
npe = A.data(:,5);
npe_litigated = A.data(:,6);
iv = A.data(:,7);
accept = A.data(:,8); 
r101 = A.data(:,9);
r102a = A.data(:,10);
r103a = A.data(:,11);
r112b = A.data(:,12);
nonnpe = A.data(:,13);

myopts = optimset('TolFun', 1e-10, 'MaxFunEvals', 100000,'MaxIter',10000, 'display','off');


%% 1) NPE

% sufficient for computing posterior means
alphas = zeros(N,1);
betas = zeros(N,1);

outcome_cell = cell(N,1);
for i=1:N
    outcome_cell{i} = npe(artunit_year_id == i); 
end


parfor i=1:N

    % get the data that fits this index
    curr_npe = outcome_cell{i};
    curr_cases = cases_cell{i};
    
    % figure out a sensible starting value
    rat = sum(curr_npe) / sum(curr_cases); 
    
    if sum(curr_npe) == 0
        alphas(i) = 0;
        betas(i) = 0;
    else % some npe in the year (currently including all art units)
        beta_init = 0.001/rat;
        params_init = sqrt([0.001 beta_init]);

        try
         [params_hat,f] = fminsearch(@(t) ...
             -beta_likelihood( curr_npe, curr_cases, t ), params_init, myopts);
        catch
            alphas(i) = -1;
            betas(i) = -1;
            continue
        end


        alpha = params_hat(1)^2;
        beta = params_hat(2)^2;

        alphas(i) = alpha;
        betas(i) = beta;
        
        [i 1 alpha]
        
    end
    
    
end


alphas_mod = alphas(alphas>0 & betas > 0);
betas_mod = betas(alphas>0 & betas > 0);
artunit_year_id_mod = find(alphas>0 & betas > 0); 

length(artunit_year_id_mod)

distr_means = alphas_mod ./(alphas_mod+ betas_mod);
distr_vars = alphas_mod.*betas_mod./(alphas_mod+betas_mod).^2./(alphas_mod+betas_mod+1);
distr_std = distr_vars.^(0.5);

A = [artunit_year_id_mod alphas_mod betas_mod distr_means distr_vars distr_std];
dlmwrite('estimates_npe.txt',A,',') 


%% 2) Litigated

alphas = zeros(N,1);
betas = zeros(N,1);

outcome_cell = cell(N,1);
for i=1:N
    outcome_cell{i} = litigated(artunit_year_id == i); % TO CHANGE
end

parfor i=1:N

    curr_npe = outcome_cell{i};
    curr_cases = cases_cell{i};
 
    rat = sum(curr_npe) / sum(curr_cases); 
    
    if sum(curr_npe) == 0
        alphas(i) = 0;
        betas(i) = 0;
    else 
        beta_init = 0.001/rat;
        params_init = sqrt([0.001 beta_init]);

        try
         [params_hat,f] = fminsearch(@(t) ...
             -beta_likelihood( curr_npe, curr_cases, t ), params_init, myopts);
        catch
            alphas(i) = -1;
            betas(i) = -1;
            continue
        end

        alpha = params_hat(1)^2;
        beta = params_hat(2)^2;

        alphas(i) = alpha;
        betas(i) = beta;
        
        [i 1 alpha]
        
    end
    
    
end

alphas_mod = alphas(alphas>0 & betas > 0);
betas_mod = betas(alphas>0 & betas > 0);
artunit_year_id_mod = find(alphas>0 & betas > 0);

length(artunit_year_id_mod)

distr_means = alphas_mod ./(alphas_mod+ betas_mod);
distr_vars = alphas_mod.*betas_mod./(alphas_mod+betas_mod).^2./(alphas_mod+betas_mod+1);
distr_std = distr_vars.^(0.5);

A = [artunit_year_id_mod alphas_mod betas_mod distr_means distr_vars distr_std];
dlmwrite('estimates_litigated.txt',A,',') 


%% 3) NPE Litigated

alphas = zeros(N,1);
betas = zeros(N,1);

outcome_cell = cell(N,1);
for i=1:N
    outcome_cell{i} = npe_litigated(artunit_year_id == i); 
end

parfor i=1:N

    curr_npe = outcome_cell{i};
    curr_cases = cases_cell{i};
    
    rat = sum(curr_npe) / sum(curr_cases); 
    
    if sum(curr_npe) == 0
        alphas(i) = 0;
        betas(i) = 0;
    else 
        beta_init = 0.001/rat;
        params_init = sqrt([0.001 beta_init]);

        try
         [params_hat,f] = fminsearch(@(t) ...
             -beta_likelihood( curr_npe, curr_cases, t ), params_init, myopts);
        catch
            alphas(i) = -1;
            betas(i) = -1;
            continue
        end

        alpha = params_hat(1)^2;
        beta = params_hat(2)^2;

        alphas(i) = alpha;
        betas(i) = beta;
        
        [i 1 alpha]
        

        
       
    end
    
    
end

alphas_mod = alphas(alphas>0 & betas > 0);
betas_mod = betas(alphas>0 & betas > 0);
artunit_year_id_mod = find(alphas>0 & betas > 0);

length(artunit_year_id_mod)

distr_means = alphas_mod ./(alphas_mod+ betas_mod);
distr_vars = alphas_mod.*betas_mod./(alphas_mod+betas_mod).^2./(alphas_mod+betas_mod+1);
distr_std = distr_vars.^(0.5);


A = [artunit_year_id_mod alphas_mod betas_mod distr_means distr_vars distr_std];
dlmwrite('estimates_npe_litigated.txt',A,',')

