****************
*** Figure 4 ***
****************

foreach group in Intellectual_Ventures NPE_noIV ///
NPE_portfolio_small NPE_portfolio_smallpurchase {

foreach x in pcwordcount  {

use examiner_effect_dataset_v2, clear
gen NPE_noIV = (NPE_portfolio == 1) & (Intellectual_Ventures == 0)

gen outcome = `group'

* compute baseline rate 
sum outcome, d
gen outcome_baseline=r(mean)

* bring in leave-one-out examiner effects
merge 1:1 application using `x'_effect_loo
keep if _merge==3
drop _merge
egen examiner_id=group(examiner)
bysort examiner_id: gen grantn=[_N]

* bring in corresponding signal SD 
merge m:1 examiner using `x'_examiner_effect, keepusing(x_signal_sd)
keep if _merge==3
drop _merge

* standardized coeffs
gen loo_shrunk_examiner_effect_sd=loo_shrunk_examiner_effect/x_signal_sd*outcome_baseline
* unweighted 
clear matrix
areg outcome loo_shrunk_examiner_effect_sd, absorb(year_artunit) cluster(examiner_id)
matrix b=e(b) 
gen coeff_sd=b[1,1]
matrix v=e(V) 
gen se_sd=sqrt(v[1,1])
matrix table=r(table)
gen pvalue_sd=table[4,1]
gen N_sd=e(N)
* weighted 
clear matrix
areg outcome loo_shrunk_examiner_effect_sd [aw=grantn], absorb(year_artunit) cluster(examiner_id)
matrix b=e(b) 
gen coeff_sd_w=b[1,1]
matrix v=e(V) 
gen se_sd_w=sqrt(v[1,1])
matrix table=r(table)
gen pvalue_sd_w=table[4,1]
gen N_sd_w=e(N)

gen npe_type="`group'"
gen predictor="`x'"
keep npe_type predictor coeff_* se_* pvalue* N_*
order npe_type predictor
duplicates drop 

append using loo_results_origin
save loo_results_origin, replace
}
}


