***************
*** Table 7 ***
***************

clear
gen variable = ""
save Table7, replace


/////////
// IPR //
/////////

clear
use examiner_effect_dataset_v2

drop if patent == .

foreach v in ipr_filed {

	preserve
	summ `v', detail
	gen avg = r(mean)
	gen sd = r(sd)
	gen median = r(p50)
	gen min = r(min)
	gen max = r(max)
	gen N = r(N) 
	
	keep avg sd median min max N
	keep if _n == 1
	gen variable = "`v'"
	
	append using Table7
	save Table7, replace
	
	restore
}



merge 1:1 application using IPR_Not_Instituted, force
keep if _merge == 1 | _merge == 3
gen ipr_not_instituted = (_merge == 3)
tab ipr_not_instituted
drop _merge

merge 1:1 application using IPR_Instituted, force 
keep if _merge == 1 | _merge == 3
gen ipr_instituted = (_merge == 3)
tab ipr_instituted
drop _merge

keep if ipr_instituted == 1 | ipr_not_instituted == 1

foreach v in ipr_instituted {

	preserve
	summ `v', detail
	gen avg = r(mean)
	gen sd = r(sd)
	gen median = r(p50)
	gen min = r(min)
	gen max = r(max)
	gen N = r(N) 
	
	keep avg sd median min max N
	keep if _n == 1
	gen variable = "`v'"
	
	append using Table7
	save Table7, replace
	
	restore
}

////////////
// Courts //
////////////

clear
use examiner_effect_dataset_v2 

drop if patent == .

merge 1:1 application using "$db\Data and Code\LexMachina Data\Trial Data\trial_patent_summary" 
keep if _merge == 1 | _merge == 3
gen trial_patents = (_merge == 3)
drop _merge


foreach v in  Infringement Invalidity Unenforceability Damages {
replace `v' = 1 if `v' != . & `v' > 1
replace `v' = . if trial_patents == 0 // conditional analysis
tab `v'
tab `v' if trial_patents == 1
}

keep if trial_patents == 1


foreach v in Infringement Invalidity {

	preserve
	summ `v', detail
	gen avg = r(mean)
	gen sd = r(sd)
	gen median = r(p50)
	gen min = r(min)
	gen max = r(max)
	gen N = r(N) /
	
	keep avg sd median min max N
	keep if _n == 1
	gen variable = "`v'"

	append using Table7
	save Table7, replace
	
	restore
}

//////////////////////////////////
// Reissuance and Reexamination //
//////////////////////////////////

clear
use examiner_effect_dataset_v2

drop if patent == .

merge 1:1 application using reissued_patent_application_numbers
keep if _merge == 1 | _merge == 3
gen reissued = (_merge == 3)
drop _merge

tab reissued

merge 1:1 application using reexamined_patent_application_numbers
keep if _merge == 1 | _merge == 3
gen reexamined = (_merge == 3)
drop _merge

tab reexamined

merge 1:1 application using reissued_patent_applications_two_years
keep if _merge == 1 | _merge == 3
gen reissued_two_year = (_merge == 3)
drop _merge

foreach v in reissued reexamined reissued_two_year {

	preserve
	summ `v', detail
	gen avg = r(mean)
	gen sd = r(sd)
	gen median = r(p50)
	gen min = r(min)
	gen max = r(max)
	gen N = r(N) 
	
	keep avg sd median min max N
	keep if _n == 1
	gen variable = "`v'"
	
	append using Table7
	save Table7, replace
	
	restore
}
