%% percentile
% 
% Inputs: vector or matrix x and scalar pct
% Returns xp, the pct percentile of x, i.e.the smallest z s.t. 
%   pr(x<=z) = pct.

function xp = percentile(x, pct)

   if pct > 1 
       fprintf(' Warning: pct should be in (0,1). Rescaling \n');
       pct = pct/100;
   end 
   if pct <  0
       fprintf(' Error: pct must be non-negative. \n')
   end 

    xSorted = sort(x);
    pIX = max(floor(pct.*length(x)), 1);
    xp = xSorted(pIX,:);
    
end