%% f_BSSE_e 
% 
% bootstrap standard errors for elasticity only.
function [se se_good, lb, ub, p] = calcBSSE_e(estEl, data,wMat,bunchBS, opt)

    nBoot = size(bunchBS,2);
    estV = zeros(1,nBoot);
    badSoln = zeros(1,nBoot);
    dataBS = data;
    for bs = 1:nBoot
        dataBS.bunch = bunchBS(:,bs); 
        [estV(:,bs) obj flag] = fminunc(@(e) calcGmmNoAC(e, dataBS, wMat), estEl,opt);
        
        if (obj>1e-6 && flag ~= 0)
            badSoln(bs) = 1;
        end
    end
    se = std(estV,0,2);
    se_good = std(estV(:,badSoln==0),0,2);
    lb = percentile(estV',0.025);
    ub = percentile(estV',0.975);
    p = sum(estV<1e-6,2)./nBoot;
        
end