


/********************************************************************************************
For alternative excluded regions:

    - Try +/- 2000, +/- 4000, basically +/- 1 BW.
    - Main sample
    - Calculate age-series for 59-73 yearolds, pooling 1990-1999,
        using alternative excluded regions.
    - Calculate year-series for 66-69 year olds, 1996-2004,
        using alternative excluded regions.
********************************************************************************************/

/**********************************************************/
/* Begin with 1990-1999, bunching by age, 59-73 year olds */
/**********************************************************/

    local time1 "$S_TIME"
    local sampleList = "$sampleList"
    qui foreach sample of local sampleList{

        if "`sample'" == "s1Main"               local sampleTitle "1% Sample, claim by 65, no SE Income"
        if "`sample'" == "s1Full"               local sampleTitle "1% Sample, no SE Income"
        if "`sample'" == "s1Both"               local sampleTitle "1% Sample, claim by 65"
        if "`sample'" == "s1SE"                 local sampleTitle "1% Sample, claim by 65, SE income"
        if "`sample'" == "s1Claim"              local sampleTitle "1% Sample, claimed, no SE income"
        if "`sample'" == "s1Placebo"            local sampleTitle "1% Sample, not yet claimed"

        local y1List "1990"
        foreach y1 of local y1List{

            if `y1'==1966{
                local y2 1971
                local yy "6671"
                local max = 20000
                local min = -8000
            }
            if `y1'==1972{
                local y2 1982
                local yy "7282"
                local max = 30000
                local min = -8000
            }
            if `y1'==1983{
                local y2 1989
                local yy "8389"
                local max = 30000
                local min = -10000
            }
            if `y1'==1990{
                local y2 1999
                local yy "9099"
                local max = 30000
                local min = -10000
            }
            if `y1'==2000{
                local y2 2006
                local yy "0006"
                local max = 30000
                local min = -10000
            }
            noisily di "on `y1'-`y2'"
            local bwlist 800
            foreach bw of local bwlist{
                # delimit ;
                use "$datadir/cfopSSA_`sample'_`bw'" if
                    age>=18 & age<=80 &
                    year>=`y1' & year<=`y2',
                    clear
                ;
                # delimit cr
                noisily di "  bw = `bw'"

                ** collapse dataset to counts
                collapse (sum) count (mean) real_threshold, by(realDistanceRound age)
                gen rd1k = realDistanceRound/1000
                egen total = total(count), by(age)
                gen prob = count/total
                gen order = _n
                sort order


                gen ageGraph    = .

                foreach ee of numlist 2000 3000 4000{
                    local row   0
                    gen b`ee'       = .
                    gen b`ee'SE     = .
                    gen b`ee'SEDM   = .
                
                    local exclude = round(`ee'/`bw',1)
                    foreach age of numlist 59/73{
    
                        /* set sample */
                        gen sample =  age == `age' & realDistanceRound>=`min' & realDistanceRound<=`max'
    
                        /* set upper and lower limits, trying to avoid holes in the data; not perfect */
                        local nox "nolabel"
                        local noy "nolabel"
    
                        if `age' == 59 | `age' == 64 | `age' == 69 local noy ""
                        if `age'>=69 local nox ""
    
                        # delimit ;
                        capture bunchPoly realDistanceRound prob if sample,
                            kink(0) exclude(`exclude') bw(`bw') degree(7) keep(0) print(0) nboot(100)
                        ;
                        # delimit cr
                        local rc = _rc
    
                        /* fill in for graphing */
                        local ++row
                        replace ageGraph    = `age' in `row'
                        if `rc' == 0{
                            sort order
                            replace b`ee'       = r(scaledMass) in `row'
                            replace b`ee'SE     = r(scaledMassBS) in `row'
                            replace b`ee'SEDM   = r(scaledMassSE) in `row'
    
                        } /* end if no error */
                        if `rc' != 0{
                            local rc = _rc
                            noisily di "age = `age', y1 = `y1', bw = `bw', sample = `sample': error code: `rc'"
                        } /* end if error */
    
                        drop sample
                    } /* end age loop */
                } /* end exclude loop */
                /* make time series plots */
                
                ** plot each implied bunching amount
                # delimit ;
                twoway
                    (connected b3000 ageGraph if !missing(b3000), sort lcolor(edkblue) lwidth(medthick) mcolor(edkblue) msize(small))
                    (connected b2000 ageGraph if !missing(b2000), sort lcolor(maroon) lwidth(medthick) lpattern(dash) mcolor(maroon) msize(small))
                    (connected b4000 ageGraph if !missing(b4000), sort lcolor(forest_green) lwidth(medthick) lpattern(dot) mcolor(forest_green) msize(small)),
                    title("Excess mass at kink, 59-73 year olds,")
                    subtitle("`sampleTitle', 1990-1999, BW = `bw'")
                    ylabel(, angle(horizontal) labsize(large))
                    ytitle("`title'")
                    legend(
                        order(
                        2 "1. Exclude = 2000" 
                        1 "2. Exclude = 3000"
                        3 "3. Exclude = 4000"
                        )
                        cols(3) ring(6)
                    )
                    xtitle("Age")
                    xlabel(60(5)70, labsize(large))
                    xtick(59 73, nolabel)
                    xline(62 70, lcolor(gs12))
                    xsize(10) ysize(7.5)
                    graphregion(color(white))
                ;
                # delimit cr
                graph save "$figdir/ageTS_densPolyExclude3_9099_5973_`bw'_`sample'.gph", replace
                capture window manage close graph _all

                
                /* outsheet results to a table */
                sort order
                outsheet ageGraph b2000 b2000SE b3000 b3000SE b4000 b4000SE ///	
									if !missing(ageGraph) using ///
									"$tabdir/ageTS_densPolyExclude3_9099_5973_`bw'_`sample'.txt", replace

            } /* end bw loop */
        } /* end y1 loop */
    } /* end sample loop */

    local time2 "$S_TIME"
    noisily display "Analysis 1 started `time1', ended `time2'"
    
    
/****************************************************/
/* Now look at bunching, 1996-2004, 66-69 year olds */
/****************************************************/
    local time1 = "$S_TIME"
    
    local sample = "$sampleList"
    local bw = 800
    
    if "`sample'" == "s1Main"               local sampleTitle "1% Sample, claim by 65, no SE Income"
    if "`sample'" == "s1Full"               local sampleTitle "1% Sample, no SE Income"
    if "`sample'" == "s1Both"               local sampleTitle "1% Sample, claim by 65"
    if "`sample'" == "s1SE"                 local sampleTitle "1% Sample, claim by 65, SE income"
    if "`sample'" == "s1Claim"              local sampleTitle "1% Sample, claimed, no SE income"
    if "`sample'" == "s1Placebo"            local sampleTitle "1% Sample, not yet claimed"
    
    ** Load the 1996-2004 data for 66-69 year olds
    local a1 = 66 
    local a2 = 69
    local y1 = 1996
    local y2 = 2004
    local bw = 800
    
    # delimit ;
    use "$datadir/cfopSSA_`sample'_`bw'" if 
        age>=`a1' & age<=`a2' &
        year>=`y1' & year<=`y2', 
        clear 
    ;
    # delimit cr
    
    ** collapse dataset to counts
    collapse (sum) count (mean) real_threshold, by(realDistanceRound year)
    gen rd1k = realDistanceRound / 1e3
    egen total = total(count), by(year)
    gen prob = count/total
    
	keep if realDistanceRound>=-1e4 & realDistanceRound<=3e4
	gen panelVar = realDistanceRound/`bw'
	tsset year panelVar
	gen original = 1
	tsfill
	gen filledIn = missing(original)
	assert missing(realDistanceRound) & missing(count) & missing(prob) if filledIn
	replace realDistanceRound = `bw'*panelVar if filledIn
	replace prob = 0 if filledIn
    replace rd1k = realDistanceRound/1e3
    
    ** Make time series plot, graphs
    gen order = _n
    sort order

    local row   0
    gen yearPost = . 
    
    ** define kink as +/- 3k 
    foreach ee of numlist 2000 3000 4000{
        local exclude = int(`ee'/`bw')
        
        gen b`ee' = .
        gen b`ee'SE = . 
        gen b`ee'SEDM = . 
        qui sum year
				local yMax = min(r(min), 2004)
        qui forvalues year = 1996/`yMax'{
        
            ** max values for ig high/low 
            local max = 30000
            local min = -10000
            sum realDistanceRound if year == `year'
            local max = min(`r(max)', `max')
    
            ** set sample 
            gen sample =  year == `year' & realDistanceRound<=`max' & realDistanceRound>=`min'
    
            # delimit ;
            capture bunchPoly realDistanceRound prob if sample, 
                kink(0) exclude(`exclude') bw(`bw') degree(7) keep(0) print(0) nboot(100)
            ;
            # delimit cr            
            local rc = _rc
            
            ** fill in for graphing 
            local ++row
            sort order
            replace yearPost    = `year' in `row'
            if _rc == 0{
                replace b`ee'           = r(scaledMass) in `row'
                replace b`ee'SE         = r(scaledMassBS) in `row'
                replace b`ee'SEDM       = r(scaledMassSE) in `row'
            }
            if _rc != 0{
                local rc = _rc
                noisily di "  exclude = `ee', year = `year', a1 = `a1', bw = `bw', sample = `sample': error code: `rc'"
            }
            
            
            drop sample
        } /* end year loop */
    } /* end ee loop */

    ** Plot bunching
    # delimit ;
    twoway
        (connected b3000 yearPost if !missing(b3000), sort lcolor(edkblue) lwidth(medthick) mcolor(edkblue) msize(small))
        (connected b2000 yearPost if !missing(b2000), sort lcolor(maroon) lwidth(medthick) lpattern(dash) mcolor(maroon) msize(small))
        (connected b4000 yearPost if !missing(b4000), sort lcolor(forest_green) lwidth(medthick) lpattern(dot) mcolor(forest_green) msize(small)),
        title("Excess mass at kink, 66-69 year olds,")
        subtitle("`sampleTitle', 1996-2004, BW = `bw'")
        ylabel(, angle(horizontal) labsize(large))
        ytitle("`title'")
        legend(
            order(
            2 "Exclude = 2000" 
            1 "Exclude = 3000"
            3 "Exclude = 4000"
            )
            cols(3) ring(6)
        )
        xtitle("Age")
        xlabel(1996(2)2004, labsize(large))
        xsize(10) ysize(7.5)
        graphregion(color(white))
    ;
    # delimit cr
    graph save "$figdir/yearTS_densPolyExclude3_9604_6669_`bw'_`sample'.gph", replace
    capture window manage close graph _all

    
    /* outsheet results to a table */
    sort order
    outsheet yearPost b2000 b2000SE b3000 b3000SE b4000 b4000SE if ///
			!missing(yearPost) using ///
			"$tabdir/yearTS_densPolyExclude3_9604_6669_`bw'_`sample'.txt", replace

    local time2 "$S_TIME"
    noisily display "Analysis 2 started `time1', ended `time2'"
    
    
    
