/* etAnalysisSSA_Smooth.do */
/* last udpdated: 11/28/12 */
/* the _G is for "global" to indicate that "bwlist" and "sampleList" are passed as globals */
/* when we load the data, if we're not on the nber servers (and instead on a machine with  */
/* less memory), then we load 10 percent subsamples separately and append them together.   */ 

/* change on 6/23/15 (with some intervening)
	1. Update all directories to point to "tabdir", "figdir" and "datadir"
	2. Only saving gph files
*/

/* change on 2/18/13:
    1. Reverting back to doign the full estimation using this program.
    2. Looking at 70-71 year olds and just 71 year olds. When we look
        at 71 year olds, we aggregate up to BW = 1500.
    3. Making sure to sort all tables.
    4. Exporting GPH and EPS files to separate folders.
    5. Cutting many of the year ranges that we do not study--pre 1966.
    6. Cutting many of the age ranges that we do not study--young and old.
    7. Cutting many of the densities-by-year plots that we do not study. Pre 1979.
    8. Added back dynamics.

*/

/* change on 11/28/12:
    This version uses bunchPoly instead of bunchFit.
    Meant to be used in conjunction with etAnalyssisSSA_Shift.do,
    so the only analyses run here are the ones that use the bunching estimator.
    
*/

/* change on 11/24/12:

    all bunching is now estimated using the bunchShift estimator.
    This estimator fits a polynomial through the earnings distribution,
    except it allows the intercept to differ to the right of the kink.
*/


/* changes from 11/19/12 update: 

    1. look at bunching over time among just 71 year olds, rather than 70-71 year olds.
    2. fix vertical lines on age time series plots: they shouldn't always be at 72; only put them at 72 before 1983.
    3. Look at extensive margin response
    4. Change in earnings from age t to t+1
    5. Update names from lifetime income plots. 
    6. Add section computing some information on dynamics of earnings 
*/

/********************************************************************************************/
/* 1. Bunching by age, 18-80  year olds, looking separately by period: 1955-1960,           */
/*      1961-1965, 1966-1971, 1972-1982, 1983-1989, 1990-1999, 2000-2006. Make histograms   */
/*      for 59-73 year olds.                                                                */
/*      Bunching by age, 18-80, 1961-1971 and 1972-1989.                                    */
/* 2. Bunching by year                                                                      */
/*  a. Vanilla bunching by year, 1955-2006, various age groups: 55-60, 60-61, 62-64, 62-69, */
/*      70-71, 72-75. Make histograms for 1957-1965, 1968-1976, 1979-1987, 1986-1994,       */
/*      1995-2003.                                                                          */
/*  b. Compute elasticities and adjustment costs using 1985-1994 data, looking at bunching  */
/*      by 62-64 year olds and 65-69 year olds (separately). Use a base tax rate of 0 and a */
/*      base tax rate as calculated from the SOI.                                           */
/* 3. Bunching and mortality                                                                */
/* 4. Claiming as a function of earnings                                                    */
/* 5. Look at bunching by sex, 1983-1989                                                    */
/* 6. Dynamic responses:                                                                    */
/*  Extensive margin response: Pr(exit at t+1| earnings at t)                               */
/*  Future earnings, earnings changes from t to t+1 conditional on earnings at t            */
/* 7. Persistence of bunching, 1983-1989, various ages and measures                         */
/* 8. Where do people go?                                                                   */
/*  a.  Where do people go when kink disappears? Look at density of lead earnings | at kink,*/
/*      for people about to leave the ET test vs. people just younger in the same year, or  */
/*      for people just older.                                                              */
/* 8. Where do people go?                                                                   */
/*  b. Where do people go when kink appears? Look at density of lag earnings | at kink,     */
/*      for people who just entered thethe ET test vs. people just younger in the same year.*/
/********************************************************************************************/


/* program for loading and appending the data */
capture program drop loadAppend
program define loadAppend
    syntax, data(string) append(int) if(str)

    quietly{
        /* append must be 0 or 1 */
        if `append' != 0 & `append' != 1 {
            noisily di "Error: append must be 0 (simple load) or 1 (load and append)"
        }
    
        /* just load the data if no append */
        if `append'==0 {
           use "`data'" if `if', clear
        }
    
        /* loop from 0 to 9 if append */
        if `append' == 1{
    
            /* save temp decilde datasets with only the relevant stuff */
            forvalues d=0/9{
                use "`data'_`d'" if `if', clear
                if `d'<9 save "$datadir/temp_`d'", replace
            }
    
            /* append together */
            forvalues d=0/8{
                append using "$datadir/temp_`d'"
                erase "$datadir/temp_`d'.dta"
            }
        }
    }
end

local sampleList "$sampleList"
local bwlist "$bwList"

noisily di "sampleList:"
noisily di "    local `sampleList'"
noisily di "    global $sampleList"
noisily di ""
noisily di "bwList:"
noisily di "    local `bwlist'"
noisily di "    global $bwList"


local append 1

/********************************************************************************************/
/* 1. Bunching by age, 18-80  year olds, looking separately by period: 1955-1960,           */
/*      1961-1965, 1966-1971, 1972-1982, 1983-1989, 1990-1999, 2000-2006. Make histograms   */
/*      for 59-73 year olds.                                                                */
/*      Bunching by age, 18-80, 1961-1971 and 1972-1989.                                    */
/********************************************************************************************/

local bwlist "500 800"
local append 1


    local time1 "$S_TIME"
    local nBoot = 50
    
    qui foreach sample of local sampleList{

        if "`sample'" == "s1Main"               local sampleTitle "1% Sample, claim by 65, no SE Income"
        if "`sample'" == "s1Full"               local sampleTitle "1% Sample, no SE Income"
        if "`sample'" == "s1Both"               local sampleTitle "1% Sample, claim by 65"
        if "`sample'" == "s1SE"                 local sampleTitle "1% Sample, claim by 65, SE income"
        if "`sample'" == "s1Claim"              local sampleTitle "1% Sample, claimed, no SE income"
        if "`sample'" == "s1Placebo"            local sampleTitle "1% Sample, not yet claimed"

        local y1List "1966 1972 1983 1990 2000"
        foreach y1 of local y1List{

            if `y1'==1966{
                local y2 1971
                local yy "6671"
                local max = 20000
                local min = -8000
            }
            if `y1'==1972{
                local y2 1982
                local yy "7282"
                local max = 30000
                local min = -8000
            }
            if `y1'==1983{
                local y2 1989
                local yy "8389"
                local max = 30000
                local min = -10000
            }
            if `y1'==1990{
                local y2 1999
                local yy "9099"
                local max = 30000
                local min = -10000
            }
            if `y1'==2000{
                local y2 2006
                local yy "0006"
                local max = 30000
                local min = -10000
            }
            noisily di "on `y1'-`y2'"

            foreach bw of local bwlist{
                # delimit ;
                use "$datadir/cfopSSA_`sample'_`bw'" if
                    age>=18 & age<=80 &
                    year>=`y1' & year<=`y2',
                    clear
                ;
                # delimit cr
                noisily di "  bw = `bw'"

                /* collapse dataset to counts */
                collapse (sum) count (mean) real_threshold, by(realDistanceRound age)
                gen rd1k = realDistanceRound/1000
                egen total = total(count), by(age)
                gen prob = count/total
                gen order = _n
                sort order

                local row   0
                gen b           = .
                gen bSE         = .
                gen bSEDM       = .
                gen ageGraph    = .
                
                ** Before age loop, generate bootstrap placeholders
                if (`y1' == 1990){
                    forvalues bs = 1/`nBoot'{
                        gen bsEstimate`bs' = .
                    }
                }

                local exclude = round(3000/`bw',1)
                foreach age of numlist 18/80{

                    /* set sample */
                    gen sample =  age == `age' & realDistanceRound>=`min' & realDistanceRound<=`max'
                    sum real_threshold if sample
                    local zstar = r(mean)

                    /* set upper and lower limits, trying to avoid holes in the data; not perfect */
                    
                    local nox "nolabel"
                    local noy "nolabel"

                    if `age' == 59 | `age' == 64 | `age' == 69 local noy ""
                    if `age'>=69 local nox ""

                    # delimit ;
                    capture bunchPoly realDistanceRound prob if sample, 
                        kink(0) exclude(`exclude') bw(`bw') degree(7) keep(1) print(0) nboot(100)
                    ;
                    # delimit cr
                    local rc = _rc

                    /* fill in for graphing */
                    local ++row
                    replace ageGraph    = `age' in `row'
                    if `rc' == 0{
                        sort order
                        replace b           = r(scaledMass) in `row'
                        replace bSE         = r(scaledMassBS) in `row'
                        replace bSEDM      = r(scaledMassSE) in `row'
                        
                        if `age'>=59 & `age'<=73{
                            # delimit ;
                            twoway
                                (connected prob rd1k if !missing(smoothDensity),  lcolor(navy) mcolor(navy) msize(small))
                                (line smoothDensity rd1k if !missing(smoothDensity),  lcolor(cranberry)),
                                title("`age'", ring(0))
                                xlabel(#4, `nox' labsize(large))
                                xtitle("")
                                xline(0, lcolor(gs12))
                                ylabel(#4, `noy' labsize(large))
                                legend(off)
                                graphregion(color(white))
                                name(cfop`age', replace)
																nodraw
                            ;
                            # delimit cr
                            capture window manage close graph _all
                        }
                        
                        if "`sample'" == "s1Placebo" & `age'>=59 & `age'<=64{
                        
                            local noxP "nolabel"
                            local noyP "nolabel"
                            if `age' == 59 | `age' == 62 local noyP ""
                            if `age' >= 62 local noxP ""
                            # delimit ;
                            twoway
                                (connected prob rd1k if !missing(smoothDensity),  lcolor(navy) mcolor(navy) msize(small))
                                (line smoothDensity rd1k if !missing(smoothDensity),  lcolor(cranberry)),
                                title("`age'", ring(0))
                                xlabel(#4, `noxP' labsize(large))
                                xtitle("")
                                xline(0, lcolor(gs12))
                                ylabel(#4, `noyP' labsize(large))
                                graphregion(color(white))
                                legend(off)
                                name(cfop`age'P, replace)
																nodraw
                            ;
                            # delimit cr
                            capture window manage close graph _all
                        }
                        
                        ** Bootstrap distribution for some samples
                        if (`age'>=66 & `age'<=71) & (`y1' == 1990){
                            count if sample
                            local nBins = r(N)
                            gen residuals = prob-fit if sample
                            forvalues bs = 1/`nBoot'{
                        
                                ** draw from residuals
                                sort sample realDistanceRound
                                gen use = 1+round((`nBins'-1)*uniform(),1)
                                by sample: gen bsProb = prob + residuals[use] if sample
                        
                                ** compute bunching for BS sample, save numbers
                                # delimit ;
                                capture bunchPoly realDistanceRound bsProb if sample,
                                    kink(0) exclude(`exclude') bw(`bw') degree(7) keep(0) print(0) nboot(0)
                                ;
                                # delimit cr
                                sort order
                                replace bsEstimate`bs' = r(scaledMass) in `row'
                                drop use bsProb
                            }
                            ** end bootstrap loop
                            drop residuals
                        }
                        ** end if for bootstrapping
                        
                        
                        if "`sample'" == "s1Placebo" & `age'>=59 & `age'<=64{
                        
                            local noxP "nolabel"
                            local noyP "nolabel"
                            if `age' == 59 | `age' == 62 local noyP ""
                            if `age' >= 62 local noxP ""
                            # delimit ;
                            twoway
															(connected prob rd1k if !missing(smoothDensity),  lcolor(navy) mcolor(navy) msize(small))
															(line smoothDensity rd1k if !missing(smoothDensity),  lcolor(cranberry)),
															title("`age'", ring(0))
															xlabel(#4, `noxP' labsize(large))
															xtitle("")
															xline(0, lcolor(gs12))
															ylabel(#4, `noyP' labsize(large))
															graphregion(color(white))
															legend(off)
															name(cfop`age'P, replace)
															nodraw
                            ;
                            # delimit cr
                            capture window manage close graph _all
                        }
                        drop smoothDensity
                    } /* end if no error */
                    if `rc' != 0 {
                        local rc = _rc
                        noisily di "    age = `age', y1 = `y1', bw = `bw', sample = `sample': error code: `rc'"

                        /* make a filler graph */
                        if `age'>=59 & `age'<=73{
													gen zero_temp = 0 in 1
													# delimit ;
													twoway scatter zero_temp rd1k if _n==1,
														name(cfop`age', replace) legend(off) xtitle("") ytitle("") title("")
														xlabel(,nolabel) ylabel(,nolabel)
														graphregion(color(white))
														nodraw
													;
													# delimit cr
														
															
													if "`sample'" == "s1Placebo" & `age'>=59 & `age'<=64{
													
														local noxP "nolabel"
														local noyP "nolabel"
														if `age' == 59 | `age' == 62 local noyP ""
														if `age' >= 62 local noxP ""
														# delimit ;
														twoway scatter zero_temp rd1k if _n==1,
															name(cfop`age'P, replace) legend(off) xtitle("") ytitle("") title("")
															xlabel(,nolabel) ylabel(,nolabel)
															graphregion(color(white))
															nodraw
														;
														# delimit cr
													}
														
                            replace b           = . in `row'
                            replace bSE         = . in `row'
                            drop zero_temp
                        }
												
                        
                    } /* end if error */

                    drop sample 
                } /* end age loop */

                /* assemble into 15 panel graph */
                # delimit ;
                graph combine
									cfop59 cfop60 cfop61
									cfop62 cfop63 cfop64
									cfop65 cfop66 cfop67
									cfop68 cfop69 cfop70
									cfop71 cfop72 cfop73,
									cols(5) title("Distribution of Earnings, 59-73 year olds")
									subtitle("`sampleTitle', `y1'-`y2', BW = `bw'")
									xsize(10) ysize(7.5) imargin(tiny)
									l1title("Percent") b1title("Real distance to kink (thousands of dollars)")
									xcommon ycommon
									graphregion(color(white))
									nodraw
                ;
                # delimit cr
                graph save "$figdir/densPoly_`yy'_5973_`bw'_`sample'", replace
                capture window manage close graph _all

                /* assemble into 6 panel graph for placebo sample */
                if "`sample'" == "s1Placebo"{
                    # delimit ;
                    graph combine
											cfop59P cfop60P cfop61P
											cfop62P cfop63P cfop64P,
											cols(3) title("Distribution of Earnings, 59-64 year olds")
											subtitle("`sampleTitle', `y1'-`y2', BW = `bw'")
											xsize(10) ysize(7.5) imargin(tiny)
											l1title("Percent") b1title("Real distance to kink (thousands of dollars)")
											xcommon ycommon
											graphregion(color(white))
											nodraw
                    ;
                    # delimit cr
                    graph save "$figdir/densPoly_`yy'_5964_`bw'_`sample'", replace
                    capture window manage close graph _all
                }

                /* make time series plots */
                foreach stat in b{
									if "`stat'" == "el" local title "Implied Elasticity"
									if "`stat'" == "b" local title  "Normalized excess mass at kink"

									/* make upper and lower confidence bounds */
									gen upper = `stat'+1.96*`stat'SE
									gen lower = `stat'-1.96*`stat'SE

									/* plot stats plus confidence bands */
									foreach aStart of numlist 18 59 {
										if `y1' < 1983 local l2 72
										if `y1' >=1983 local l2 70
								
										if `aStart' == 18 local aStop 80
										if `aStart' == 59 local aStop 73
										# delimit ;
										twoway
											(connected `stat' ageGraph if !missing(`stat') & ageGraph>=`aStart' & ageGraph<=`aStop', sort lcolor(edkblue) lwidth(medthick) mcolor(edkblue))
											(line       upper ageGraph if !missing(`stat') & ageGraph>=`aStart' & ageGraph<=`aStop', sort lcolor(maroon) lwidth(medthick) lpattern(dash))
											(line       lower ageGraph if !missing(`stat') & ageGraph>=`aStart' & ageGraph<=`aStop', sort lcolor(maroon) lwidth(medthick) lpattern(dash)),
											title("`title', `aStart'-`aStop' year olds")
											subtitle("`sampleTitle', `y1'-`y2', BW = `bw'")
											ylabel(, angle(horizontal) labsize(large))
											ytitle("`title'")
											legend(off)
											xtitle("Age")
											xlabel(, labsize(large))
											xline(62 `l2', lcolor(gs12))
											xsize(10) ysize(7.5)
											graphregion(color(white))
											nodraw
										;
										# delimit cr
										graph save "$figdir/ageTS_densPoly_`stat'_`yy'_`aStart'`aStop'_`bw'_`sample'.gph", replace
										capture window manage close graph _all
									}
									drop upper lower
                }
                /* outsheet results to a table */
                sort order
                outsheet ageGraph b bSE`a1' if !missing(age) using ///
									"$tabdir/ageStatsDensPoly_`yy'_5973_`bw'_`sample'.txt", replace

                ** outsheet bootsrap distribution if y1 appropriate
                if `y1' == 1990 outsheet ageGraph bsEstimate* if ///
									!missing(bsEstimate1) using ///
									"$tabdir/ageBS_9099_6671_`bw'_`sample'.txt", replace
                
                ** Repeat, but look at 3-year intervals
                gen age3 = round(age,3)
                collapse (sum) count, by(realDistanceRound age3)
                gen rd1k = realDistanceRound/1000
                egen total = total(count), by(age)
                gen prob = count/total
                gen order = _n
                gen bRound = .
                gen bRoundSE = .
                gen bRoundSEDM = .
                gen ageGraph = .
                qui levelsof age3, local(ages)
                
                foreach a of local ages{
									gen sample =  age3 == `a' & realDistanceRound>=`min' & realDistanceRound<=`max'
									# delimit ;
									capture bunchPoly realDistanceRound prob if sample, 
											kink(0) exclude(`exclude') bw(`bw') degree(7) keep(0) print(0) nboot(100)
									;
									# delimit cr
									local rc = _rc

									/* fill in for graphing */
									local ++row
									sort order
									replace ageGraph    = `a' in `row'
									
									if `rc' == 0 {
										replace bRound      = r(scaledMass) in `row'
										replace bRoundSE    = r(scaledMassBS) in `row'
										replace bRoundSEDM   = r(scaledMassSE) in `row'
									}
									if `rc' != 0 {
										noisily di "    ageROUND = `a', y1 = `y1', bw = `bw', sample = `sample': error code: `rc'"
									}
									drop sample
                }
                
                ** Make a picture
                if `y1' < 1983 local l2 72
                if `y1' >=1983 local l2 70
            
                gen upper = bRound + 1.96*bRoundSE
                gen lower = bRound - 1.96*bRoundSE
                # delimit ;
                twoway
									(connected  bRound ageGraph if !missing(bRound) & ageGraph<=75, sort lcolor(edkblue) lwidth(medthick) mcolor(edkblue))
									(line       upper ageGraph if !missing(bRound) & ageGraph<=75, sort lcolor(maroon) lwidth(medthick) lpattern(dash))
									(line       lower ageGraph if !missing(bRound) & ageGraph<=75, sort lcolor(maroon) lwidth(medthick) lpattern(dash)),
									title("Excess mass at kink, 18-75 year olds")
									subtitle("`sampleTitle', `y1'-`y2', BW = `bw'")
									ylabel(, angle(horizontal) labsize(large))
									ytitle("`title'")
									legend(off)
									xtitle("Age")
									xlabel(, labsize(large))
									xline(62 `l2', lcolor(gs12))
									xsize(10) ysize(7.5)
									graphregion(color(white))
                ;
                # delimit cr
                graph save "$figdir/ageTS_round3_b_`yy'_`aStart'`aStop'_`bw'_`sample'.gph", replace
                capture window manage close graph _all
                
                drop upper lower
                
                ** Outsheet 
                sort order
                outsheet ageGraph bRound bRoundSE bRoundSEDM if ///
									!missing(ageGraph) using ///
									"$tabdir/ageStatsRound3_`yy'_1875_`bw'_`sample'.txt", ///
									replace

            } /* end bw loop */
            
            /* close all open graphs */
            
        } /* end y1 loop */
    } /* end sample loop */

    local time2 "$S_TIME"
    noisily display "Analysis 1 started `time1', ended `time2'"

    
/********************************************************************************************/
/* 2. Bunching by year                                                                      */
/*  a. Vanilla bunching by year, 1955-2006, various age groups: 55-60, 60-61, 62-64, 62-69, */
/*      70-71, 72-75. Make histograms for 1957-1965, 1968-1976, 1979-1987, 1986-1994,       */
/*      1995-2003.                                                                          */
/********************************************************************************************/  

    local time1 "$S_TIME"
    local nBoot = 50
    qui foreach sample of local sampleList{
    
        if "`sample'" == "s1Main"               local sampleTitle "1% Sample, claim by 65, no SE Income"
        if "`sample'" == "s1Full"               local sampleTitle "1% Sample, no SE Income"
        if "`sample'" == "s1Both"               local sampleTitle "1% Sample, claim by 65"
        if "`sample'" == "s1SE"                 local sampleTitle "1% Sample, claim by 65, SE income"
        if "`sample'" == "s1Claim"              local sampleTitle "1% Sample, claimed, no SE income"
        if "`sample'" == "s1Placebo"            local sampleTitle "1% Sample, not yet claimed"
        
        local a1List "62 65 66 70 71 72 60"
        foreach a1 of local a1List{
       
            if `a1' == 60{
							local a2 61
							local aa 6061
            }
            
            if `a1' == 62{
							local a2 64
							local aa 6264
            }
            
            if `a1' == 621{
							local a1 62
							local a2 69
							local aa 6269
            }
            
            if `a1' == 65{
							local a2 65
							local aa 6565
            }
            if `a1' == 66{
							local a2 69
							local aa 6669
            }
            if `a1' == 70{
							local a2 71
							local aa 7071
            }
            if `a1' == 71{
							local a2 71
							local aa 7171
            }
            if `a1' == 72{
							local a2 72
							local aa 7275
            }
            
            if !(`a1'>66 & "`sample'"=="s1Placebo"){
            
                local bwlist2 = "`bwlist'"
                if `a1' == 71 local bwlist2 = 1500
                foreach bw of local bwlist2{
                    noisily di "  bw = `bw'"
                    
                    if `a1' != 71{
											# delimit ;
											use "$datadir/cfopSSA_`sample'_`bw'" if 
												age>=`a1' & age<=`a2' &
												year>=1955 & year<=2006, 
												clear 
											;
											# delimit cr
                    }
                    
                    if `a1' == 71 {
											# delimit ;
											use "$datadir/cfopSSA_`sample'_500" if 
												age>=`a1' & age<=`a2' &
												year>=1955 & year<=2006, 
												clear 
											;
											# delimit cr
											rename realDistanceRound rd500
											gen realDistanceRound = round(rd500,1500)
                    }
                    
                    /* collapse dataset to counts */
                    collapse (sum) count (mean) real_threshold, by(realDistanceRound year)
                    gen rd1k = realDistanceRound / 1e3
                    egen total = total(count), by(year)
                    gen prob = count/total
                    
                    /* fill in for 71 */
                    if `a1' == 71 | `a1' == 66{
                        
											keep if realDistanceRound>=-1e4 & realDistanceRound<=3e4
											gen panelVar = realDistanceRound/`bw'
											tsset year panelVar
											gen original = 1
											tsfill
											gen filledIn = missing(original)
											assert missing(realDistanceRound) & missing(count) & missing(prob) if filledIn
											replace realDistanceRound = `bw'*panelVar if filledIn
											replace prob = 0 if filledIn
											replace rd1k = realDistanceRound/1e3
                    }
                    
                    gen order = _n
                    sort order

                    local row   0
                    gen b       = .
                    gen bSE     = .
                    gen bSEDM = . 
                    gen yearPost = . 
            
                    ** bootstrap placeholders for 66 year olds
                    if `a1' == 66{
											forvalues bs = 1/`nBoot'{
												gen bsEstimate`bs' = .
											}
                    }
            
                    /* define kink as +/- 3k */
                    local exclude = int(3000/`bw')
                    
                    forvalues year = 1955/2006 {
											noi di "  `year'"
											/* max values for ig high/low */
											if `year'<=1971{
													local max = 20000
													local min = -8000
											}
											if `year' >= 1972 & `year' <= 1982{
													local max = 30000
													local min = -8000
											}
											if `year' >= 1983{
													local max = 30000
													local min = -10000
											}
											sum realDistanceRound if year == `year'
											if r(N) > 0 local max = min(`r(max)', `max')
											
											/* set sample */
											gen sample =  year == `year' & inrange(realDistanceRound, `min', `max') 
											sum real_threshold if sample
											local zstar = r(mean)

											# delimit ;
											capture bunchPoly realDistanceRound prob if sample, 
												kink(0) exclude(`exclude') bw(`bw') 
												degree(7) keep(1) print(0) nboot(100)
											;
											# delimit cr            
											local rc = _rc
											
											/* fill in for graphing */
											local ++row
											sort order
											replace yearPost    = `year' in `row'
											if _rc == 0 {
												replace b           = r(scaledMass) in `row'
												replace bSE         = r(scaledMassBS) in `row'
												replace bSEDM       = r(scaledMassSE) in `row'
												
												** calculate bootstrap standarde errors for appropriate years
												if `a1' == 66 & `year'>=1985 & `year'<=2004 {
													count if sample
													local nBins = r(N)
													gen residuals = prob-fit if sample
													forvalues bs = 1/`nBoot'{
										
														** draw from residuals
														sort sample realDistanceRound
														gen use = 1+round((`nBins'-1)*uniform(),1)
														by sample: gen bsProb = prob + residuals[use] if sample
										
														** compute bunching for BS sample, save numbers
														# delimit ;
														capture bunchPoly realDistanceRound bsProb if sample,
																kink(0) exclude(`exclude') bw(`bw') degree(7) keep(0) print(0) nboot(0)
														;
														# delimit cr
														sort order
														replace bsEstimate`bs' = r(scaledMass) in `row'
														drop use bsProb
													}
													** end bootstrap loop
													drop residuals
												}
												** end if for bootstrapping
											}
											if `rc' != 0{
												noisily di "year = `year', a1 = `a1', bw = `bw', sample = `sample': error code: `rc'"
											}
											
											/* make figures for 1957-1965, 1968-1976, 1979-1987, 1986-1994, 1996-2004; note the overlap */
											if (`year'>=1957 & `year'<=1965) | (`year'>=1968 & `year'<=1976) |(`year'>=1979 & `year'<=1987)| (`year'>=1996 & `year'<=2004) {  
												local nox "nolabel"
												local noy "nolabel"
												
												if `year' == 1963 | `year' == 1964 | `year' == 1965 local nox ""
												if `year' == 1974 | `year' == 1975 | `year' == 1976 local nox "" 
												if `year' == 1985 | `year' == 1986 | `year' == 1987 local nox "" 
												if `year' == 2002 | `year' == 2003 | `year' == 2004 local nox "" 
												
												if `year' == 1957 | `year' == 1960 | `year' == 1963 local noy ""
												if `year' == 1968 | `year' == 1971 | `year' == 1974 local noy ""
												if `year' == 1979 | `year' == 1982 | `year' == 1985 local noy ""
												if `year' == 1996 | `year' == 1999 | `year' == 2002 local noy ""
												
												if `year' == 1957 local start 1e8
												
												if `rc' != 0{
													/* make a filler graph */
													gen zero_temp = 0 in 1
													# delimit ;
													twoway scatter zero_temp realDistanceRound if _n==1, 
														name(cfop`year', replace) legend(off) xtitle("") ytitle("") title("") 
														xlabel(,nolabel) ylabel(,nolabel)
														graphregion(color(white))
														nodraw
													;
													# delimit cr
													drop zero_temp
												}
												
												if `rc' == 0{

													# delimit ;
													twoway 
														(connected prob rd1k if !missing(smoothDensity),  lcolor(edkblue) mcolor(navy) msize(small))
														(line smoothDensity rd1k if !missing(smoothDensity),  lcolor(cranberry)),
														title("`year'", ring(0))
														xlabel(#4, `nox' labsize(large))
														xtitle("")
														xline(0, lcolor(gs12))
														ylabel(#4, `noy' labsize(large))
														legend(off)
														graphregion(color(white))
														name(cfop`year', replace)
														nodraw
													; 
													# delimit cr
												
												}
											} /* end if for graphing */
            
											/* if for overlapping years; not most efficient solution, but it gets the job done */
											if (`year'>=1986 & `year'<=1994) {
												local nox "nolabel"
												local noy "nolabel"
												
												if `year' == 1986 | `year' == 1989 | `year' == 1992 local noy ""
												if `year' == 1992 | `year' == 1993 | `year' == 1994 local nox ""
												
												if `rc' != 0{
													/* make a filler graph */
													gen zero_temp = 0 in 1
													# delimit ;
													twoway scatter zero_temp realDistanceRound if _n==1, 
														name(cfop2`year', replace) legend(off) xtitle("") ytitle("") title("") 
														xlabel(,nolabel) ylabel(,nolabel)
														graphregion(color(white))
														nodraw
													;
													# delimit cr
													drop zero_temp
													capture window manage close graph _all
												}
												if `rc'==0{
											
													# delimit ;
													twoway 
														(connected prob rd1k if !missing(smoothDensity),  lcolor(edkblue) mcolor(navy) msize(small)) 
														(line smoothDensity rd1k if !missing(smoothDensity) & rd1k<=0,  lcolor(cranberry)),
														title("`year'", ring(0))
														xlabel(#4, `nox' labsize(large))
														xtitle("")
														xline(0, lcolor(gs12))
														ylabel(#4, `noy' labsize(large))
														legend(off)
														graphregion(color(white))
														name(cfop2`year', replace)
														nodraw
													; 
													# delimit cr
													capture window manage close graph _all
											
												}
											} /* end second if */
                        if `rc' == 0 drop smoothDensity
                        drop sample
                    } /* end year loop */
                
                    /* assemble into 9 panel graphs: 1979-1987 */
                    # delimit ;
                    graph combine
											cfop1979 cfop1980 cfop1981 
											cfop1982 cfop1983 cfop1984
											cfop1985 cfop1986 cfop1987,
											cols(3) title("Distribution of Earnings, `a1'-`a2' year olds")
											subtitle("`sampleTitle', 1979-1987, BW = `bw'")
											xsize(10) ysize(7.5) imargin(tiny)
											l1title("Percent") b1title("Real distance to kink (thousands of dollars)")
											ycommon xcommon
											graphregion(color(white))
                    ;
                    # delimit cr
                    graph save "$figdir/densPoly_7987_`aa'_`bw'_`sample'", replace
                    capture window manage close graph _all
                        
                    /* assemble into 9 panel graphs: 1986-1994 */
                    # delimit ;
                    graph combine
											cfop21986 cfop21987 cfop21988
											cfop21989 cfop21990 cfop21991
											cfop21992 cfop21993 cfop21994,
											cols(3) title("Distribution of Earnings, `a1'-`a2' year olds")
											subtitle("`sampleTitle', 1986-1994, BW = `bw'")
											xsize(10) ysize(7.5) imargin(tiny)
											l1title("Percent") b1title("Real distance to kink (thousands of dollars)")
											ycommon xcommon
											graphregion(color(white))											
											nodraw
                    ;
                    # delimit cr
                    graph save "$figdir/densPoly_8694_`aa'_`bw'_`sample'", replace
                    capture window manage close graph _all
                    
                    /* assemble into 9 panel graphs */
                    # delimit ;
                    graph combine
											cfop1996 cfop1997 cfop1998 
											cfop1999 cfop2000 cfop2001 
											cfop2002 cfop2003 cfop2004,
											cols(3) title("Distribution of Earnings, `a1'-`a2' year olds")
											subtitle("`sampleTitle', 1996-2004, BW = `bw'")
											xsize(10) ysize(7.5) imargin(tiny)
											l1title("Percent") b1title("Real distance to kink (thousands of dollars)")
											ycommon xcommon 
											graphregion(color(white))											
											nodraw
                    ;
                    # delimit cr
                    graph save "$figdir/densPoly_9604_`aa'_`bw'_`sample'", replace
                    capture window manage close graph _all
        
                    /* make time series plots */
                    foreach stat in b{
											if "`stat'" == "b" local title  "Normalized excess mass at kink"
					
											/* make upper and lower confidence bounds */
											gen upper = `stat'+1.96*`stat'SE
											gen lower = `stat'-1.96*`stat'SE
					
											/* plot elasticities plus confidence bands */
											# delimit ;
											twoway
												(connected `stat' yearPost if !missing(`stat'), sort lcolor(edkblue) lwidth(medthick) mcolor(edkblue))
												(line       upper yearPost if !missing(`stat'), sort lcolor(maroon) lwidth(medthick) lpattern(dash))
												(line       lower yearPost if !missing(`stat'), sort lcolor(maroon) lwidth(medthick) lpattern(dash)),
												title("`title', `a1'-`a2' year olds")
												subtitle("`sampleTitle', 1955-2006, BW = `bw'")
												ylabel(, angle(horizontal))
												ytitle("`title'")
												legend(off)
												xtitle("Year")
												xsize(10) ysize(7.5)
												graphregion(color(white))
												xlabel(1955(10)2005)
												xtick(2006, nolabel)											
												nodraw
											;
											# delimit cr
											graph save "$figdir/yearTS_densPoly_`stat'_5509_`aa'_`bw'_`sample'.gph", replace
											drop upper lower
											capture window manage close graph _all
                    }
                    
                    /* outsheet to a table */
                    sort order
                    outsheet yearPost b bSE if !missing(yearPost) using ///
											"$tabdir/yearStatsDensPoly_5509_`aa'_`bw'_`sample'.txt", replace
            
                    ** outsheet bootstrap distribution, if appropriate
                    if `a1' == 66{
											outsheet yearPost bsEstimate* if !missing(bsEstimate1) using ///
												"$tabdir/yearBS_8504_6669_`bw'_`sample'.txt", replace
                    }
                    
                    
                    noisily di "done with bw:`bw', sample=`sample', a1 `a1'"
                } /* end bw loop */
            } /* end a1<=66 if */
            
        } /* end aStart loop */    
    } /* end ds loop */

    local time2 "$S_TIME"
    noisily display "Analysis 2a started `time1', ended `time2'"
  

/********************************************************************************************/
/* 3. Bunching and mortality                                                                */
/********************************************************************************************/
    /* for each sample/bw, look at moments of life expectancy distribution for, say,    */
    /* 62-64 year olds and 66-69 year olds, in 1966-1971, 1990-1999. The moments are    */
    /* E[age at death], Pr(live 70/75/80/85+).                                          */

local time1 "$S_TIME"
	qui foreach sample of local sampleList{
			
			if "`sample'" == "s1Main"               local sampleTitle "1% Sample, claim by 65, no SE Income"
			if "`sample'" == "s1Full"               local sampleTitle "1% Sample, no SE Income"
			if "`sample'" == "s1Both"               local sampleTitle "1% Sample, claim by 65"
			if "`sample'" == "s1SE"                 local sampleTitle "1% Sample, claim by 65, SE income"
			if "`sample'" == "s1Claim"              local sampleTitle "1% Sample, claimed, no SE income"
			if "`sample'" == "s1Placebo"            local sampleTitle "1% Sample, not yet claimed"
					
			foreach bw of local bwlist{
				
				/* load the data */
				# delimit ;
				use "$datadir/cfopSSA_`sample'_`bw'" if 
						( (age>=62 & age<=64) | (age>=66 & age<=69) ) &
						( (year>=1966 & year<=1971) | (year>=1990 & year<=1999) ) &
						realDistanceRound>=-10000 & realDistanceRound<=20000, 
						clear
				;
				# delimit cr
				
				/* collapse to the relevant periods */
				gen early = (year>=1966 & year<=1971)
				gen young = (age>=62 & age<=64)
				drop meanVar 
				
				/* weighted average */
				egen meanVar = mean((count-1)*deathAgeVar), by(realDistanceRound early young)
				egen sdMean = sd(deathAge), by(realDistanceRound early young)
				replace deathAgeVar = meanVar + sdMean^2
				gen wt =count
				
				collapse (rawsum) count ///
					(mean) deathAge* lives70 lives75 lives80 lives85 [fw=wt], ///
					by(early young realDistanceRound) 
				gen rd1k = realDistanceRound/1000
				
				foreach stat in deathAge lives70 lives75 lives80 lives85{
						
						if "`stat'" == "deathAge" gen se = sqrt(deathAgeVar/count)
						if "`stat'" != "deathAge" gen se = sqrt(`stat'*(1-`stat') / count )
						gen upper = `stat'+1.96*se
						gen lower = `stat'-1.96*se
						
						local e1 = 0
						if "`sample'" == "s1Claim" local e1 1
						forvalues e = `e1'/1{
							forvalues y = 0/1{
						
								if `e' == 0 local yearTitle "1990-1999"
								if `e' == 1 local yearTitle "1966-1971"
								if `y' == 0 local ageTitle "66-69" 
								if `y' == 1 local ageTitle "62-64"
						
								gen sample = early == `e' & young == `y'
								local noy "nolabel"
								if `y' local noy ""
								local nox ""
								if `e' local nox "nolabel"
								
								/* plot statistic */
								# delimit ;
								twoway
									(connected `stat' rd1k if sample, sort lcolor(edkblue) mcolor(edkblue))
									(line lower rd1k if sample, sort lcolor(maroon) lpattern(dash))
									(line upper rd1k if sample, sort lcolor(maroon) lpattern(dash)),
									title("`ageTitle', `yearTitle'", ring(0))
									xline(0, lcolor(gs12))
									xtitle("")
									xlabel(#4, `nox' labsize(large)) 
									ytitle("")
									ylabel(#4, `noy' labsize(large))
									legend(off)
									graphregion(color(white))
									name(`stat'`e'`y', replace)
									nodraw
								;
								# delimit cr
								drop sample
									
						} /* close y loop*/
					} /* close time period group loop */
						
					if "`stat'" == "deathAge" local statTitle "Age at death"
					if "`stat'" == "lives70" local statTitle "Pr(Live to 70 or more)"
					if "`stat'" == "lives75" local statTitle "Pr(Live to 75 or more)"
					if "`stat'" == "lives80" local statTitle "Pr(Live to 80 or more)"
					if "`stat'" == "lives85" local statTitle "Pr(Live to 85 or more)"
					
					# delimit ;
					graph combine
						`stat'11 `stat'10 `stat'`e1'1 `stat'`e1'0,
						cols(2) 
						xcommon ycommon
						xsize(10) ysize(7.5)
						title("`statTitle'")
						subtitle("`sampleTitle', BW=`bw'")
						imargin(tiny)
						l1title("`statTitle'") 
						b1title("Real distance to kink (thousands of dollars)")
						graphregion(color(white))
						nodraw
					;
					# delimit cr
					graph save "$figdir/mortality_`stat'_`sample'_`bw'.gph", replace							
					drop upper lower se
					
						
				} /* close stat loop */
				
				/* close all open graphs */
				capture window manage close graph _all
				
		} /* close bw loop */
		
	} /* close sample loop */
	
	local time2 "$S_TIME"
	noisily display "Analysis 3 started `time1', ended `time2'"   
    
/********************************************************************************************/
/* 4. Claiming as a function of earnings                                                    */
/********************************************************************************************/

local time1 "$S_TIME"

    /* periods:
        66-70 : 
        72-81
        83-88
        90-98
        00-05
    */

    qui foreach sample of local sampleList{
    
        if "`sample'" == "s1Main"               local sampleTitle "1% Sample, claim by 65, no SE Income"
        if "`sample'" == "s1Full"               local sampleTitle "1% Sample, no SE Income"
        if "`sample'" == "s1Both"               local sampleTitle "1% Sample, claim by 65"
        if "`sample'" == "s1SE"                 local sampleTitle "1% Sample, claim by 65, SE income"
        if "`sample'" == "s1Claim"              local sampleTitle "1% Sample, claimed, no SE income"
        if "`sample'" == "s1Placebo"            local sampleTitle "1% Sample, not yet claimed"
        
        if "`sample'" == "s1Full"{
        
            local y1List "1990 1966 1972 1983 2000"  
            if "`sample'" == "s1Claim" local y1List "1990"
            foreach y1 of local y1List{
            
                if `y1' == 1966{
                    local y2 1970
                    local yy 6670
                }
                if `y1' == 1972{
                    local y2 1981
                    local yy 7281
                }
                if `y1' == 1983{
                    local y2 1988
                    local yy 8388
                }
                if `y1' == 1990{
                    local y2 1998
                    local yy 9098
                }
                if `y1' == 2000{
                    local y2 2006
                    local yy "0006"
                }
            
                /* load the data */
                # delimit ;
                loadAppend, data("$datadir/ssa_`sample'") append(`append')
                  if("age>=61 & age<=70
                    &( (year>=`y1' & year<=(`y2'+1)))
                    & earnings > 0 & !missing(earnings)"
                  )
                ;
                # delimit cr
                sort id year
                by id: gen claimTomorrow = claimed[_n+1]
                keep if !claimed & age != 70 & real_distance>=-10000 & real_distance<=30000 & year<=`y2'
                gen count = 1
                foreach bw of local bwlist{
                    preserve
                    gen realDistanceRound = round(real_distance, `bw')
                    
                    collapse (rawsum) count (mean) claimTomorrow, by(age realDistanceRound)
                    gen claimSE = sqrt( claimTomorrow*(1-claimTomorrow) / count )
                    gen upper = claimTomorrow + 1.96*claimSE
                    gen lower = claimTomorrow - 1.96*claimSE
                    gen rd1k = realDistanceRound/1000
                    forvalues age = 61/69{
                    
                        local nox "nolabel"
                        if `age'>=67 local nox ""
                        local noy "nolabel"
                        if `age' == 61 | `age' == 64 | `age' == 67 local noy ""
                        
                        # delimit ;
                        twoway 
                            (line claimTomorrow rd1k if age==`age', sort lcolor(edkblue))
                            (line upper rd1k if age==`age', sort lcolor(maroon) lpattern(dash))
                            (line lower rd1k if age==`age', sort lcolor(maroon) lpattern(dash)),
                            title("`age'", ring(0))
                            legend(off)
                            xtitle("")
                            ytitle("")
                            xlabel(#4, `nox' labsize(large))
                            ylabel(#4, `noy' labsize(large))
                            graphregion(color(white))
                            name(claim`age', replace)       
														nodraw
                        ;
                        # delimit cr
                    } /* end age loop */
                    
                    # delimit ;
                    graph combine 
                        claim61 claim62 claim63 
                        claim64 claim65 claim66 
                        claim67 claim68 claim69,
                        cols(3) 
                        l1title("Pr(claim at t+1 | not claimed by t)")
                        b1title("Real distance to kink (thousands of $)")
                        title("Claiming hazard, 61-69 year olds")
                        subtitle("`y1'-`y2', `sample', BW = `bw'") 
                        xcommon ycommon
                        imargin(tiny)
                        xsize(10) ysize(7.5)
                        graphregion(color(white))  
														nodraw
                    ;
                    # delimit cr
                    graph save "$figdir/claiming_`yy'_6169_`sample'_`bw'.gph", replace
                    restore
                
                } /* end BW loop */
            } /* end y1 loop */
            
            /* close all open graphs */
            capture window manage close graph _all
                
        } /* end s1Full if */
    } /* end sample loop */

    local time2 "$S_TIME"
    noisily display "Analysis 4 started `time1', ended `time2'"


/********************************************************************************************/
/* 5. Look at bunching by sex, 1990-1999                                                    */
/********************************************************************************************/

local time1 "$S_TIME"

foreach sample of local sampleList{
    
    if "`sample'" == "s1Main"               local sampleTitle "1% Sample, claim by 65, no SE Income"
    if "`sample'" == "s1Full"               local sampleTitle "1% Sample, no SE Income"
    if "`sample'" == "s1Both"               local sampleTitle "1% Sample, claim by 65"
    if "`sample'" == "s1SE"                 local sampleTitle "1% Sample, claim by 65, SE income"
    if "`sample'" == "s1Claim"              local sampleTitle "1% Sample, claimed, no SE income"
    if "`sample'" == "s1Placebo"            local sampleTitle "1% Sample, not yet claimed"
        
    # delimit ;
    loadAppend, data("$datadir/ssa_`sample'") append(`append')
        if("age>=59 & age<=73
            & ( year>=1990 & year<=1999)
            & earnings > 0 & !missing(earnings)"
        )
    ;
    # delimit cr
    sort id year
		replace sex = "1" if sex == "M"
		replace sex = "2" if sex == "F"
    destring sex, replace force
    
    
    /* a. look at pooled bunching amounts */
    
    /* loop over bandwidths */
    qui foreach bw of local bwlist{
    
        preserve
        keep if age>=65 & age<=69
        /* collapse dataset to counts */
        gen realDistanceRound = round(real_distance, `bw')
        gen count = 1
        collapse (sum) count (mean) real_threshold, by(realDistanceRound sex)
        egen total = sum(count), by(sex)
        gen prob = count/total
        gen rd1k = realDistanceRound/1e3
        local row =  0
        gen b           = .
        gen bSE         = .
        gen bSEDM       = .
        gen sexGraph    = . 
        
        /* define kink as +/- 3k */
        local exclude = int(3000/`bw')
        local max = 30000
        local min = -10000
        
        forvalues sex = 1/2{
        
            
            /* set sample */
            gen sample =  realDistanceRound>=`min' & realDistanceRound<=`max' & sex==`sex'
            # delimit ;
            capture bunchPoly realDistanceRound prob if sample, 
                kink(0) exclude(`exclude') bw(`bw') degree(7) keep(1) print(0) nboot(100)
            ;
            # delimit cr            
            local rc = _rc
                     
            local ++row
            replace sexGraph = `sex' in `row'
            if `rc' != 0{
                noisily di "  sex: `sex', error `rc'"
            } 
            if `rc' == 0{
                local bunch = string(r(scaledMass),"%5.3f")
                local bunchSE = string(r(scaledMassBS), "%5.3f")
                replace b = r(scaledMass) in `row'
                replace bSE = r(scaledMassBS) in `row'
                
                noisily di "bw =`bw', sex = `sex', bunch = `bunch', bunchSE = `bunchSE'"
                local nox ""
                
                if `sex' == 1 local nox "nolabel"
                if `sex' == 1 local sexTitle "Men"
                if `sex' == 2 local sexTitle "Women"
            
                # delimit ;
                twoway
									(connected prob rd1k if !missing(smoothDensity),  lcolor(navy) mcolor(navy) msize(small))
									(line smoothDensity rd1k if !missing(smoothDensity),  lcolor(cranberry)),
									title("`sexTitle'", ring(0))
									note("" "" "Excess mass:"  "`bunch' (SE: `bunchSE')", ring(0) pos(2) size(medium))
									xlabel(#4, `nox' labsize(large))
									xtitle("")
									xline(0, lcolor(gs12))
									ylabel(#4, labsize(large))
									legend(off)
									graphregion(color(white))
									name(cfop`sex', replace)
									nodraw
                ;
                # delimit cr
                drop smoothDensity
            }
            drop sample 
        } /* end sex loop */            
        noisily list sexGraph b bSE if !missing(sexGraph), noobs clean
        restore
        
        # delimit ;
        graph combine cfop1 cfop2,
					xcommon ycommon
					b1title("Real distance to kink (thousands/$)")
					l1title("Percent")
					cols(1) title("Distribution of Earnings, 65-69 year olds, by sex")
					subtitle("`sampleTitle', 1990-1999, BW = `bw'")
					xsize(7.5) ysize(10) imargin(tiny)
					graphregion(color(white))
        ;
        # delimit cr
        graph save "$figdir/densPolyBunchSex_9099_6269_`sample'_`bw'.gph", replace 
        capture window manage close graph _all
        
    } /* end bw loop */

    /* b. look at bunching by age and sex */

    /* loop over bandwidths */
    qui foreach bw of local bwlist{
    
        preserve
        /* collapse dataset to counts */
        gen realDistanceRound = round(real_distance, `bw')
        gen count = 1
        collapse (sum) count (mean) real_threshold, by(realDistanceRound age sex)
        egen total = sum(count), by(sex age)
        gen prob = count/total
        gen rd1k = realDistanceRound/1e3
        
        local row   0
        gen b           = .
        gen bSE         = .
        gen sexGraph    = . 
        gen ageGraph    = . 
        
        
        /* define kink as +/- 3k */
        local exclude = int(3000/`bw')
        local max = 30000
        local min = -10000
        
        
        forvalues sex = 1/2{
            forvalue age = 59/73{
                
                /* set sample */
                gen sample =  realDistanceRound>=`min' & realDistanceRound<=`max' & sex==`sex' & age == `age'
                
                # delimit ;
                capture bunchPoly realDistanceRound prob if sample, 
                    kink(0) exclude(`exclude') bw(`bw') degree(7) keep(0) print(0) nboot(100)
                ;
                # delimit cr  
                local ++row
                replace sexGraph = `sex' in `row'
                replace ageGraph = `age' in `row'
                
                if `rc' != 0{
                    noisily di "  sex: `sex',error `rc'"
                } 
                
                if `rc' == 0{
                    local bunch = string(r(scaledMass),"%5.3f")
                    local bunchSE = string(r(scaledMassBS), "%5.3f")
                    
                    replace b = r(scaledMass) in `row'
                    replace bSE = r(scaledMassBS) in `row'
                }
                
                drop sample
            } /* end age loop */
        } /* end sex loop */            
        
        # delimit ;
        twoway
            (connected b ageGraph if sexGraph == 1, sort lcolor(navy) mcolor(navy) msize(small))
            (connected b ageGraph if sexGraph == 2, sort lcolor(cranberry) mcolor(cranberry) lpattern(dash) msize(small)),
            title("Bunching by age and sex")
            subtitle("1990-1999 `sampleTitle', BW = `bw'")
            xlabel(#4,labsize(large))
            xtitle("Age")
            xline(62 69, lcolor(black) lpattern(dash))
            ylabel(#4, labsize(large))
            ytitle("Excess mass")
            graphregion(color(white))
            legend(
                order( 1 "Men" 2 "Women")
                pos(6) ring(0)
            )
            xsize(10) ysize(7.5)  
														nodraw
        ;
        # delimit cr
        graph save "$figdir/bunchPolyAgeSex_90999_5973_`sample'_`bw'.gph", replace 
    
        restore
        
        /* close all open graphs */
        capture window manage close graph _all
        
    } /* end bw loop */
} /* end sample loop */
   


local time2 "$S_TIME"
noisily di "Analysis 5 start `time1' finish `time2'"

/********************************************************************************************/
/* 6. Dynamic responses:                                                                    */
/*  Extensive margin response: Pr(exit at t+1| earnings at t)                               */
/*  Future earnings, earnings changes from t to t+1 conditional on earnings at t            */
/********************************************************************************************/  
    local time1 "$S_TIME"

    ** pseudo code:    
    ** 1. load the data, find lfp(+1), z(+1), sd of z(+1)
    ** 2. bin the data into age-distance-to-kink cells
    ** 3. plot lfp(+1) | distance, age
    ** 4. plot z(+1) | distance, age

    qui foreach sample of local sampleList{
    
        if "`sample'" == "s1Main"               local sampleTitle "1% Sample, claim by 65, no SE Income"
        if "`sample'" == "s1Full"               local sampleTitle "1% Sample, no SE Income"
        if "`sample'" == "s1Both"               local sampleTitle "1% Sample, claim by 65"
        if "`sample'" == "s1SE"                 local sampleTitle "1% Sample, claim by 65, SE income"
        if "`sample'" == "s1Claim"              local sampleTitle "1% Sample, claimed, no SE income"
        if "`sample'" == "s1Placebo"            local sampleTitle "1% Sample, not yet claimed"
                
            
        /* load the data */
        # delimit ;
        loadAppend, data("$datadir/ssa_`sample'") append(`append')
          if("age>=59 & age<=74
            &( (year>=1990 & year<=1999))
            & earnings > 0 & !missing(earnings)"
          )
        ;
        # delimit cr
        sort id year
        by id: gen lfpLead = (real_earnings[_n+1]>0 & !missing(real_earnings[_n+1]))
        by id: gen earnLead = real_earnings[_n+1]
        by id: gen distLead = real_distance[_n+1]/1e3
        
        keep if age<74 & real_distance>=-1e4 & real_distance<=3e4 & year<1999
        
        replace earnLead = 0 if missing(earnLead)
        gen dEarn = (earnLead-real_earnings)/real_earnings
        gen distLeadSD = distLead
        gen dEarnSD = dEarn
        
        gen count = 1
        foreach bw of local bwlist{
            preserve
            gen realDistanceRound = round(real_distance, `bw')
            
            collapse (rawsum) count (mean) lfpLead distLead dEarn (sd) distLeadSD dEarnSD, by(age realDistanceRound)
            
            gen lfpLeadSD = sqrt(lfpLead*(1-lfpLead))
            
            gen rd1k = realDistanceRound/1000
            foreach out in lfpLead distLead dEarn{
                
                gen se = `out'SD/sqrt(count)
                
                gen upper = `out' + 1.96*se
                gen lower = `out' - 1.96*se
                
                foreach length in long short{
                    
                    if "`length'" == "long" local dMax = 30
                    if "`length'" == "short" local dMax = 10
                    
                    forvalues age = 59/73{
                    
                        local nox "nolabel"
                        local noy "nolabel"
    
                        if `age' == 59 | `age' == 64 | `age' == 69 local noy ""
                        if `age'>=69 local nox ""
    
                        # delimit ;
                            twoway
                                (connected `out' rd1k if age == `age' & rd1k<=`dMax',  lcolor(navy) mcolor(navy) msize(small))
                                (line upper rd1k if  age == `age' & rd1k<=`dMax',  lcolor(cranberry) lpattern(dash))
                                (line lower rd1k if  age == `age' & rd1k<=`dMax',  lcolor(cranberry) lpattern(dash)),
                                title("`age'", ring(0))
                                xlabel(#4, `nox' labsize(large))
                                xtitle("")
                                xline(0, lcolor(gs12))
                                ylabel(#4, `noy' labsize(large))
                                legend(off)
                                graphregion(color(white))
                                name(g`age', replace)
																nodraw
                            ;
                            # delimit cr
                            capture window manage close graph _all
                    } /* end age loop */
                    
                    if "`out'" == "lfpLead"{
                        local ltitle "Pr(Has earnings in t+1)"
                        local title  "Labor Force Participation, by earnings and age"
                    }
                    if "`out'" == "dEarn"{
                        local ltitle "Percent change in earnings"
                        local title  "Earnings growth, by earnings and age"
                    }
                    if "`out'" == "distLead"{
                        local ltitle "Real distance at t+1 (thousands of $)"
                        local title  "Future earnings, by earnings and age"
                    }

                    # delimit ;
                    graph combine 
                        g59 g60 g61 g62 g63 
                        g64 g65 g66 g67 g68 
                        g69 g70 g71 g72 g73,
                        cols(5) 
                        l1title("`ltitle'")
                        b1title("Real distance to kink (thousands of $)")
                        title("`title'")
                        subtitle("1990-1998, `sampleTitle', BW = `bw'") 
                        xcommon ycommon
                        imargin(tiny)
                        xsize(10) ysize(7.5)
                        graphregion(color(white))  
												nodraw
                    ;
                    # delimit cr
                    graph save "$figdir/`out'_`length'_9098_5973_`sample'_`bw'.gph", replace 
                    
                    /* make a big figure for age 69 */ 
                    # delimit ;
                    twoway
                        (connected `out' rd1k if age == 69 & rd1k<=`dMax',  lcolor(navy) mcolor(navy) msize(small))
                        (line upper rd1k if age == 69 & rd1k<=`dMax',  lcolor(cranberry) lpattern(dash))
                        (line lower rd1k if age == 69 & rd1k<=`dMax',  lcolor(cranberry) lpattern(dash)),
                        ytitle("`ltitle'", size(large))
                        xtitle("Real distance to kink (thousands of $)", size(large))
                        title("`title'")
                        subtitle("69 year olds, 1990-1998, `sampleTitle', BW = `bw'")
                        xlabel(#4, labsize(large))
                        xline(0, lcolor(gs12))
                        graphregion(color(white))
                        ylabel(#4, labsize(large))
                        xsize(10) ysize(7.5)
                        legend(off)  
												nodraw
                    ;
                    # delimit cr
                    graph save "$figdir/`out'_`length'_9098_69_`sample'_`bw'.gph", replace
                    
                } /* end length loop */
                drop upper lower se
            } /* end outcome loop */
            restore
        } /* end BW loop */
    } /* end sample loop */


    /* close all open graphs */
    capture window manage close graph _all
            
    local time2 "$S_TIME"
    noisily display "Analysis 6 started `time1', ended `time2'"

/********************************************************************************************/
/* 6.5 Dynamic responses:                                                                   */
/*  a. % Change in earnings from 68 to 69, conditional on earninigs w/in 10k of kink at 69  */
/*  b. % Change in earnings from t to t+1, conditional on near kink at age 69.              */
/********************************************************************************************/  
    local time1 "$S_TIME"

    ** pseudo code:    
    ** 1. load the data, find lfp(+1), z(+1), sd of z(+1)
    ** 2. bin the data into age-distance-to-kink cells
    ** 3. plot lfp(+1) | distance, age
    ** 4. plot z(+1) | distance, age

    qui foreach sample of local sampleList{
    
        if "`sample'" == "s1Main"               local sampleTitle "1% Sample, claim by 65, no SE Income"
        if "`sample'" == "s1Full"               local sampleTitle "1% Sample, no SE Income"
        if "`sample'" == "s1Both"               local sampleTitle "1% Sample, claim by 65"
        if "`sample'" == "s1SE"                 local sampleTitle "1% Sample, claim by 65, SE income"
        if "`sample'" == "s1Claim"              local sampleTitle "1% Sample, claimed, no SE income"
        if "`sample'" == "s1Placebo"            local sampleTitle "1% Sample, not yet claimed"
                
        foreach bw of local bwlist{
            ** load the data
            # delimit ;
            loadAppend, data("$datadir/ssa_`sample'") append(`append')
              if("age>=68 & age<=70
                &( (year>=1990 & year<=1999))
                & earnings > 0 & !missing(earnings)"
              )
            ;
            # delimit cr
            sort id year
            by id: gen lfpLead = (real_earnings[_n+1]>0 & !missing(real_earnings[_n+1]))
            by id: gen earnLead = real_earnings[_n+1]
            by id: gen distLead = real_distance[_n+1]/1e3
                 
            replace earnLead = 0 if missing(earnLead)
            gen dEarn = (earnLead-real_earnings)/real_earnings
            gen distLeadSD = distLead
            gen dEarnSD = dEarn
            
            ** a. % Change in earnings from 68 to 69, conditional on earnings w/in 10k of kink at 69 
            gen realDistanceRound = round(real_distance, `bw')
            by id: egen sampleLater = max( (abs(realDistanceRound)<=1e4)*(age==69) )
            gen rd1k = realDistanceRound/1000
            egen tagAgeRD = tag(age realDistanceRound sampleLater) 
            
            sort age realDistanceRound sampleLater
            by age realDistanceRound sampleLater: egen meanDEarn = mean(dEarn)
            by age realDistanceRound sampleLater: egen sdDEarn = sd(dEarn)
            by age realDistanceRound sampleLater: gen obs = _N
            gen upper = meanDEarn + 1.96*sdDEarn/sqrt(obs)
            gen lower = meanDEarn - 1.96*sdDEarn/sqrt(obs)
            
            local ltitle "Percent change in earnings"
            local title  "Earnings growth, by earnings and age"
            # delimit ;
            twoway
                (connected meanDEarn rd1k if age == 68 & abs(realDistanceRound)<=1e4 & tagAgeRD & sampleLater, sort lcolor(navy) mcolor(navy) msize(small))
                (line upper rd1k if age == 68 & abs(realDistanceRound)<=1e4 & tagAgeRD & sampleLater, sort lcolor(cranberry) lpattern(dash))
                (line lower rd1k if age == 68 & abs(realDistanceRound)<=1e4 & tagAgeRD & sampleLater, sort lcolor(cranberry) lpattern(dash)),
                ytitle("`ltitle'", size(large))
                xtitle("Real distance to kink (thousands of $)", size(large))
                title("`title'")
                subtitle("68 year olds, 1990-1998, `sampleTitle', BW = `bw'")
                xlabel(#4, labsize(large))
                xline(0, lcolor(gs12))
                graphregion(color(white))
                ylabel(#4, labsize(large))
                xsize(10) ysize(7.5)
                legend(off)  
								nodraw
            ;
            # delimit cr
            graph save "$figdir/dEarn_short_9098_68_`sample'_`bw'.gph", replace
            
            drop upper lower
            
            ** b. % Change in earnings from t to t+1, conditional on near kink at age 69. 
            bysort id: egen sampleAK = max( (abs(realDistanceRound)<=2000)*(age==69) )
            drop meanDEarn sdDEarn obs tagAgeRD
            sort age sampleAK 
            by age sampleAK: egen meanDEarn = mean(dEarn)
            by age sampleAK: egen sdDEarn = sd(dEarn)
            by age sampleAK: gen obs = _N
            
            egen tagAge = tag(age sampleAK)
            gen upper = meanDEarn + 1.96*sdDEarn/sqrt(obs)
            gen lower = meanDEarn - 1.96*sdDEarn/sqrt(obs)
            
            local ltitle "Percent change in earnings"
            local title  "Earnings growth, by earnings and age"
            # delimit ;
            twoway
                (connected meanDEarn age  if tagAge & sampleLater,  lcolor(navy) mcolor(navy) msize(small))
                (line upper age if tagAge & sampleLater,  lcolor(cranberry) lpattern(dash))
                (line lower lower if tagAge & sampleLater,  lcolor(cranberry) lpattern(dash)),
                ytitle("`ltitle'", size(large))
                xtitle("Age", size(large))
                title("`title'")
                subtitle("At kink age age 69, 1990-1998, `sampleTitle', BW = `bw'")
                xlabel(#4, labsize(large))
                xline(0, lcolor(gs12))
                graphregion(color(white))
                ylabel(#4, labsize(large))
                xsize(10) ysize(7.5)
                legend(off)  
								nodraw
            ;
            # delimit cr
            graph save "$figdir/ak69Growth_9098_`sample'_`bw'.gph", replace
            
            drop upper lower
            
        }
        ** close bw loop 
    } 
    ** close sample loop

    /* close all open graphs */
    capture window manage close graph _all
            
    local time2 "$S_TIME"
    noisily display "Analysis 6.5 started `time1', ended `time2'"
    

/********************************************************************************************/
/* 7. Persistence of bunching, 1990-1999, various ages and measures                         */
/********************************************************************************************/  
    
    ** Pseudo code
    * 1. Load the data, 58-72 year olds, 1990-1998
    * 2. Find change in kink for each year / group 
    *   - (i.e. distinguish between preNRA/postNRA)
    *   - Find future earnings, whether people follow kink
    * 3. collapse to bandwidth, plot; report numbers and SEs, 
    *   but plot point estimates only.
    *   
    
    local time1 "$S_TIME"    
    
    qui foreach sample of local sampleList{
    
        if "`sample'" == "s1Main"               local sampleTitle "1% Sample, claim by 65, no SE Income"
        if "`sample'" == "s1Full"               local sampleTitle "1% Sample, no SE Income"
        if "`sample'" == "s1Both"               local sampleTitle "1% Sample, claim by 65"
        if "`sample'" == "s1SE"                 local sampleTitle "1% Sample, claim by 65, SE income"
        if "`sample'" == "s1Claim"              local sampleTitle "1% Sample, claimed, no SE income"
        if "`sample'" == "s1Placebo"            local sampleTitle "1% Sample, not yet claimed"
                
            
        /* load the data */
        # delimit ;
        loadAppend, data("$datadir/ssa_`sample'") append(`append')
          if("age>=58 & age<=73
            &( (year>=1990 & year<=1999))
            & earnings > 0 & !missing(earnings)"
          )
        ;
        # delimit cr
        sort id year
        by id: gen earnLead = real_earnings[_n+1]
        by id: gen distLead = real_distance[_n+1]
        
        gen     group = 1 if age<=60
        replace group = 2 if age>=62 & age<=63
        replace group = 3 if age>=65 & age<=68
        replace group = 4 if age>=70 & age<=72
        
        keep if age<74 & real_distance>=-1e4 & real_distance<=3e4 & year<1999
        
        replace earnLead = 0 if missing(earnLead)
        gen dEarn = (earnLead-real_earnings)/real_earnings
        gen distLeadSD = distLead
        gen dEarnSD = dEarn
        
        /* change in kink for young ones	*/	
        gen dKink = 0 
        replace dKink = -0.006710977 if age<=64 & year == 1990
        replace dKink = 0.020138444 if age<=64 & year == 1991
        replace dKink = 0.002254716 if age<=64 & year == 1992
        replace dKink = 0.020738445 if age<=64 & year == 1993
        replace dKink = -0.013045011 if age<=64 & year == 1994
        replace dKink = -0.014396581 if age<=64 & year == 1995
        replace dKink = 0.020073141 if age<=64 & year == 1995
        replace dKink = 0.039366053 if age<=64 & year == 1997
        replace dKink = 0.029885638 if age<=64 & year == 1998

        		
        /* change in kink for old ones ones	*/
        replace dKink = -0.003473399 if age>64 & year == 1990
        replace dKink = 0.018716507 if age>64 & year == 1991
        replace dKink = 0.005202524 if age>64 & year == 1992
        replace dKink = 0.030433382 if age>64 & year == 1993
        replace dKink = -0.017102701 if age>64 & year == 1994
        replace dKink = 0.076373351 if age>64 & year == 1995
        replace dKink = 0.055775701 if age>64 & year == 1996
        replace dKink = 0.057600545 if age>64 & year == 1997
        replace dKink = 0.045866623 if age>64 & year == 1998
        
        keep if !missing(real_earnings) & real_earnings>0        
        gen growWithKink = abs(earnLead-(1+dKink)*real_earnings)<=3000 & earnLead != 0
            
        gen count = 1
        foreach bw of local bwlist{
            
            preserve
            gen realDistanceRound = round(real_distance, `bw')
            gen atKink      = abs(realDistanceRound)<=3000 
            gen distLeadRound = round(distLead, `bw')/1e3
            /* collapse to make future earnings distribution | at kink, group */
            collapse (rawsum) count, by(group atKink distLeadRound)
            
            egen sum = total(count), by(group)
            gen percent = count/sum
            
            /* make some pictures */
            # delimit ;
            twoway
                (line percent distLeadRound if group == 2 & atKink & distLeadRound<=30 & distLeadRound>=-10, lcolor(navy) lpattern(solid))
                (line percent distLeadRound if group == 3 & atKink & distLeadRound<=30 & distLeadRound>=-10, lcolor(cranberry) lpattern(dash))
                (line percent distLeadRound if group == 1 & atKink & distLeadRound<=30 & distLeadRound>=-10, lcolor(gs10) lpattern(solid))
                (line percent distLeadRound if group == 4 & atKink & distLeadRound<=30 & distLeadRound>=-10, lcolor(gs10) lpattern(dash)),
                legend(
                    order(
                        1 "Age 62-63"
                        2 "65-68"
                        3 "58-60"
                        4 "70-72"
                    )
                    cols(4)
                    pos(6)
                    span
                )
                xtitle("Percent")
                ytitle("Future earnings (thousands of $)")
                title("Future earnings distribution, initally near kink")
                subtitle("`sampleTitle', 1990-1998, BW=`bw'")
                xlabel(, labsize(large))
                ylabel(, labsize(large))
                xline(0, lcolor(gs12))
                graphregion(color(white))
                xsize(10) ysize(7.5)
								nodraw
            ;
            # delimit cr
            graph save "$figdir/futureDist_`sample'_`bw'.gph", replace
            
            /* collapse to make probability of following kink | earnings */
            restore
            preserve
            gen realDistanceRound = round(real_distance, `bw')
            collapse (rawsum) count (mean) growWithKink, by(realDistanceRound group)
             
            gen se = sqrt(growWithKink*(1-growWithKink)/count)
            noisily sum growWithKink se, det
            gen rd1k = realDistanceRound/1e3
            # delimit ;
            twoway
                (line growWithKink rd1k if rd1k>=-10 & rd1k<=30 & group == 1,  sort lcolor(gs10) mcolor(gs10) lpattern(solid))
                (line growWithKink rd1k if rd1k>=-10 & rd1k<=30 & group == 2, sort  lcolor(navy) mcolor(navy) msize(small) lpattern(solid))
                (line growWithKink rd1k if rd1k>=-10 & rd1k<=30 & group == 3,  sort lcolor(cranberry) mcolor(cranberry) lpattern(dash)),
                title("Pr(Earnings move with kink | Earnings)")
                subtitle("`sampleTitle', 1990-1998,BW=`bw'")
                xlabel(#4, labsize(large))
                xtitle("Real distance to kink (thousands of $)")
                xline(0, lcolor(gs12))
                ylabel(#4, labsize(large))
                graphregion(color(white))
                ytitle("Percent")
                legend(
                    order(
                        1 "Age 58-60"
                        2 "62-63"
                        3 "65-68"
                    )
                    cols(4)
                    pos(6)
                )
                xsize(10) ysize(7.5)      
								nodraw
            ;
            # delimit cr
            graph save "$figdir/follow_`sample'_`bw'.gph", replace
            
            restore
        } /* end BW loop */
        
        /* close all open graphs */
        capture window manage close graph _all
            
    } /* end sample loop */


    local time2 "$S_TIME"
    noisily display "Analysis 7 started `time1', ended `time2'"

/********************************************************************************************/
/* 8. Where do people go?                                                                   */
/*  a.  Where do people go when kink disappears? Look at density of lead earnings | at kink,*/
/*      for people about to leave the ET test vs. people just younger in the same year, or  */
/*      for people just older.                                                              */
/********************************************************************************************/
    local time1 "$S_TIME"
    
    foreach sample of local sampleList{

        if "`sample'" == "s1Main"               local sampleTitle "1% Sample, claim by 65, no SE Income"
        if "`sample'" == "s1Full"               local sampleTitle "1% Sample, no SE Income"
        if "`sample'" == "s1Both"               local sampleTitle "1% Sample, claim by 65"
        if "`sample'" == "s1SE"                 local sampleTitle "1% Sample, claim by 65, SE income"
        if "`sample'" == "s1Claim"              local sampleTitle "1% Sample, claimed, no SE income"
        if "`sample'" == "s1Placebo"            local sampleTitle "1% Sample, not yet claimed"
        
        /* load the data */
        # delimit ;
        loadAppend, data("$datadir/ssa_`sample'") append(`append')
          if("age>=68 & age<=70 & (year>=1990 & year<=1998) & abs(distLead1)<=10000")
        ;
        # delimit cr
        
                 
        qui foreach ak of numlist 500 1000 2000 3000{
                    
            gen atKink = abs(real_distance<=`ak')
            
            /* get density of age t+1 distance for people exiting,olds at kink */
            forvalues age = 68/70{
                # delimit ;
                kdensity distLead1 if age==`age' & atKink,
                    kernel(tri)
                    bwidth(500)
                    gen(dist`age' dens`age')
                    n(200)
                    nograph
                ;
                # delimit cr    
            }
            /* plot the results for all groups */
            # delimit ;
            twoway
                (line dens69 dist69 if dist69>=-10000 & dist69<=10000, lcolor(navy))
                (line dens68 dist68 if dist68>=-10000 & dist68<=10000, lcolor(cranberry) lpattern(dash))
                (line dens70 dist70 if dist70>=-10000 & dist70<=10000, lcolor(gs4) lpattern(dash)),
                legend(
                    order(
                        2 "Z{sub:t+1}, 68"
                        1 "Z{sub:t+1}, 69"
                        3 "Z{sub:t+1}, 70"
                    )
                    stack symplacement(left) symxsize(13) forcesize rowgap(2)
                    ring(0)
                    pos(2)
                    cols(1)
                )
                title("Lead earnings distribution | at kink, 68-70 year olds")
                subtitle("1990-1998, `sampleTitle'")
                xtitle("Lead distance to kink (thousands of dollars)")
                xlabel(-10000 "-10" -5000 "-5" 0 "0" 5000 "5" 10000 "10")
                ytitle("Density")
                xline(0, lcolor(gs12))
                xsize(10) ysize(7.5)
                graphregion(color(white))
								nodraw
            ;
            # delimit cr
            graph save "$figdir/leadCF_9098_6870_ak`ak'_`sample'.gph", replace 
            
            /* plot the results for just 69 year olds */
            # delimit ;
            twoway
                (line dens69 dist69 if dist69>=-10000  & dist69<=10000, lcolor(navy)),
                legend(off)
                title("Lead earnings distribution | at kink, 69 year olds")
                subtitle("1990-1998, `sampleTitle'")
                xtitle("Lead distance to kink (thousands of dollars)")
                xlabel(-10000 "-10" -5000 "-5" 0 "0" 5000 "5" 10000 "10")
                ytitle("Density")
                xline(0, lcolor(gs12))
                xsize(10) ysize(7.5)
                graphregion(color(white))
								nodraw
            ;
            # delimit cr
            graph save "$figdir/leadCF_9098_69_ak`ak'_`sample'.gph", replace 

            /* drop temp vars */
            drop atKink dist68 dens68 dist69 dens69 dist70 dens70
            
        } /* end ak loop */
    } /* end sample loop */
    
    /* close all open graphs */
    capture window manage close graph _all
    
    local time2 "$S_TIME"
    noisily display "Analysis 8a started `time1', ended `time2'"

/********************************************************************************************/
/* 8. Where do people go?                                                                   */
/*  b. Where do people go when kink appears? Look at density of lag earnings | at kink,     */
/*      for people who just entered thethe ET test vs. people just younger in the same year.*/
/********************************************************************************************/
    local time1 "$S_TIME"
    
    foreach sample of local sampleList{

        if "`sample'" == "s1Main"               local sampleTitle "1% Sample, claim by 65, no SE Income"
        if "`sample'" == "s1Full"               local sampleTitle "1% Sample, no SE Income"
        if "`sample'" == "s1Both"               local sampleTitle "1% Sample, claim by 65"
        if "`sample'" == "s1SE"                 local sampleTitle "1% Sample, claim by 65, SE income"
        if "`sample'" == "s1Claim"              local sampleTitle "1% Sample, claimed, no SE income"
        if "`sample'" == "s1Placebo"            local sampleTitle "1% Sample, not yet claimed"
        
        /* load the data */
        # delimit ;
        loadAppend, data("$datadir/ssa_`sample'") append(`append')
          if("age>=61 & age<=63 & (year>=1991 & year<=1999) & abs(distLag1)<=10000")
        ;
        # delimit cr
        
                 
        qui foreach ak of numlist 500 1000 2000 3000{
                    
            gen atKink = abs(real_distance<=`ak')
            
            /* get density of age t+1 distance for people exiting,olds at kink */
            forvalues age = 61/63{
                # delimit ;
                kdensity distLag1 if age==`age' & atKink,
                    kernel(tri)
                    bwidth(500)
                    gen(dist`age' dens`age')
                    n(200)
                    nograph
                ;
                # delimit cr    
            }
            /* plot the results for all groups */
            # delimit ;
            twoway
                (line dens62 dist62 if dist61>=-10000 & dist61<=10000, lcolor(navy))
                (line dens61 dist61 if dist62>=-10000 & dist62<=10000, lcolor(cranberry) lpattern(dash))
                (line dens63 dist63 if dist63>=-10000 & dist63<=10000, lcolor(gs4) lpattern(dash)),
                legend(
                    order(
                        2 "Z{sub:t-1}, 61"
                        1 "Z{sub:t-1}, 62"
                        3 "Z{sub:t-1}, 63"
                    )
                    stack symplacement(left) symxsize(13) forcesize rowgap(2)
                    ring(0)
                    pos(2)
                    cols(1)
                )
                title("Lag earnings distribution | at kink, 61-63 year olds")
                subtitle("1991-1999, `sampleTitle'")
                xtitle("Lead distance to kink (thousands of dollars)")
                xlabel(-10000 "-10" -5000 "-5" 0 "0" 5000 "5" 10000 "10")
                ytitle("Density")
                xline(0, lcolor(gs12))
                graphregion(color(white))
                xsize(10) ysize(7.5)
								nodraw
            ;
            # delimit cr
            graph save "$figdir/lagCF_9199_6163_ak`ak'_`sample'.gph", replace 
            
            /* plot the results for just 62 year olds */
            # delimit ;
            twoway
                (line dens62 dist62 if dist62>=-10000  & dist62<=10000, lcolor(navy)),
                legend(off)
                title("Lead earnings distribution | at kink, 62 year olds")
                subtitle("1991-1999, `sampleTitle'")
                xtitle("Lead distance to kink (thousands of dollars)")
                xlabel(-10000 "-10" -5000 "-5" 0 "0" 5000 "5" 10000 "10")
                ytitle("Density")
                xline(0, lcolor(gs12))
                xsize(10) ysize(7.5)
                graphregion(color(white))
								nodraw
            ;
            # delimit cr
            graph save "$figdir/lagCF_9199_62_ak`ak'_`sample'.gph", replace 

            /* drop temp vars */
            drop atKink dens6* dist6*
            
        } /* end ak loop */
    } /* end sample loop */
    
    /* close all open graphs */
    capture window manage close graph _all
    
    local time2 "$S_TIME"
    noisily display "Analysis 8b started `time1', ended `time2'"


