// Load the estimated bunching amounts
local bw 800
local t0 = 0.267
local t1Pre = `t0' + 0.5
local t1Post = `t0' + 0.33

	// bunching 66-68	
	insheet using ///
		"$datadir/yearStatsDensPoly_7802_6668_`bw'_s1Main.txt", ///
		tab names case clear
	keep if inrange(yearPost, 1982, 1993)
	gen age = 6668 	
	replace b = b*`bw'
	replace bSE =bSE*`bw'
	
	save temp6668, replace
	
	// bunching 62-64
	insheet using "$datadir/yearStatsDensPoly_5509_6264_`bw'_s1Main.txt", ///
		tab names case clear
	keep if inrange(year, 1982, 1993)
	
	gen age = 6264 

	replace b = b*`bw'
	replace bSE = bSE*`bw'
	
	
	append using temp6668
	erase temp6668.dta

// Diff in diffs: bunching by age/year, with "1990" dummy
	gen old = age == 6668
	gen old90 = age == 6668 & year == 1990
	gen oldPost90 = age == 6668 & year > 1990 
	gen oldPost89 = age == 6668 & year > 1989
	gen trend = year - 1991
	gen trendOld = trend * old
		
	
********************************************************************************
********************************************************************************
** Regressions with old*year*post  
********************************************************************************
********************************************************************************
	gen yearOld = year * old
	gen c0 = " &" in 1
	local row 17
	
	qui forvalues c = 1/4 {
		local row = 1
		gen c`c' = "`c' &" in `row'
		
		if `c' == 1 {
			local x "i(1989/1993).yearOld"
			local s "age==6668"
		}
		if `c' == 2 {
			local x "i(1989/1993).yearOld trendOld"
			local s "age==6668"
		}
		
		if `c' == 3 {
			local x "i(1989/1993).yearOld old i.yearPost"
			local s "1"
		}
		if `c' == 4 {
			local x "i(1989/1993).yearOld old trendOld i.yearPost"
			local s "1"
		}
		qui foreach y in b {
		
			if "`y'" == "b" local str "5.1"
			if "`y'" == "e" local str "4.3"		
			noi di "`y' `s'"
		
			local ++row
			replace c0 = "`y' \\" in `row'
		
			// run the regression
			noi di "`c' : `y' `x' if `s'"
			regress `y' `x' if `s', robust
			
			// record the coefficients 
			
			forvalues y = 1990/1993 {
				local v "`y'.yearOld"
				local name "Year = `y'$\times$ Old"
				local ++row
				replace c0 = "`name' &" in `row'
				replace c`c' = string(_b[`v'], "%`str'f") + "&" in `row'
				local ++row
				replace c0 = "&" in `row'
				replace c`c' = "(" + string(_se[`v'], "%`str'f") + ") &" in `row'
			}
		}
	}
	replace c4 = subinstr(c4, "&", "\\", .)
	list c0-c4 in 1/`row', noobs clean
	outsheet c0-c4 in 1/`row' using "$tabdir/tableB5.tex", replace ///	
		noquote nonames delimit(" ")

********************************************************************************
********************************************************************************
** Bunching DD figure
********************************************************************************
********************************************************************************


gen lower = b - 1.96*bSE
gen upper = b + 1.96*bSE
# delimit ;
twoway
	(connected b yearPost if age == 6668, mcolor("$blue") lcolor("$blue"))
	(line upper yearPost if age == 6668, lpattern(dash) lcolor("$blue"))
	(line lower yearPost if age == 6668, lpattern(dash) lcolor("$blue"))
	(connected b yearPost if age == 6264, lpattern(dot) lcolor("$red") mcolor("$red"))
	(line upper yearPost if age == 6264, lpattern(dash_dot) lcolor("$red"))
	(line lower yearPost if age == 6264, lpattern(dash_dot) lcolor("$red")),
	legend(pos(6) cols(2) order(1 "66-68 year-olds" 4 "62-64 year-olds"))
	xtitle("Year")
	ytitle("Normalized excess mass")
	ylabel(0(1000)5000)
	xlabel(1982(2)1992)
	xline(1990, lcolor(gs10)) yline(0, lcolor(gs10))
	graphregion(color(white))
;
# delimit cr
graph export "$figdir/figure7.pdf", replace 

		
