%% f_setData1990
%
% Set up data structures to evaluate the 1989-1990 change 

function [dataB, bunchBSB, dataPre, bunchBSPre, dataPost,  bunchBSPost] = ...
    setDynamicData(bw, yMin, yMax ,t0,t1Pre,t1Post,density, ages, scale, method)
    
    % Load the data
    rawBS = importdata(sprintf('yearBS_7802_6668_%g_s1Main.txt',bw));
    rawBunch = importdata(sprintf('yearStatsDensPoly_7802_6668_%g_s1Main.txt',bw));
    rawZStar = importdata('realZStar.csv');    
    bunchYear = rawBunch.data(:,1);
    
    % Make sure years line up
    assert (yMin>=1978 && yMin<=1989 && yMax >=1990 && yMax<=2002) ;
    yearsPre = 1990 - yMin;
    
    bunch = bw/scale.*rawBunch.data(:,2);
    year = bunchYear;    
    bunchBS = bw/scale.*(rawBS.data(:,2:end));
    assert(isequal(size(bunchBS,1), size(bunch,1)));
    
    zStarPost = rawZStar.data(:,3)/scale;
    zStarYear = rawZStar.data(:,1);

    % Set up the data for estimating both, using pre and post data
    yIX = logical( (year>=yMin) .* (year<=yMax) ); 
    dataB.year = year(yIX);
    dataB.ts = 3.*(dataB.year<=1989) + (dataB.year-1989).*(dataB.year>1989);
    dataB.t0 = t0.*ones(yMax - yMin + 1, 1);
    t1Long  =  t1Pre.*(year<1990) + t1Post.*(year>=1990) ; 
    dataB.t1 = t1Long(yIX);
    dataB.pre = (year(yIX) < 1990);
    dataB.last = (dataB.year == 1989);
    zsSample = logical( (zStarYear>=yMin).*(zStarYear<=yMax) );
    dataB.zStar = zStarPost(zsSample);
        
    dataB.mu = 10.12; % from tobitClaim log
    dataB.sigma = 1.266; 
    
    sample = ( (year>=yMin).* (year<=yMax));
    dataB.bunch = bunch(sample==1);
    dataB.rk = zeros(size(sample));
    dataB.density = density;
    bunchBSB = bunchBS(sample==1,:);
        
    % Structure available in both periods with pre-period tax info
    dataB.tPre.t1 = t1Pre;
    dataB.tPre.t0 = t0;
    dataB.tPre.zStar = dataB.zStar(years<1990);
    
    dataB.tPost.t1 = dataB.t1(years>=1990);
    dataB.tPost.t0 = dataB.t0(years>=1990);
    dataB.tPost.zStar = dataB.zStar(years>=1990);
        
    % Calculate density
    dataB.scale = 1000/scale;
    dataB.bw = bw/scale;
    dataB.density = density;
    densityData = importdata('dens72_8399_800_s1Main.csv');
    yearRange = logical( (zStarYear>=1983).*(zStarYear<=1989) );
    zStarMean = mean( zStarPost(yearRange)) ;
    dataB.income = dataB.scale.*densityData.data(:,2) + zStarMean;
    if strcmp(density, 'flexible')
        densityData = importdata(sprintf('dens%s_8399_%g_s1Main.csv', ages, bw));
        yearRange = logical( (zStarYear>=1983).*(zStarYear<=1989) );
        zStarMean = mean( zStarPost(yearRange)) ;
        dataB.income = dataB.scale.*densityData.data(:,2) + zStarMean;
        prob = densityData.data(:,1);
        dataB.dist = cumsum(prob);       
        dataB.dens = prob ./ (bw/scale);
        zStarPoint = logical( densityData.data(:,2) == 0 );
        dataB.densAK = prob(zStarPoint)/dataB.bw;
    end    
   
    % Data for pre period
    dataPre = dataB;
    dataPre.t1 = t1Pre.*ones(yearsPre,1) ;
    dataPre.t0 =  t0.*ones(yearsPre,1);
    dataPre.pre = ones(yearsPre,1);
    dataPre.zStar = zStarPost( (zStarYear<1990).*(zStarYear>=1990-yearsPre)==1 );
    dataPre.mu = 10.12; % from tobitClaim log
    dataPre.sigma = 1.266; 
    
    sample = ( (year<1990).* (year>=1990-yearsPre));
    dataPre.bunch = bunch(sample==1);
    dataPre.rk = zeros(sum(sample),1);
    dataPre.density = density;
    bunchBSPre = bunchBS(sample==1,:);
    
    % Data for post period
    dataPost = dataB;
    dataPost.t1 = t1Post;
    dataPost.t0 =  t0;
    dataPost.pre = 1; % set to one because we set phi = 0 when using this sample 
    dataPost.zStar = zStarPost(zStarYear==1990);
    
    dataPost.mu = 10.12; % from tobitClaim log
    dataPost.sigma = 1.266; 
    
    sample = (year==1990);
    dataPost.bunch = bunch(sample==1);
    dataPost.rk = 0;
    dataPost.density = density;
    bunchBSPost = bunchBS(sample==1,:);
    
    dataB.method = method;
    
end
