%% printPooledResults
%
% Takes name, estimates, and bootstrap estimates, forms confidence
% intervals, and prints things cleanly

function printPooled(name, est, estsBS, scalePhi)

        mPr = exp(est(3:end)) ./ (1+exp(est(3:end)));
        cPr = cumprod(mPr);
        est = [est(1) (1e3/scalePhi)*est(2) cPr];

        % Form confidence intervals and calculate p-values
        mPr = exp(estsBS(:,3:end)) ./ (1+exp(estsBS(:,3:end)));
        cPr = cumprod(mPr,2);
        estsBS = [estsBS(:, 1) (1e3/scalePhi)*estsBS(:,2) cPr];
        lCI = percentile(estsBS, .025);
        uCI = percentile(estsBS, .975);
        
        ltz = 2*sum( estsBS <= zeros(size(estsBS)))./size(estsBS,2);

        fprintf('\n');
        fprintf(' %s ', name);
        
        for ii = 1:length(est)
            if (abs(est(ii))>5)
                fprintf('&          %6.0f         ', est(ii));
            else
                fprintf('&          %5.2f         ', est(ii));
            end
        end
        
        fprintf(' \\\\ \n');
        fprintf('                     ');
        for ii = 1:length(lCI)
            if ltz(ii) >= 11 
                stars = '';
            elseif ltz(ii) >= 6
                stars = '$^{*}$';
            elseif ltz(ii) >= 2 
                stars = '$^{**}$';
            else
                stars = '$^{***}$';
            end

            if (abs(est(ii))>5)
                fprintf('& (%6.0f, %6.0f)%s ', lCI(ii), uCI(ii), stars);                
            else 
                fprintf('& (%5.2f, %5.2f)%s ', lCI(ii), uCI(ii), stars);
            end
        end
        fprintf(' \\\\ \n');
end