


global directory "C:/Users/dansacks/Dropbox/Taxes_Adjustment_Costs/rAndr2"
global datadir "C:/Users/dansacks/projects/etExtensive"
global scriptdir "C:/Users/dansacks/Dropbox/Taxes_Adjustment_Costs\scripts\ssaScripts"
global logdir "$directory/logs"
local assemble 1 
	
// Settings for Pattison's run
clear all
set more off
version 11


local date = word("$S_DATE",3)+"_"+string(month(date("$S_DATE","DMY")))+"_"+word("$S_DATE",1)

cd d:
global directory "D:/UserData/Pattison/Gelber"

global scriptdir "$directory/current/scripts"
global datadir "$directory/data"
global cpidir "$datadir"

local nostop "nostop"
local assemble 1


// Directories for tables, figures, scripts
global figdir "$directory/current/results`date'/figures"
global tabdir "$directory/current/results`date'/tables"
global logdir "$directory/current/results`date'/logs"

capture mkdir "$directory/current"
capture mkdir "$directory/current/results`date'"
capture mkdir "$logdir"
capture mkdir "$figdir"
capture mkdir "$tabdir"


capture log close

set seed 922

clear mata
set memory 1200M

set more off


/* assemble the data */

	if `assemble' {
	
		if "$directory" == "bulk/state_eitc/" | strpos("$directory", "ropbox"){
			log using "$logdir/makeFakeData.log" ,replace
			*do "$scriptdir/assembleSSA_fake.do"
			log close
		}
		
		log using "$logdir/assembleSSA_CFOP.log", replace
		do "$scriptdir/assembleSSA_RR2.do", `nostop'
		log close
	}

	
/* Claiming probabilities, age-year, in sample and out */
	log using "$logdir/claimProbs.log", replace
	do "$scriptdir/calcClaimProbs.do", `nostop'
	log close
	
/* Earnings distributions, 1983-1999, by age and sample */
	log using "$logdir/earnDist.log", replace
	do "$scriptdir/makeEarnDist", `nostop'
	log close






