%% f_est1990
%
% Estimate e, phi for 1990, for given specification rules, print results

function est6970(bw,ages,t0,t1Pre,t1Post,density,optInner,optOuter,p0,name, agesDensity, scale)

    [dataB,bunchBSB, dataPre, bunchBSPre] = setData6970(bw, ages, ...
        t0,t1Pre,t1Post,density, agesDensity, scale);
    wMat = eye(length(ages));

    % Estimate both
     [estEP, objVal, flag] = fminsearch(...
        @(p) calcGmm6970([p 0], dataB, wMat, optInner), p0, optOuter);
     assert (objVal < 1e8);
     assert (flag == 1);

    % Bootstrap standard errors
    [~, epLB, epUB, estEP_p, ~, jacDet] = calcBSSE6970(...
        estEP, dataB,wMat,bunchBSB, optInner, optOuter);        

    % Stars
    if estEP_p(1)<=0.01 
        eStars = '***';
    elseif estEP_p(1)<=0.05
        eStars = '** ';
    elseif estEP_p(1)<=0.1
        eStars = '*  ';
    else 
        eStars = '   ';
    end
    if estEP_p(2) <=0.01
        phiStars = '***';
    elseif estEP_p(2)<=0.05
        phiStars = '** ';
    elseif estEP_p(2)<=0.1
        phiStars = '*  ';
    else 
        phiStars = '   ';
    end

    % Estimate e using pre-period data
    wMat = eye(sum(ages<70)); 
    [estElPre, objVal, flagT] = fminsearch(...
        @(e) calcGmmNoAC(e, dataPre, wMat), estEP(1), optOuter);
    assert (flagT == 1 || objVal<1e-6) 

    % Bootstrap SEs
    [~, ~, ePreLB, ePreUB, estEPre_p] = calcBSSE_e(...
        estElPre, dataPre,wMat,bunchBSPre, optOuter);        

    % Stars
    if estEPre_p <=0.01 
        ePreStars = '***';
    elseif estEPre_p <=0.05
        ePreStars = '** ';
    elseif estEPre_p <=0.1
        ePreStars = '*  ';
    else
        ePreStars = '   ';
    end

    % Output results 
    fprintf(' %s: &     %4.2f      &     %6.0f      &     %4.2f      \\\\ \n',name, estEP(1), scale*estEP(2), estElPre)
    fprintf('           & [%4.2f, %4.2f]%s & [%6.0f, %6.0f]%s & [%4.2f, %4.2f]%s \\\\ \n', epLB(1), epUB(1), eStars, scale*epLB(2), scale*epUB(2), phiStars, ePreLB, ePreUB, ePreStars);

   % fprintf('Flag: %g\n', flag);
   % fprintf('Obj val final: %g \n', objVal);
            
        %  Determinant info:
       % nP = sum(jacDet > 0);
       % n0 = sum(jacDet == 0);
        %fprintf('  N jacDet positive %4.0f , n zero %4.0f \\\\ \n', nP, n0);
end