%% calcBoundsDynamic


function [z1Bar, z0Bar, uzOpt, flag] = calcCutoffs(params, data)


    % pull out parameters 
    e = params(1);
    phi = params(2);

    % optimal upper given by size
    uzOpt = data.zStar.*( (1-data.t0)./(1-data.t1) ).^e;
    flag = 1;

    % find lowest buncher in each year 
    % defined by indifference between
    % (1) staying at optimal earnings under linear tax but facing nonlinear
    % (2) adjusting to optimal earnings under nonlinear tax, paying cost
    
    ixs = (1:length(data.ts))'; 
    z1Bar = zeros(size(data.ts));
    
    for ii = ixs' 
        
        % set up tax system
        tax.t0 = data.t0(ii);
        tax.t1 = data.t1(ii);
        tax.zStar = data.zStar(ii);
        z0 = [tax.zStar uzOpt(ii)];
        
        % if upper buncher doesn't adjust, zFric = upper Z 
        deltaU = uOpt(z0(2),e, tax) ...
            - uQL(z0(2), z0(2)/(1-tax.t0).^e, e, tax) - phi;
        
        % If phi <= 0, everyone adjusts 
        if phi <= 1e-8 
            z1BarT = data.zStar(ii);
            flagT = 1;        
        
        elseif deltaU < 0 
            z1BarT = z0(2);
            flagT = 1;
            
        % otherwise find indifference
        else 
            u1 = uOpt(z0(1),e, tax)- uQL(z0(1), z0(1)./(1-tax.t0).^e, e, tax) - phi;            
            u0 = uOpt(z0(2),e, tax)- uQL(z0(2), z0(2)./(1-tax.t0).^e, e, tax) - phi;
            
            if (u1 >0 && u0>0) || (u1< 0 && u0 <0) 
               e
               phi
               [u1 u0]
               z0
            end
            
            [z1BarT, ~, flagT] = fzero(@(zOld) uOpt(zOld,e, tax) ...
                - uQL(zOld, zOld./(1-tax.t0).^e, e, tax) - phi, ...
                z0, data.opt);
        end
        if flagT ~= 1
            flag = 0;
        end 
        z1Bar(ii) = z1BarT;
    end
    
    % frictional upper buncher: just indifferent to adjusting to new kink
    % Frictional upper bound: optimal in pre-period, indiff   post,
    % need cut-off from indiffernce condition 
    %   (eq 4, p. 21 of RES submission)
    %
    % adjusted for case of phi <= 0 (full adjustment)
    % and for case of phi so large that there's no soln (no adjustment)
    ixs = (1:length(data.pre))'; 
    ixs = ixs(data.pre==0);
    z0Bar = uzOpt;
    
    for ii = ixs' 
        tax.t0 = data.t0(ii);
        tax.t1 = data.t1(ii);
        tax.zStar = data.zStar(ii);
        z0 = [uzOpt(ii) uzOpt(data.last)];
        
        % if upper buncher doesn't adjust, zFric = upper Z 
        deltaU = uOpt(z0(2),e, tax) - uAK(z0(2), e, tax) - phi;
        
        % phi <= 0 --> full adjustment
        if phi <= 0 
            uzFricT = uzOpt(ii);
            flagT = 1;
            
        elseif deltaU < 0 
            uzFricT = z0(2);
            flagT = 1;
            
        % otherwise find indifference
        else 
            [uzFricT, ~, flagT] = fzero(@(zOld) ...
                uOpt(zOld,e, tax) - uAK(zOld, e, tax) - phi, ...
                z0, data.opt);
        end
        z0Bar(ii) = uzFricT;
        if flagT ~= 1
            flag = 0;
        end
    end
    
end