

/* set option for load/append */
capture version 12
if _rc == 0 local append = 0
if _rc != 0 local append = 1

local append 1

/*******************************************************************************************/
/* Calculate parameters of the earnings distribution  for the main sample                  */
/*******************************************************************************************/

    /* 2a. load each decile, make summary stats */
    # delimit ;
    loadAppend,
        data("$datadir/ssa_s1Main`d'")
        append(1)
        if("!missing(earnings) & earnings != 0 & year>=1985 & year<=1994 & age==61")
    ;
    # delimit cr

    merge m:1 year using "$datadir/cpi"
    sum price_level if year==2010
    local p2010 = r(mean)
    keep if _merge == 3


    gen     max = 39600 if year == 1985
    replace max = 42000 if year == 1986
    replace max = 43800 if year == 1987
    replace max = 45000 if year == 1988
    replace max = 48000 if year == 1989
    replace max = 51300 if year == 1990
    replace max = 53400 if year == 1991
    replace max = 55500 if year == 1992
    replace max = 57600 if year == 1993
    replace max = 60600 if year == 1994

    table year if  year>=1985 & year<=1994, c(mean earnings max earnings mean max)
    gen realMax = .
    forvalues year=1985/1994{
        sum real_earnings if year == `year'
        replace realMax = r(max) if year == `year'
    }
    gen lz = ln(real_earnings)
    table year, c(mean lz sd lz) row

    gen offset = -ln(realMax)
    gen lzShift = lz+offset
    
    tobit lzShift, offset(offset) ul(0)
    
/*******************************************************************************************/
/* Calculate claiming rates, for alternative sample                                        */
/*******************************************************************************************/
    # delimit ;
    loadAppend,
        data("$datadir/ssa_s1Full`d'")
        append(1)
        if("!missing(earnings) & earnings != 0 &
            year>=1990 & year<=1999 & 
            yob<=1930 & age<=69 & age>=62")
    ;
    # delimit cr
    
    egen tagPerson = tag(id) 
    gen claimAge = startYear-yob
    gen claimBy65 = claimAge<=65
    gen claimBy69 = claimAge<=69
    
    sum claimAge if tagPerson, det 
    sum claimBy65 if tagPerson
    sum claimBy69 if tagPerson

