close all;
clear all;

dynare sim_uvs

irfs_bench_ez = -[UR_ez, v_ez, a_ez, s_ez, qv_ez, qUR_ez, m_ez, -Omega_ez, ne_ez, JF_ez];
irfs_bench_etheta = -[UR_etheta, v_etheta, a_etheta, s_etheta, qv_etheta, qUR_etheta, m_etheta, -Omega_etheta, ne_etheta, JF_etheta];
irfs_bench_edelta = [UR_edelta, v_edelta, a_edelta, s_edelta, qv_edelta, qUR_edelta, m_edelta, -Omega_edelta, ne_edelta, JF_edelta];

save irfs_bench irfs_bench_ez irfs_bench_etheta irfs_bench_edelta;

clear;
dynare sim_DMP

irfs_DMP_ez = -[UR_ez, v_ez, a_ez, s_ez, qv_ez, qUR_ez, m_ez, -Omega_ez, ne_ez, JF_ez];
irfs_DMP_etheta = -[UR_etheta, v_etheta, a_etheta, s_etheta, qv_etheta, qUR_etheta, m_etheta, -Omega_etheta, ne_etheta, JF_etheta];
irfs_DMP_edelta = [UR_edelta, v_edelta, a_edelta, s_edelta, qv_edelta, qUR_edelta, m_edelta, -Omega_edelta, ne_edelta, JF_edelta];

save irfs_DMP irfs_DMP_ez irfs_DMP_etheta irfs_DMP_edelta;


clear;
load irfs_bench;
load irfs_DMP;

var_label={'Unemployment', 'Vacancy', 'Recruiting intensity', 'Search intensity',...
    'Job filling rate', 'Job finding rate', 'Hiring rate', 'Match efficiency', 'Entry', 'Match value'};
nsteps=18;
nvars=length(var_label); 
ncolumn=2;

% Compare irfs from benchmark model vs. constant intensity
nvars = 8;
figure;
for i=1:nvars;
    subplot(nvars/ncolumn,ncolumn,i);
    plot(1:nsteps, irfs_bench_ez(1:nsteps,i),'-k',1:nsteps, irfs_DMP_ez(1:nsteps,i), '--b','Linewidth', 1.5);
    title(char(var_label(i)));
end;
legend({'Benchmark','Standard model'},'FontSize',11,'Orientation','horizontal','Location','southoutside');
print -dpdf outfig_irfs_ez_compare_DMP.pdf;

figure;
for i=1:nvars;
    subplot(nvars/ncolumn,ncolumn,i);
    plot(1:nsteps, irfs_bench_etheta(1:nsteps,i),'-k',1:nsteps, irfs_DMP_etheta(1:nsteps,i), '--b','Linewidth', 1.5);
    title(char(var_label(i)));
end;
legend({'Benchmark','Standard model'},'FontSize',11,'Orientation','horizontal','Location','southoutside');
print -dpdf outfig_irfs_etheta_compare_DMP.pdf;

figure;
for i=1:nvars;
    subplot(nvars/ncolumn,ncolumn,i);
    plot(1:nsteps, irfs_bench_edelta(1:nsteps,i),'-k',1:nsteps, irfs_DMP_edelta(1:nsteps,i), '--b','Linewidth', 1.5);
    title(char(var_label(i)));
end;
legend({'Benchmark','Standard model'},'FontSize',11,'Orientation','horizontal','Location','southoutside');
print -dpdf outfig_irfs_edelta_compare_DMP.pdf;

   

