% Older Americans Would Work Longer If Jobs Were Flexible
% by Ameriks, Briggs, Caplin, Lee, Shapiro, and Tonetti
% This version: January 2019. 

% This code creates Figure 6, which illustrates how SSQ responses are
% mapped to IES values.  

clear all
clc

% Calibration: Considers a person whose reference work condition is
% full-time (h_0 = 0.385). Fixed costs of work are 4% of total time and 14%
% of the labor earnings under the full time work. 
h0 = 0.385; 
hbar = 0.04; 
chat = 0.14; 

% Considered values of the number of hours under the flexible schedule (as 
% a fraction of full-time work) and the IES.  
hf = (0.5:0.01:0.99)';
IES = [0.1; 0.25; 0.5; 1; 2; 0.001]; 

n_IES = length(IES); n_hf = length(hf); 

wf = zeros(n_hf, n_IES); 

% Calculating the reservation wage for the flexible job, as a fraction of
% the reservation wage for the full-time job, following equation (9) in the
% text. 
for ih = 1:n_hf
   for iI = 1:n_IES 
       gamma = IES(iI) * h0 / (1-hbar - h0); 
        wf(ih, iI) = 1/hf(ih) - ...
            (1/hf(ih))*(1-chat)*(((1-hbar-hf(ih)*h0)^(1-1/gamma)-(1-hbar-h0)^(1-1/gamma))/(1-(1-hbar-h0)^(1-1/gamma)));
   end
end


figure(1)
plot(hf, wf(:,1),hf,wf(:,2), hf,wf(:,3), hf,wf(:,4),hf,wf(:,5),hf,1./hf,'k:','linewidth',2); 
legend('IES=0.1', 'IES=0.25', 'IES = 0.5', 'IES = 1.0',  'IES = 2.0','\it w_{flex}h_{flex} = w_{fixed}h_{fixed}','location','northwest')
xlabel('\it h_{flex}/h_{fixed}')
ylabel('\it w_{flex}/w_{fixed}')
set(gca,'YLim',[0.2 1.4])
set(gca,'YTick',(0.2:0.2:1.4))
