function [Y] = fct_sys_ab(x,ppi,B,r,sigma,psi)  

a = x(1) ;  b = x(2);

% vars
eta1 = (-ppi - sqrt(ppi^2+2*r*sigma^2))/sigma^2 ;
eta2 = (-ppi + sqrt(ppi^2+2*r*sigma^2))/sigma^2 ;
% guess init
gbar_guess = (18*psi/B*sigma^ 2)^.25 ; 
glow_guess = - gbar_guess ;
% solve for glow,gbar  given a,b
ghat = (a+b)/2;
% solve for glow, gbar given  (a,b) -- amounts to solving a system of 2 equations (smooth pasting)
gguess=[glow_guess gbar_guess];
opt = optimset('Display','off');
warning off
[bounds_sol] = fsolve(@(z) fct_sys2(z,a,b,B,ppi,r,eta1,eta2,psi),gguess,opt);
gbar = max(bounds_sol) ;
glow = min(bounds_sol) ;

%  now find equations for optimal :  a , b
xi = -2*ppi/sigma^2;
%Acoeff = 1/ppi* ( ( glow-ghat +(1-exp(xi*(glow-ghat)))/xi ) / ( exp(xi*glow)-exp(xi*gbar) )  + exp(-xi*ghat)/xi  )  ;  
Acoeff = 1/ppi* ( ( glow-ghat +(1-exp(xi*(gbar-ghat)))/xi ) / ( exp(xi*glow)-exp(xi*gbar) )    )  ;  
da0 = glow/ppi + Acoeff*(1-exp(xi*glow)) ;
Ccoeff = 1/ppi*( ( (glow-ghat)/xi + (glow^2-ghat^2)/2 + (1+ghat*xi)/xi^2*(1-exp(xi*(gbar-ghat))) ) / ( exp(xi*glow)-exp(xi*gbar) )  )  ;  
na0 = glow/(ppi*xi) + glow^2/(2*ppi)+Ccoeff*(1-exp(xi*glow)) ;
Ecoeff = 1/ppi * ( gbar-ghat + (1-exp(xi*(gbar-ghat)))/xi ) / ( exp(xi*gbar)-exp(xi*glow) )    ;  
db0 = Ecoeff*(1-exp(xi*glow)) ;
Fcoeff = 1/ppi * ( (gbar-ghat)/xi + (gbar^2-ghat^2)/2 + (1+ghat*xi)/xi^2*(1-exp(xi*(gbar-ghat))) ) / ( exp(xi*gbar)-exp(xi*glow) )   ;  
nb0 = Fcoeff*(1-exp(xi*glow)) ;

Y(1)=  a - na0/da0;
Y(2)=  b - nb0/db0;

