function [ yy ] = fct_sys2(gguess,a,b,B,ppi,r,eta1,eta2,psi)
% -- finds glow, gbar given a,b, -- amounts to solving a system of 2 equations (smooth pasting)

glow=gguess(1);
gbar=gguess(2);
ghat = (a+b)/2;

%  Solve 4 constants xi_ij given glow, gbar

% Solve constants  AA(4,4)*xi(4,1) =  BB(4,1)
% xi has == [xi01  xi02  xi11 xi12 ]
AA(1,1:4)= [ exp(eta1*glow)-1   exp(eta2*glow)-1 0 0 ];  
AA(2,1:4)= [ -1  -1  exp(eta1*gbar)  exp(eta2*gbar)  ];  

BB(1,1) = psi - B/r*(2*glow*(ppi/r-a)+glow^2) ;
BB(2,1) = psi - B/r*(b^2-a^2+ 2*ppi*(a-b)/r + 2*gbar*(ppi/r-b)+gbar^2) ;

AA(3,1:4) = [ exp(eta1*ghat)  exp(eta2*ghat)  -exp(eta1*ghat)  -exp(eta2*ghat)  ];  
BB(3,1)   =  - B/r * ( a^2 - b^2 + 2*(ppi/r+ghat)*(b-a) ) ;

AA(4,1:4) = [ eta1*exp(eta1*ghat)  eta2*exp(eta2*ghat) -eta1*exp(eta1*ghat)  -eta2*exp(eta2*ghat)  ];  
BB(4,1)   =  - 2*B/r * (b-a)  ;

xi_vec=linsolve(AA,BB); % AA\BB;
xi01=xi_vec(1);xi02=xi_vec(2);xi11=xi_vec(3);xi12=xi_vec(4);

yy(1) = B/r*(2*(ppi/r-a)+2*glow)+xi01*eta1*exp(eta1*glow)+xi02*eta2*exp(eta2*glow) ;
yy(2) = B/r*(2*(ppi/r-b)+2*gbar)+xi11*eta1*exp(eta1*gbar)+xi12*eta2*exp(eta2*gbar) ;
