% Solves for optimal prices (a,b) in the plans problem with inflation 
% LOOP over inflation rates and compares outcomes with Arg data
% F. Lippi,  December 2017; revised Jan 2019
clear all
close all

ppi_vec=[ 0.0136 0.05 0.07 0.10 0.15 0.25 0.30 0.50 0.75 1 1.5 2 3 5 7 ]; % Units: c.c. per year (not yet in %)

NN = length(ppi_vec); 

T  = 5000 ; % simulation length in years 

psi   = 0.01; % menu cost (key param; baseline 0.01 )

% Remaining standard params
B     = 20    ; 
sigma = 0.10   ;
r     = 0.02  ;

% Golosov Lucas bench param at zero inflation
targetN_peryear=.3*26 ; 

ybar_GL = sigma*sqrt(1/targetN_peryear); 
psi_GL = ybar_GL^4/6*B/sigma^2; 

% Discrete time period for simulations
dt = 1/26; % for 2 week period   %1/26  % 1/52; % 1/52; % 1/365;  

% initial guess from model with ppi=0
gbar0  = (18*psi/B*sigma^ 2)^.25 ; gbar=gbar0;
glow0=-gbar0 ; glow=glow0;
gtilde = 1/3*gbar0  ; a=-gtilde; b=gtilde; 
ab_guess = [-gtilde  , gtilde ]; 
opt = optimset('Display','off');

for i=1:NN

    ppi=ppi_vec(i);
    
    disp(['solving and simulating Alvarez-Lippi AEJ 2019 model for inflation = ',num2str(ppi)]);
    % initial conditions
    
    % GLSW model
    [ plow_GL, pstar_GL, pbar_GL,hat_a1, hat_b, plow_app, pstar_app, pbar_app, plow_sw, pstar_sw, pbar_sw,  norm_f_val, N_adj]...
        = fct_solve_optimal_policy_undiscounted_ppi(B,psi_GL,sigma,ppi)   ;
    norm_f_val_vec(i)=norm_f_val;
    if norm_f_val_vec(i)>0.0001
        disp(['for inf = ',num2str(ppi),'  ; norm fval for SWGL model is big, =', num2str(norm_f_val,4)])
    end

    if ppi < 1.5
        
                
        if ppi < 0.35
          
           gbar0 = (gbar0+gbar)/2;
           glow0=(glow0+glow)/2;
           ab_guess = [(-gtilde+a)/2  , (gtilde +b)/2]; 
                
        else             
            %  Sheshinsky weiss bounds
            psi_sw=psi/2;
            m = ( 3/4*psi_sw/B*ppi )^(1/3)  ;
            a0 = (m+a)/2; 
            b0 = (3*m+b)/2;
            gbar0 = (4*m + gbar)/2;
            
            %  find excessive HIGH markup threshold using SW;  Fernando's notes on r==0
            alpha1=-(psi_sw*3/4)^(2/3)*(B/ppi)^(1/3);
            alpha3= B/(3*ppi);
            ppbar = fzero(@(x) x*(alpha1 +alpha3*x^2)- m*(alpha1 +alpha3*m^2) - psi_sw , 2*m  ) ;
            glow0 = m-ppbar; % lower threshold for adjustment of plans
            
            glow0 = (glow0+glow)/2; 
            
            ab_guess = [a0, b0 ]; opt = optimset('Display','off');
        end
        
        [ab_sol,fval,exitflag] = fsolve(@(z) fct_sys_ab(z,ppi,B,r,sigma,psi),ab_guess,opt);
        a=min(ab_sol);
        b=max(ab_sol);
        
        %%%%%% Now solve for VF and plot solution
        ghat = (a+b)/2;
        % vars
        eta1 = (-ppi - sqrt(ppi^2+2*r*sigma^2))/sigma^2 ;
        eta2 = (-ppi + sqrt(ppi^2+2*r*sigma^2))/sigma^2 ;
        
        % solve for glow, gbar given   (a,b)
        % -- amounts to solving a system of 2 equations (smooth pasting)
        [bounds_sol,fval,EXITFLAG] = fsolve(@(x) fct_sys2(x,a,b,B,ppi,r,eta1,eta2,psi),[glow0 gbar0],opt);
        gbar = max(bounds_sol) ; glow = min(bounds_sol) ;
        
        % Solve constants  AA(4,4)*xi(4,1) =  BB(4,1)
        % zi has == [zi01  zi02  zi11 zi12 ]
        AA(1,1:4)= [ exp(eta1*glow)-1   exp(eta2*glow)-1 0 0 ];
        AA(2,1:4)= [ -1  -1  exp(eta1*gbar)  exp(eta2*gbar)  ];
        BB(1,1) = psi - B/r*(2*glow*(ppi/r-a)+glow^2) ;
        BB(2,1) = psi - B/r*(b^2-a^2+ 2*ppi*(a-b)/r + 2*gbar*(ppi/r-b)+gbar^2) ;
        AA(3,1:4) = [ exp(eta1*ghat)  exp(eta2*ghat)  -exp(eta1*ghat)  -exp(eta2*ghat)  ];
        BB(3,1)   =  - B/r * ( a^2 - b^2 + 2*(ppi/r+ghat)*(b-a) ) ;
        AA(4,1:4) = [ eta1*exp(eta1*ghat)  eta2*exp(eta2*ghat)  -eta1*exp(eta1*ghat)  -eta2*exp(eta2*ghat)  ];
        BB(4,1)   =  - 2*B/r * (b-a)  ;
        zi_vec   =  AA\BB  ;
        % xi01     =  zi_vec(1);xi02=zi_vec(2);xi11=zi_vec(3);xi12=zi_vec(4);
        
        gvec = linspace(glow,gbar)  ;
        vvplan_vec = fct_vf(gvec,a,b,B,ppi,r,sigma,glow,gbar,eta1,eta2,zi_vec);
 
         
    else % ppi > 2.5 so use SW model
        psi_sw = psi/2;
        m = ( 3/4*psi_sw/B*ppi )^(1/3)  ;
        a = m;
        b = 3*m;
        gbar = 4*m;
        ghat = (a+b)/2;
        
        %  find excessive HIGH markup threshold using SW;  Fernando's notes on r==0
        alpha1=-(psi_sw*3/4)^(2/3)*(B/ppi)^(1/3);
        alpha3= B/(3*ppi);
        ppbar = fzero(@(x) x*(alpha1 +alpha3*x^2)- m*(alpha1 +alpha3*m^2) - psi_sw , 1.5*m  ) ;
        glow = m-ppbar; % lower threshold for adjustment of plans      
        
        eta1 = (-ppi - sqrt(ppi^2+2*r*sigma^2))/sigma^2 ;
        eta2 = (-ppi + sqrt(ppi^2+2*r*sigma^2))/sigma^2 ;
        % Solve constants  AA(4,4)*xi(4,1) =  BB(4,1)
        % zi has == [zi01  zi02  zi11 zi12 ]
        AA(1,1:4)= [ exp(eta1*glow)-1   exp(eta2*glow)-1 0 0 ];
        AA(2,1:4)= [ -1  -1  exp(eta1*gbar)  exp(eta2*gbar)  ];
        BB(1,1) = psi_sw - B/r*(2*glow*(ppi/r-a)+glow^2) ;
        BB(2,1) = psi_sw - B/r*(b^2-a^2+ 2*ppi*(a-b)/r + 2*gbar*(ppi/r-b)+gbar^2) ;
        AA(3,1:4) = [ exp(eta1*ghat)  exp(eta2*ghat)  -exp(eta1*ghat)  -exp(eta2*ghat)  ];
        BB(3,1)   =  - B/r * ( a^2 - b^2 + 2*(ppi/r+ghat)*(b-a) ) ;
        AA(4,1:4) = [ eta1*exp(eta1*ghat)  eta2*exp(eta2*ghat)  -eta1*exp(eta1*ghat)  -eta2*exp(eta2*ghat)  ];
        BB(4,1)   =  - 2*B/r * (b-a)  ;
        zi_vec   =  AA\BB  ;
        
        gvec = linspace(glow,gbar)  ;
        vvplan_vec = fct_vf(gvec,a,b,B,ppi,r,sigma,glow,gbar,eta1,eta2,zi_vec);
 
         
    end % if ppi < 2.5
    
    % simulate outcomes for plans
      [frac_4month_3ormore_spell(i),distinct_indx_norm(i),Pr_dp(i),distinct_value_indx_q_cond(i),...
       PR_Ref_change(i),time_at_ref(i),time_below_ref(i),time_at_ref_max(i),...
       time_below_ref_max(i),Pr_dp_pos(i),PR_Ref_change_pos(i),fract_of_Adjst_to_New_P(i),...
       N_Dp_peryear(i),N_Dp_ref_peryear(i),N_plans_peryear(i)]...
          =fct_simulate(dt,T,a,b,glow,gbar,ppi,sigma);  
      
     % simulate outcomes for GL 
     [frac_4month_3ormore_spell_GL(i),distinct_indx_norm_GL(i),Pr_dp_GL(i),...
          PR_Ref_change_GL(i),time_at_ref_GL(i),time_below_ref_GL(i),time_below_ref_max_GL(i),fract_of_Adjst_to_New_P_GL(i),...
           N_Dp_peryear_GL(i),N_Dp_ref_peryear_GL(i)]...
         = fct_simulate_GL(dt,T,plow_GL,pstar_GL,pbar_GL,ppi,sigma) ;
      
    
end % ppi. loop


% load ARG. data with meas error correction 
% it has meas error correction for small price changes;   
data_arg_min = readtable('argentina_stats_ALL_Dec_minmode.csv');

% load ARG. data : mode computed as max mode when there are multiple modes
data_arg_max = readtable('argentina_stats_ALL_Dec_maxmode.csv');

inf            = data_arg_max.inflation ;
distinct       = data_arg_max.distinct ;
distinct3      = data_arg_max.distinct_atleast3;
distinct3norm  = data_arg_max.distinct_atleast3_norm;
prob           = data_arg_max.PR ;
prob_pos       = data_arg_max.PR_pos ;

%prob_ref       = data_arg_max.PR_ref ; 
prob_ref       = data_arg_max.PR_ref_F ; 
prob_ref_pos   = data_arg_max.PR_ref_pos ; 

at_ref           = data_arg_max.at_ref;
frac_below_min   = data_arg_min.below_ref./(1-at_ref);
frac_below_max   = data_arg_max.below_ref./(1-at_ref);

ratio_frac_below_max_min_data  = data_arg_max.below_ref./data_arg_min.below_ref ;

ratio_frac_below_max_min_plan  = time_below_ref_max./time_below_ref ;

ratio_frac_below_max_min_GL    = time_below_ref_max_GL./time_below_ref_GL ;

ratio_time_at_ref_max_min_data = data_arg_max.at_ref./data_arg_min.at_ref ;


%novelty_indx = data_arg_max.novelty ;
novelty_indx = data_arg_max.novelty_indx ;
%share of price changes that are new:
share_new_pr = data_arg_max.Share;
 
%%%%%%%%%%%%%%%%%%%%%

figure(1) 
semilogx( ppi_vec*100,  Pr_dp ,'k--',abs(inf), prob,'rd','Linewidth',3 )
legend({'model','data'},'fontsize',18,'Location','Northwest')
xlabel('  Inflation % cc per year (log scale)','Fontsize',22);
ylabel('  Prob. price change  ','Fontsize',22);
ax=gca;
ax.XTick = [1,2,5,10,25,50,100,200,400,800];
ax.XTickLabel = {'1','2','5','10','25','50','100','200','400','800'};

% print -depsc ./figures/fig_prob_Dp1
% print -dpdf ./figures/fig_prob_Dp1

figure(11) 
semilogx( ppi_vec*100,  Pr_dp ,'k--', ppi_vec*100,  Pr_dp_GL ,'b:', abs(inf), prob,'rd','Linewidth',3 )
legend({'Plans model','GL model','data'},'fontsize',18,'Location','Northwest')
xlabel('  Inflation % cc per year (log scale)','Fontsize',22);
ylabel('  Prob. price change  ','Fontsize',22);
ax=gca;
ax.XTick = [1,2,5,10,25,50,100,200,400,800];
ax.XTickLabel = {'1','2','5','10','25','50','100','200','400','800'};

% print -depsc ./figures/fig_prob_Dp2
% print -dpdf ./figures/fig_prob_Dp2

figure(2) 
semilogx( ppi_vec*100,  PR_Ref_change ,'k--',abs(inf), prob_ref,'rd','Linewidth',3 )
legend({'model','data'},'fontsize',18,'Location','Northwest')
xlabel('  Inflation % cc per year (log scale)','Fontsize',22);
ylabel('   Prob. REF price change ','Fontsize',22);
ax=gca;
ax.XTick = [1,2,5,10,25,50,100,200,400,800];
ax.XTickLabel = {'1','2','5','10','25','50','100','200','400','800'}; 


figure(21) 
semilogx( ppi_vec*100,  PR_Ref_change ,'k--', ppi_vec*100,  PR_Ref_change_GL ,'b:',abs(inf), prob_ref,'rd','Linewidth',3 )
legend({'Plans model','GL model','data'},'fontsize',18,'Location','Northwest')
xlabel('  Inflation % cc per year (log scale)','Fontsize',22);
ylabel('   Prob. REF price change ','Fontsize',22);
ax=gca;
ax.XTick = [1,2,5,10,25,50,100,200,400,800];
ax.XTickLabel = {'1','2','5','10','25','50','100','200','400','800'}; 
% 
%  print -depsc ./figures/fig_prob_DpRef2
%  print -dpdf ./figures/fig_prob_DpRef2

figure(3) 
semilogx( ppi_vec*100,  distinct_indx_norm,'k--',abs(inf), distinct3norm,'rd','Linewidth',3 ) ;
legend({'model','data'},'fontsize',18,'Location','Northwest');
xlabel('  Inflation % cc per year (log scale)','Fontsize',22);
ylabel('   distinct  value index (normalized) ','Fontsize',22);
axis([1 700 0 1.3])
ax=gca;
ax.XTick = [1,2,5,10,25,50,100,200,400,800];
ax.XTickLabel = {'1','2','5','10','25','50','100','200','400','800'};

figure(31) 
semilogx( ppi_vec*100,  distinct_indx_norm,'k--',ppi_vec*100,  distinct_indx_norm_GL,'b:',abs(inf), distinct3norm,'rd','Linewidth',3 ) ;
legend({'Plans model','GL model','data'},'fontsize',18,'Location','southeast')
xlabel('  Inflation % cc per year (log scale)','Fontsize',22);
ylabel('   distinct  value index   ','Fontsize',22);
axis([1 700 0.2 1.1])
ax=gca;
ax.XTick = [1,2,5,10,25,50,100,200,400,800];
ax.XTickLabel = {'1','2','5','10','25','50','100','200','400','800'};

%  print -depsc ./figures/fig_DVI2
%  print -dpdf ./figures/fig_DVI2

figure(41) 
semilogx( ppi_vec*100, fract_of_Adjst_to_New_P ,'k--',ppi_vec*100,fract_of_Adjst_to_New_P_GL,'b:',abs(inf), share_new_pr,'rd','Linewidth',3 ) ; % 
legend({'Plans model','GL model','data'},'fontsize',18,'Location','southeast')
xlabel('  Inflation % cc per year (log scale)','Fontsize',22);
ylabel('  Fraction of New Pr Changes ','Fontsize',22);
axis([1 700 0.3 1.1])
ax=gca;
ax.XTick = [1,2,5,10,25,50,100,200,400,800];
ax.XTickLabel = {'1','2','5','10','25','50','100','200','400','800'};

% print -depsc ./figures/fig_IPN
% print -dpdf ./figures/fig_IPN

figure(5) 
semilogx( ppi_vec*100,  time_at_ref ,'k--', abs(inf), at_ref,'rd','Linewidth',3 )
legend({'model','data'},'fontsize',18,'Location','southwest')
xlabel(' Inflation % cc per year  (log scale)','Fontsize',22);
ylabel(' Time spent at reference price (max) ','Fontsize',22);
ax=gca;
ax.XTick = [1,2,5,10,25,50,100,200,400,800];
ax.XTickLabel = {'1','2','5','10','25','50','100','200','400','800'};


figure(51) 
semilogx( ppi_vec*100,  time_at_ref ,'k--',ppi_vec*100,  time_at_ref_GL ,'b:',  abs(inf), at_ref,'rd','Linewidth',3 )
legend({'Plans model','GL model','data'},'fontsize',18,'Location','southwest')
xlabel(' Inflation % cc per year  (log scale)','Fontsize',22);
ylabel(' Time spent at reference price (max mode) ','Fontsize',20);
ax=gca;
ax.XTick = [1,2,5,10,25,50,100,200,400,800];
ax.XTickLabel = {'1','2','5','10','25','50','100','200','400','800'};

%  print -depsc ./figures/fig_time_at_Ref2
%  print -dpdf ./figures/fig_time_at_Ref2

%  time below reference price
figure(6) 
semilogx( ppi_vec*100,  time_below_ref ./ (1-time_at_ref) ,'k--o',...
          abs(inf), data_arg_min.below_ref./(1-at_ref),'ro', ...
          ppi_vec*100,  time_below_ref_max ./ (1-time_at_ref) ,'k--+', ...
          abs(inf), data_arg_max.below_ref./(1-at_ref),'r+','Linewidth',3 ) ;
legend({'model min-mode','data min-mode','model max-mode','data max-mode'},...
    'fontsize',18,'Location','southwest')
xlabel('  Inflation % cc per year (log scale)','Fontsize',22);
ylabel('  time below ref / ( 1- time at ref)','Fontsize',22);
% set axis labels
hline(0.5,'k')
ax=gca;
ax.XTick = [1,2,5,10,25,50,100,200,400,800];
ax.XTickLabel = {'1','2','5','10','25','50','100','200','400','800'};

  
% print -depsc ./figures/fig_time_below_Ref_minmax1
% print -dpdf ./figures/fig_time_below_Ref_minmax1


% average the data
figure(7) 
semilogx( ppi_vec*100,  (time_below_ref_max + time_below_ref)/2./ (1-time_at_ref) ,'k--', ...
       abs(inf), (frac_below_min+frac_below_max)/2,'rd','Linewidth',3 );
legend({'model (avg between max and min mode)','data (avg between max and min mode)'},'fontsize',18,'Location','southwest')
xlabel('  Inflation % cc per year (log scale)','Fontsize',22);
ylabel('  Fraction time below reference price (norm)','Fontsize',22);
ax=gca;
ax.XTick = [1,2,5,10,25,50,100,200,400,800];
ax.XTickLabel = {'1','2','5','10','25','50','100','200','400','800'};

% print -depsc ./figures/fig_time_below_Ref_mean
% print -dpdf ./figures/fig_time_below_Ref_mean

figure(8) 
semilogx( ppi_vec*100,  time_below_ref_max ./ (1-time_at_ref) , 'k--o', ...
          ppi_vec*100,  time_below_ref_max_GL ./ (1-time_at_ref_GL), 'b--+', ...
          abs(inf), frac_below_max,'rd','Linewidth',3 );
legend({'plan model (max mode) ', 'GL model (max mode)','data (max mode)'},'fontsize',18,'Location','southwest')
xlabel('  Inflation % cc per year (log scale)','Fontsize',22);
ylabel('  frac time below ref / ( 1- fract time at ref.) ','Fontsize',22);
ax=gca;
ax.XTick = [1,2,5,10,25,50,100,200,400,800];
ax.XTickLabel = {'1','2','5','10','25','50','100','200','400','800'};

%  
% print -depsc ./figures/fig_time_below_Ref_max
% print -dpdf ./figures/fig_time_below_Ref_max

figure(9); 
semilogx(abs(inf), data_arg_max.below_ref./(1-at_ref),'ro' ,abs(inf), data_arg_min.below_ref./(1-at_ref),'bo',...
    abs(inf) ,0.5* data_arg_max.below_ref./(1-at_ref)+ 0.5*data_arg_min.below_ref./(1-at_ref), 'k*' );
hline(0.5,'k--');
legend({'using max mode ', 'using min mode', 'average'},'fontsize',18,'Location','best')
xlabel('  Inflation % cc per year (log scale)','Fontsize',22);
ylabel('  frac. below ref. / (1- frac. at ref.)','Fontsize',22);
ax=gca;
ax.XTick = [1,2,5,10,25,50,100,200,400,800];
ax.XTickLabel = {'1','2','5','10','25','50','100','200','400','800'};

% 
% print -depsc ./figures/fig_frac_below_max_min_mode
% print -dpdf  ./figures/fig_frac_below_max_min_mode
