function [ v , vp ] = fct_v_and_vp_alpha( p , hat_a1, hat_b , ppi , N, B , sigma, psi)
% 
% computes the value function and its derivative for the case of r=0 and
% any inflation rate
% the value function is parameterized by hat_a1 and hat_b, as defined in
% the notes.
% N is the order of the highest polynomial
% B, psi, sigma are defined in the notes 

 bar_a4 = - B/(6*sigma^2);
 bar_p = ( (psi/B) * sigma^2 * 6 )^(1/4);
 bar_a2 = - 2 * bar_a4 * bar_p^2;  
 lambda = 2*ppi/sigma^2;  
 
 dim = size(p);
 if dim(1) > dim(2)
    alpha = zeros(1,N);
    ii = [1:1:N] ;
 else
    alpha = zeros(N,1); 
    ii = [1:1:N]' ;
 end
 
 ab = bar_a2+hat_b;
 alpha = (-2*B/sigma^2 + lambda^2 * ab ) .* 2./factorial(ii) .* lambda.^(ii-4) ;
 alpha(1) = hat_a1;
 alpha(2) = ab ;
 alpha(3) = 1/3* lambda * ab ;
 
 % initialize v and v
 v =  p;
 vp = p; 
 
 unos = alpha*0 + 1 ;
 
 for i=1:length(p)
     
    pvec = unos*p(i);
     
    v(i)  = sum( alpha .* pvec.^ii) ;
    vp(i) = sum( alpha .* ii .* pvec.^(ii-1) ) ; 
 
 end   

end

