version 14
#delimit;
set more off;


global data_dir "/Users/davidsblakeslee/Dropbox/Karnataka Water Depletion Study" //put your directory here;
global figure_dir "/Users/davidsblakeslee/Dropbox/Karnataka Water Depletion Study/Figures" // put your directory here;


use "$data_dir/final_data_AER.dta", clear;



kdensity first_bw_ydrilled if household_level == 1, bw(5)
	scheme(s2mono)
	bgcolor(white) graphregion(color(white))
	title("")
	xscale(range(1980 2015))
	xlabel(1980(5)2015)
	xtitle("first borewell, year drilled")
	ytitle("density")
	saving(year, replace);
capture: graph save Graph "$figure_dir/_FigureA1_first_borewell_year.gph", replace;
graph export "$figure_dir/_FigureA1_first_borewell_year.pdf", replace;	

kdensity first_bw_depth if household_level == 1, bw(70)
	scheme(s2mono)
	bgcolor(white) graphregion(color(white))
	title("")
	xtitle("first borewell, depth (feet)")
	ytitle("density")
	saving(depth, replace);
capture: graph save Graph "$figure_dir/_FigureA1_first_borewell_depth.gph", replace;
graph export "$figure_dir/_FigureA1_first_borewell_depth.pdf", replace;






