function [SigmaS,QjFES,age_uS] ...
    = fcn_Estimate_Demand( bootstrap, age, clinical, amc, lnsjs0, lnsjg , p, Xe , Lnsjg , USe_jt, USe, ... 
    qm1, pm1 , LnsjgIV, ageIV, ...
    dum_g, g , num_uniq_thg, num_uniq_th_ght, num_uniq_tj,  ...
    Mht,Mt,h,j, tj,th,th_ght,thg,frac_zeros_jt,eta_jht,etaQW_jht,Nht,Ht,dum_ght,aT,...
    sigmaQ2_inv_start );

%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
% Estimate parameters

%----------------------------------
% test unconstrained nested logit
Y = lnsjs0;
YT = Y(age<=aT,:);
XeT = Xe(age<=aT,:);
check = max(XeT,[],1)';
XeT = XeT(:,check'>0);
X = [ Lnsjg(age<=aT,:) , -p(age<=aT,:) , XeT , ageIV(age<=aT,:) ];
Z = [ LnsjgIV(age<=aT,:) , -pm1(age<=aT,:) , XeT , ageIV(age<=aT,:) ];
X1stage = Z*((Z'*Z)\(Z'*X));
thetaIV = (X1stage'*X1stage)\(X1stage'*YT);
LambdaIV = thetaIV(1:2);
thetapIV = thetaIV(3);
%function [sigmaQ2_inv,rho,QjFEall,age_u] = SigmaQ2_fcn( clinical, amc, Yin , age, XeT , check, aT , ageIV , USe_jt, USe, ...
%    sigmaQ2_inv_start, sigmaEU2_inv, sigmaA2_inv, sigmaAc2_inv , gammaH , lambda , j , aFEversion );
[sigmaQ2_inv,rho,QjFEall,age_u] = SigmaQ2_fcn( clinical, amc, Y-Lnsjg*LambdaIV , age, XeT , check, aT , ageIV , USe_jt, USe, ...
    0, 0, 0, 0 , 0 , 0 , j , 1  );
sigmaQIV = (1./sigmaQ2_inv).^.5;
rhoIV=rho;
QjFEIV=QjFEall;
age_uIV=age_u;
xiIV = YT - X*thetaIV;
rmseIV = (mean(xiIV.^2)).^.5;

%----------------------------------
% estimate NL with supply side constraints

SigmaEU_start = [15]; % can't ID different for non trial from Qj distribution
SigmaA_start = [2;.1]; % set starting value GT learning precisions Ac and A
Thetap_start = thetapIV;
Lambda_start = LambdaIV; %starting value for NL parameters
SigmaH_start = .2*ones(g,1);% [.5;.5]; %starting value for KW preference hetero
GammaH_start = [0]; % set starting value GT learning precisions Ac and A -- H level (inverse of signal correlation across H-- 1=independent; 0=aggregate only)
SigmaAq_start = 0 ;
Mu_start = 0 ;
Sigma_start0 = [Thetap_start;Lambda_start;SigmaH_start;SigmaEU_start;SigmaA_start;GammaH_start;SigmaAq_start;Mu_start]; 
if bootstrap>0
    Parameters_D = importdata('../temp/Parameters_D_0.csv');
    Parameters_D = Parameters_D(:,3);
    Sigma_start0=[Parameters_D(1:8,end);Parameters_D(10:12,end)];
end

% assess criterion at unconstrained IV nested logit + aFE params
aFEversion=1;
Sigma_fix = [ zeros(size(Sigma_start0,1),1) , [zeros(1,3),ones(1,size(Sigma_start0,1)-3)]' ];
Sigma_start = [thetapIV;LambdaIV];
criterionIV=Demand_Cfcn( age, clinical, amc, lnsjs0, lnsjg , p, USe_jt, USe, check, ... 
    qm1, pm1 , LnsjgIV, ageIV, dum_g,XeT,aT, num_uniq_thg, num_uniq_th_ght, num_uniq_tj, ...
    Mht,Mt,h,tj,th,th_ght,thg,frac_zeros_jt,eta_jht,etaQW_jht,Nht,Ht,dum_ght,...
    sigmaQ2_inv,aFEversion,Sigma_fix, Sigma_start );

% run versions, moving toward full model
versions=10;
Sigma_a = zeros(size(Sigma_start0,1)+4,versions);
QjFE_a = zeros(max(j),versions);
age_u_a =zeros(size(age,1),versions);
for spec=1:versions
    if spec==1
        Sigma_start = Sigma_start0(1:3);
        Sigma_fix = [ zeros(size(Sigma_start0,1),1) , [zeros(1,size(Sigma_start,1)),ones(1,size(Sigma_start0,1)-size(Sigma_start,1))]' ];
        aFEversion=1;
    elseif spec==2
        Sigma_start = Sigma_start0(1:5);
        Sigma_fix = [ zeros(size(Sigma_start0,1),1) , [zeros(1,size(Sigma_start,1)),ones(1,size(Sigma_start0,1)-size(Sigma_start,1))]' ];
        aFEversion=1;
    %elseif spec==3 || spec==4
     %   Sigma_fix = [ Sigma , [1;1;1;1;1;0;0;0;0;1] ];
     %   Sigma_start = Sigma_start0(6:9);
     %   aFEversion=2;
     %   if spec==4
     %       sigmaQ2_inv_start=sigmaQ2_inv;
     %       Sigma_start = Sigma_Simplex;
     %   end
    elseif spec==3 || spec==4 || spec==5
        Sigma_start = Sigma_start0(1:8);
        Sigma_fix = [ zeros(size(Sigma_start0,1),1) , [zeros(1,size(Sigma_start,1)),ones(1,size(Sigma_start0,1)-size(Sigma_start,1))]' ];
        aFEversion=0;
        if spec==4 || spec==5
            sigmaQ2_inv_start=sigmaQ2_inv;
            Sigma_start(1:size(Sigma_Simplex,1)) = Sigma_Simplex;
        end
    elseif spec==6 || spec==7 || spec==8
        Sigma_start = Sigma_start0(1:9);
        Sigma_fix = [ zeros(size(Sigma_start0,1),1) , [zeros(1,size(Sigma_start,1)),ones(1,size(Sigma_start0,1)-size(Sigma_start,1))]' ];
        aFEversion=0;
        if spec==7 || spec==8
            sigmaQ2_inv_start=sigmaQ2_inv;
            Sigma_start(1:size(Sigma_Simplex,1)) = Sigma_Simplex;
        end
    elseif spec==9 %add SigmaAq; remove gammaH
        Sigma_start = [ Sigma_start(1:8) ; Sigma_start0(10) ];
        Sigma_fix = [ zeros(11,1) , [zeros(1,8),ones(1,1),zeros(1,1),ones(1,1)]' ];
        aFEversion=0;
        sigmaQ2_inv_start=sigmaQ2_inv;
    elseif spec==10 %try lag poisson(mu)
        Sigma_start = [ Sigma_start(1:8) ; Sigma_start0(11) ];
        Sigma_fix = [ zeros(11,1) , [zeros(1,8),ones(1,1),ones(1,1),zeros(1,1)]' ];
        aFEversion=0;
        sigmaQ2_inv_start=sigmaQ2_inv;
    end
%--------------------------------------------------------------------------
% Differential Evolution to explore param space and get close to optimum
[Sigma_DE] = fcn_Estimate_Demand_DE( age, clinical, amc, lnsjs0, lnsjg , p, USe_jt, USe, check, ... 
    qm1, pm1 , LnsjgIV, ageIV, dum_g,XeT,aT, num_uniq_thg, num_uniq_th_ght, num_uniq_tj, ...
    Mht,Mt,h,tj,th,th_ght,thg,frac_zeros_jt,eta_jht,etaQW_jht,Nht,Ht,dum_ght,...
    sigmaQ2_inv_start, aFEversion, Sigma_fix, Sigma_start );
%--------------------------------------------------------------------------
% Simplex method to zero in from DE grid
Sigma_start=Sigma_DE;
%options = optimset('Display','iter','TolFun',1e-4,'TolX',1e-4,'MaxFunEvals',3000,'MaxIter',100);
options = optimset('TolFun',1e-5,'TolX',1e-4,'MaxFunEvals',3000,'MaxIter',2000);
[Sigma_Simplex,criterion] = fminsearch(@(Sigma_start)Demand_Cfcn( age, clinical, amc, lnsjs0, lnsjg , p, USe_jt, USe, check, ... 
    qm1, pm1 , LnsjgIV, ageIV, dum_g,XeT,aT, num_uniq_thg, num_uniq_th_ght, num_uniq_tj, ...
    Mht,Mt,h,tj,th,th_ght,thg,frac_zeros_jt,eta_jht,etaQW_jht,Nht,Ht,dum_ght,...
    sigmaQ2_inv_start, aFEversion, Sigma_fix, Sigma_start ),Sigma_start,options)
%--------------------------------------------------------------------------
% sigmaQ
Sigma = zeros(size(Sigma_start0,1),1);
    Sigma(Sigma_fix(:,2)==1,:) = Sigma_fix(Sigma_fix(:,2)==1,1);
    Sigma(Sigma_fix(:,2)==0,:) = Sigma_Simplex;
thetap = Sigma(1);
Lambda = Sigma(2:size(dum_g,2)+1,:);
sigmaH2 = Sigma(size(dum_g,2)+2:2*size(dum_g,2)+1,:);
sigmaEU2_inv = Sigma(2*size(dum_g,2)+2);
sigmaAc2_inv  = Sigma(2*size(dum_g,2)+3);
sigmaA2_inv  = Sigma(2*size(dum_g,2)+4);
gammaH = Sigma(2*size(dum_g,2)+5);
sigmaA2q_inv  = Sigma(end-1)/100;
mu = Sigma(end);
if sigmaA2q_inv > 0
    sigmaA2_inv  = sigmaA2_inv + qm1*sigmaA2q_inv;
end
lambda = dum_g*Lambda;
sigmaH2_jt = dum_g*sigmaH2;
R = sigmaH2_jt./ (2*(1-lambda).^2);
Yin = lnsjs0 - lnsjg.*lambda - (1-lambda).*R - thetap*p;
[sigmaQ2_inv,rho,QjFEall,age_u] = SigmaQ2_fcn( clinical, amc, Yin , age, XeT , check, aT , ageIV , USe_jt, USe, ...
    sigmaQ2_inv_start, sigmaEU2_inv, sigmaA2_inv, sigmaAc2_inv , gammaH , lambda , j , aFEversion  );
sigmaQ = (1./sigmaQ2_inv).^.5;
%sigmaQ2_inv_start = sigmaQ2_inv; %use aFE results as input for learning model, and then update for final learning iteration
%if aFEversion==2
%    Sigma_start0(Sigma_fix(:,2)==1,:) = Sigma_fix(Sigma_fix(:,2)==1,1);
%    Sigma_start0(Sigma_fix(:,2)==0,:) = Sigma_Simplex;
%else
%    Sigma_start0(1:size(Sigma_Simplex,1)) = Sigma_Simplex;
%end
sigma2_jt = 1./( USe_jt*sigmaQ2_inv + sigmaEU2_inv + amc.*sigmaA2_inv + clinical.*sigmaAc2_inv );
w_signals_jt = sigma2_jt.*(amc.*sigmaA2_inv + clinical.*sigmaAc2_inv);
d_jt = lnsjs0 - lnsjg.*lambda - (1-lambda).*R - .5*gammaH*(w_signals_jt.*sigma2_jt)./(1-lambda);
xi_jt = d_jt + thetap*p + rho*.5*sigma2_jt - Xe*QjFEall;

Sigma_a(1:8,spec) = Sigma(1:8);
Sigma_a(9,spec) = rho;
Sigma_a(10:12,spec) = Sigma(9:11);
Sigma_a(end-3:end-2,spec) = sigmaQ;
Sigma_a(end-1,spec) = criterion;
Sigma_a(end,spec) = (mean(xi_jt.^2)).^.5;

QjFE_a(:,spec) = QjFEall;
age_u_a(:,spec) = age_u;
end

results = [1,2,5,8,9,10];
SigmaS = [ [thetapIV;LambdaIV;zeros(size(Sigma_a,1)-7,1);sigmaQIV;criterionIV;rmseIV] , Sigma_a(:,results) ];
QjFES = [ QjFEIV , QjFE_a(:,results) ];
age_uS = [ age_uIV , age_u_a(:,results) ];

end

