* This code creates plots of DES share of total stents, and of prices of DES vs. BMS (both plots across US and EU)


ssc install _gwtmean

*** Set up data

* Load
use $dirscratch/post-aggregation.dta, clear
*describe 


*** Compute quantities and prices for all stents, DES, and BMS

* Generate group-specific quantity variables
bysort US t: egen temp_qALL = total (q_r)
bysort US t: egen temp_qDES = total (q_r*DES)
bysort US t: egen temp_qBMS = total (q_r * (1-DES))
gen stat_qpctDES = temp_qDES / temp_qALL * 100

* Generate group-specific price variables: medians
bysort US t: egen stat_pALLmedian = median(p)
bysort US t: egen stat_pDESmedian = median(p) if DES==1
bysort US t: egen stat_pBMSmedian = median(p) if DES==0

* Generate group-specific price variables: quantity-weighted means
egen stat_pALLwmean = wtmean(p), by(US t) weight(q_r)
egen stat_pDESwmean = wtmean(p), by(US t DES) weight(q_r)
replace stat_pDESwmean=. if DES==0
egen stat_pBMSwmean = wtmean(p), by(US t DES) weight(q_r)
replace stat_pBMSwmean=. if DES==1

* Drop duplicates
keep US t temp_q* stat_q* stat_p*
duplicates drop

* NOTE: sudden price drop occurs at t=56 for US DES stents from ~$2100 to $1800.
* Boston Scientific's Promus comes out in month 56 at a price of $1800 with large quantities (immediately 1/4 market share)
* Guidant's Xience V comes out in month 56 at a price of $1770 with large market share (immediately 1/3 market share)



*** Quantity graphs

* Set options

    * Graph
    local lwidthUS     "thick"
    local lwidthEU     "`lwidthUS'"
    local lcolorUS     "maroon"
    local lpatternUS   "longdash"
    local mcolorUS     "`lcolorUS'"
    local msymbolUS    "none"
    local lcolorEU     "navy"
    local lpatternEU   "solid"
    local mcolorEU     "`lcolorEU'"
    local msymbolEU    "none"
    
    * Twoway 
    local graphregiontwoway  "color(white)"
    local ylabtwoway         "0(20)100"
    local ytitletwoway       "Percent of all stents implanted"
    local xtitletwoway       """"
    local titletwoway        """"

* Define option strings

    * Initialize
    local optsUS           ""
    local optsEU           ""
    local twowayoptstwoway ""
    
    * COV and XDES strings
    local regionlist "US EU"
    local optslist  "lcolor mcolor lpattern msymbol lwidth"
    foreach r in `regionlist' {
    foreach o in `optslist'   {
        local opts`r' "`opts`r'' `o'(``o'`r'')"
    }
    }
 
    * Twoway strings
    local twowayoptslist  "graphregion ylab title xtitle ytitle"
    foreach r in `regionlist' {
    foreach t in `twowayoptslist'  {
        local twowayopts "`twowayopts' `t'(``t'twoway')"
    }
    }
    
    * Debug
    display "optsUS: `optsUS'"
    display "optsEU: `optsEU'"
    display "twowayopts: `twowayopts'"

* Plot and export 
twoway (connected stat_qpctDES t if US == 1 , sort `optsUS')                                                       ///
       (connected stat_qpctDES t if US == 0 , sort `optsEU'),                                                        ///
       `twowayopts'                                                                                                                        ///
       xlabel(1(12)97) xlabel(1 "Jan 04" 13 "Jan 05" 25 "Jan 06" 37 "Jan 07" 49 "Jan 08" 61 "Jan 09" 73 "Jan 10" 85 "Jan 11" 97 "Jan 12" 109 "Jan 13")  ///
       legend( order( 2 "EU" 1 "US" )  rows(1))                                                 
graph export $dirresults/E-desshares.eps, replace logo(off)


*** Price graphs

* Series options

    * Colors
    local lcolordesUS     "maroon"
    local mcolordesUS     "`lcolordesUS'"
    local lcolordesEU     "navy"
    local mcolordesEU     "`lcolordesEU'"
    local lcolorbmsUS     "orange_red"
    local mcolorbmsUS     "`lcolorbmsUS'"
    local lcolorbmsEU     "dkgreen"
    local mcolorbmsEU     "`lcolorbmsEU'"

    * Symbols 
    local msymboldesUS     "plus"
    local msymboldesEU     "none"
    local msymbolbmsUS     "X"
    local msymbolbmsEU     "none"

    * Patterns
    local lpatterndesUS     "longdash"
    local lpatterndesEU     "solid"
    local lpatternbmsUS     "dot"
    local lpatternbmsEU     "shortdash"

    * Width 
    local lwidthdesUS     "medium"
    local lwidthdesEU     "thick"
    local lwidthbmsUS     "`lwidthdesUS'"
    local lwidthbmsEU     "`lwidthdesEU'"

* Twoway options
local graphregiontwoway   "color(white)"
local ylabtwoway          "0(1000)2300"
local ytitletwoway        "Price in US dollars, margin(0 2 0 0)"
local xtitletwoway        """"

* Define option strings

    * Options lists
    local optslist        "lcolor mcolor msymbol lpattern lwidth"
    local twowayoptslist  "graphregion ylab ytitle xtitle"

    * Initialize
    local grouplist "des bms"
    local regionlist "US EU"
    foreach g in `grouplist'  {
    foreach r in `regionlist' { 
        local opts`g'`r' ""
    }
    }
    local twowayopts ""
    
    * BMS and DES strings
    foreach r in `regionlist' {
    foreach g in `grouplist'  {
    foreach o in `optslist'   {
        local opts`g'`r' "`opts`g'`r'' `o'(``o'`g'`r'')"
    }
    }
    }
    
    * US and EU strings
    foreach t in `twowayoptslist'  {
        local twowayopts "`twowayopts' `t'(``t'twoway')"
    }
    
    * Debug
    foreach g in `grouplist'  {
    foreach r in `regionlist' { 
        display "opts`g'`r': `opts`g'`r''"
    }
    }
    display "twowayopts: `twowayopts'"

* Plot with median prices
twoway (connected stat_pBMSmedian t if US == 1 , sort `optsbmsUS')                                                    ///
       (connected stat_pDESmedian t if US == 1 , sort `optsdesUS')                                                   ///
       (connected stat_pBMSmedian t if US == 0 , sort `optsbmsEU')                                                    ///
       (connected stat_pDESmedian t if US == 0 , sort `optsdesEU'),                                                   ///
       `twowayopts'                                                                                                                          ///
       xlabel(1(12)97) xlabel(1 "Jan 04" 13 "Jan 05" 25 "Jan 06" 37 "Jan 07" 49 "Jan 08" 61 "Jan 09" 73 "Jan 10" 85 "Jan 11" 97 "Jan 12" 109 "Jan 13")    ///
       legend( order( 4 "EU DES" 2 "US DES" 3 "EU BMS" 1 "US BMS" )  rows(1))                                                 
graph export $dirresults/E-medianprices.eps, replace logo(off)

* Plot with quantity-weighted mean prices
twoway (connected stat_pBMSwmean t if US == 1 , sort `optsbmsUS')                                                    ///
       (connected stat_pDESwmean t if US == 1 , sort `optsdesUS')                                                   ///
       (connected stat_pBMSwmean t if US == 0 , sort `optsbmsEU')                                                    ///
       (connected stat_pDESwmean t if US == 0 , sort `optsdesEU'),                                                   ///
       `twowayopts'                                                                                                                          ///
       xlabel(1(12)97) xlabel(1 "Jan 04" 13 "Jan 05" 25 "Jan 06" 37 "Jan 07" 49 "Jan 08" 61 "Jan 09" 73 "Jan 10" 85 "Jan 11" 97 "Jan 12" 109 "Jan 13")    ///
       legend( order( 4 "EU DES" 2 "US DES" 3 "EU BMS" 1 "US BMS" )  rows(1))                                                 
graph export $dirresults/E-wmeanprices.eps, replace logo(off)


*** Outsheet for debug
outsheet t US temp_* stat_* if _n <= 1000 using $dirscratch/check.csv, replace delimiter(";")

