function criterion = Demand_aFE1_Cfcn( age, clinical, amc, lnsjs0, lnsjg , p, USe_jt, USe, check, ... 
    pm1 , LnsjgIV, ageIV, dum_g,XeT,aT, num_uniq_thg, num_uniq_th_ght, num_uniq_tj, ...
    h,tj,th,th_ght,thg,frac_zeros_jt,eta_jht,etaQW_jht,Nht,Ht,dum_ght,...
    sigmaQ2_inv_start, Sigma_fix, Sigma_start );

% Computes GMM objective function for learning model in "Regulating Innovation:..."
    % uses sigmaT_1 instead of sigmaQ, so flexible on EU trial learning
    % allows different learning rates for prods in US trials and not

% Inputs are current guess values for trial learning rate (sigmaAc); and observations (sigmaA)
% First, finds (sigmaT_1) consistent with data and current (sigmaAc,sigmaA) guesses
% Then, computes other parameters (Qj,rho) and criterion function for current (sigmaAc,sigmaA) guesses
%aT = 30;
%--------------------------------------------------------------------------
% Current guesses for (sigmaAc,sigmaA,sigmaH)
%--------------------------------------------------------------------------
%Sigma
Sigma = Sigma_fix(:,1);
Sigma(Sigma_fix(:,2)==0,:) = Sigma_start;

thetap = Sigma(1);
Lambda = Sigma(2:size(dum_g,2)+1,:);
sigmaH2 = Sigma(size(dum_g,2)+2:2*size(dum_g,2)+1,:);

%--------------------------------------
% elasticities -- aggregate level
%E_jt = -thetap .* (p_jt-mc_jt) .* ( 1./(1-lambda) - lambda./(1-lambda) .* s_jgt - s_jt);
%E = accumarray([tj,ones(size(tj,1),1)], cp_jht.*Mht.*E_jht , [numel(unique(tj)) 1], @sum) ./ ...
%    accumarray([tj,ones(size(tj,1),1)], cp_jht.*Mht , [numel(unique(tj)) 1], @sum);
%if min(E)<-.95 %bargaining model requires -1<E<0
%    criterion = 1e20 + E(E<-.95)'*E(E<-.95) * 1e20;
%elseif min(E)>0 %bargaining model requires -1<E<0
%    criterion = 1e20 + E(E>0)'*E(E>0) * 1e20;

%parameter constraints 
if min(Sigma)<0 %all params non-negative
    criterion = 1e20 + 1e20*min(Sigma,0)'*min(Sigma,0);
elseif max(Lambda)>.95
    criterion = 1e20 + 1e20*(max(Lambda)-.95)'*(max(Lambda)-.95);
else
        
%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
% Find fixed point (sigmaQ2) consistent with data and other parameters
    %note this is anchor that deals with initial conditions and separately
    %identifying sigma and rho 
    %also key to include moments on sigma(xi|age) in criterion fcn to ID
    %sigmaEU and sigmaA
%--------------------------------------------------------------------------
lambda = dum_g*Lambda;
sigmaH2_jt = dum_g*sigmaH2;
R = sigmaH2_jt./ (2*(1-lambda).^2);
Yin = lnsjs0 - lnsjg.*lambda - (1-lambda).*R + thetap*p;
    %aFE spec
    Y = Yin;
    X = [ ageIV(age<=aT,:) , XeT ];
    theta = (X'*X)\(X'*Y(age<=aT,:)) ;
    age_u = ageIV*theta(1:size(ageIV,2));
    %QjFE = theta(end-size(XeT,2)+1:end);
    %sigmaQ2_inv = [ 1./var(QjFE(USe(check>0)==2)) ; 1./var(QjFE(USe(check>0)==1)) ];
    % residuals
    err = Y(age<=aT,:) - X*theta;
    % instruments
    Z = [ LnsjgIV(age<=aT,:) , -pm1(age<=aT,:) , X ];
    %criterion = (err'*Z)*((Z'*Z)\(Z'*err));
    %X_V = [ ones(size(age_u(age<=aT,:),1),1) , age_u(age<=aT,:) ];
    X_V = [ age_u(age<=aT,:) ];
    err_V = err.^2 - X_V*((X_V'*X_V)\(X_V'*err.^2))  ;
    Z_V=Z;
    
    %no h-specific bc can't disentangle rho and sigma
    sigma2_jt = zeros(size(amc,1),1);
    w_signals_jt = zeros(size(amc,1),1);
    gammaH=0;

%--------------------------------------
% Micro moments for hospital hetero --- means (frac zeros)
dQW_jt = lnsjs0 - lnsjg.*lambda - (1-lambda).*R;
d_jt = dQW_jt - .5*gammaH*(w_signals_jt.*sigma2_jt)./(1-lambda);
sigma_jht = (gammaH.*(w_signals_jt.*sigma2_jt)).^.5;
sigmaH_jt = dum_g*(sigmaH2.^.5);
d_jht = d_jt(tj,:) + sigmaH_jt(tj,:).*etaQW_jht + sigma_jht(tj,:).*eta_jht;
u_jht = exp(d_jht./(1-lambda(tj,:)));
I_ght = accumarray([thg,ones(size(thg,1),1)], u_jht, [num_uniq_thg 1], @sum);
lambda_ght = dum_ght*Lambda;
%Ilam_ght = I_ght.^(-lambda_ght);
%I_ht = accumarray([th_ght,ones(size(th_ght,1),1)], I_ght.*Ilam_ght, [num_uniq_th_ght 1], @sum);
I_ht = accumarray([th_ght,ones(size(th_ght,1),1)], I_ght.^(1-lambda_ght), [num_uniq_th_ght 1], @sum);
cp_jght = u_jht./(I_ght(thg,:));
cp_ght = I_ght(thg,:).^(1-lambda(tj,:)) ./ ( 1 + I_ht(th,:) );
cp_jht = cp_ght .* cp_jght;
%cp_ght_mod = Ilam_ght ./ I_ht(th_ght);
%cp_jht = u_jht .* cp_ght_mod(thg);
%cp0 = 1 ./ ( 1 + I_ht(th,:) );
Pr0jht = (1-cp_jht).^Nht; %Nht should be used somehow as an instrument?
Pr0jt = accumarray([tj,ones(size(tj,1),1)], Pr0jht, [num_uniq_tj 1], @sum) ./ Ht;
err_mm = Pr0jt - frac_zeros_jt;
%Z_mm = [ dum_g(age<=aT,:) , ageIV(age<=aT,:)];
Z_mm=Z;
err_mm = err_mm(age<=aT,:);

%--------------------------------------
% elasticities -- h level
%E_jht = -thetap .* (p_jht-mc_jht) .* ( 1./(1-lambda(tj,:)) - lambda(tj,:)./(1-lambda(tj,:)) .* cp_jght - cp_jht);
%E = accumarray([tj,ones(size(tj,1),1)], cp_jht.*Mht.*E_jht , [numel(unique(tj)) 1], @sum) ./ ...
%    accumarray([tj,ones(size(tj,1),1)], cp_jht.*Mht , [numel(unique(tj)) 1], @sum);
%if min(E)<-.95 %bargaining model requires -1<E<0
%    criterion = 1e20 + E(E<-.95)'*E(E<-.95) * 1e20;
%elseif min(E)>0 %bargaining model requires -1<E<0
%    criterion = 1e20 + E(E>0)'*E(E>0) * 1e20;
%else
    
%--------------------------------------
% micro volatility over time (moments targeted at learning)
% E_ja of V_h(s_jht|s_jht>0)
%Es_gt0_jht = ( (1+cp_jht.*(Nht-1))./Nht ).*gt0;
%VEs_gt0_jt = accumarray([tj,ones(size(tj,1),1)], Es_gt0_jht.^2, [numel(unique(tj)) 1], @sum) ./ Hjt - (accumarray([tj,ones(size(tj,1),1)], Es_gt0_jht, [numel(unique(tj)) 1], @sum) ./ Hjt).^2;
%err_mm_V = VEs_gt0_jt - Vs_jt;
%Z_mm_V = [ ageIV ];

%Dcp =   ( Es_gt0_jht(id_p1,:) - Es_gt0_jht ).*gt0 ;
%VDcp_jt = accumarray([tj,ones(size(tj,1),1)], Dcp.^2, [numel(unique(tj)) 1], @sum) ./ Hjt - (accumarray([tj,ones(size(tj,1),1)], Dcp, [numel(unique(tj)) 1], @sum) ./ Hjt).^2;
%err_mm_VD =  VDcp_jt - VDs_jt ;
%Z_mm_VD = [ ageIV ];

%--------------------------------------
% criterion
%err = err(age<=aT,:);
%Z = Z(age<=aT,:);
%err_V = err_V(age<=aT,:);
%Z_V = Z_V(age<=aT,:);
%err_mm = err_mm(age<=aT,:);
%Z_mm = Z_mm(age<=aT,:);
%err_mm_V = err_mm_V(age<=aT,:) ;
%Z_mm_V = Z_mm_V(age<=aT,:);
%err_mm_VD = err_mm_VD(age<=aT,:) ;
%Z_mm_VD = Z_mm_VD(age<=aT,:);
criterion = (err'*Z)*((Z'*Z)\(Z'*err)) + (err_V'*Z_V)*((Z_V'*Z_V)\(Z_V'*err_V)) + (err_mm'*Z_mm)*((Z_mm'*Z_mm)\(Z_mm'*err_mm)) ;
%moment = (err'*Z)*((Z'*Z)\(Z'*err)) + (err_V'*Z_V)*((Z_V'*Z_V)\(Z_V'*err_V)) ...
%    + (err_mm'*Z_mm)*((Z_mm'*Z_mm)\(Z_mm'*err_mm)) + (err_mm_V'*Z_mm_V)*((Z_mm_V'*Z_mm_V)\(Z_mm_V'*err_mm_V)) ;
%    + (err_mm_VD'*Z_mm_VD)*((Z_mm_VD'*Z_mm_VD)\(Z_mm_VD'*err_mm_VD)) ;

%end
end
end
