#!/bin/bash
#$ -j y
#$ -o logs/$JOB_NAME-$JOB_ID-$TASK_ID.log
#$ -q short.q
#$ -l m_mem_free=1G

# create array of all possible options
tasks=()

# tasks - 3131 jobs
for bs in {0..100}; do
for clin in {1..31}; do
	tasks+=( "$bs 4 7 0 1 1 1 1 $clin" ) #BASE
done
done
# 

# set your variables for THIS task
echo ${tasks[$SGE_TASK_ID-1]} | while read bs mod ptc us dis mc siga2 sigac2 clin; do
    echo "$JOB_NAME bs: $bs mod: $mod paramtochange: $ptc usflag: $us discountflag: $dis mc_rob: $mc siga2: $siga2 sigac2: $sigac2 clin: $clin"

    # pick the job you want based on job name and task
	   echo "step1"
    matlab -nodisplay -r "clear all; cd '~/IntlMedDevMkts/code'; Master_Cfcl_Tc_b_pEq_v3($bs, $mod, $ptc, $us, $dis, $mc, $siga2, $sigac2, $clin); exit"
	
done
