function Master_Cfcl_Tc_b_v3(bootstrap, modifier_id, param_to_change, usflag, discount, mc_robust,siga2, sigmmaac2)
%-------------------------------------------------------------------------
%-------------------------------------------------------------------------
% 1) Load/compute data, assumed parameters, and demand/supply estimates
% 2) UB scenario: Assume firms enter if E[\pi_j(Q_j,J(Tc,0))|I^{EU}_j] > FClaunch^{EU} + 0, as if there is no cost of longer trials, \chi = 0.
    % In data we observe firms that entered if
    % E[\pi_j(Q_j,J(0,0;J^{US}))|I^{EU}_j] > FClaunch^{EU} + 0 if only EU; and
    % additionally E[\pi_j^{US+EUextra}(Q_j,J(Tc^US,\chi Tc^{US}))|I^{EU}_j] >
    % FClaunch^{US} + \chi Tc^{US} if US also.
    % Need to establish new baseline Tc=0 for all (so less info on USj).
    % New price equilibrium and usage calculations required.
    % All same firms enter? Depends on worst Qj in data and FClaunch^{EU}.
    % More firms enter (?) than true EQ, so more choice, lower prices---CS UB sure, but PS?
% 3) LB scenario: Assume firms enter if E[\pi_j(Q_j,J(Tc,0))|I^{EU}_j] > FClaunch^{EU} + \chi Tc, as if \chi=1.6M/mo, but as if other firms treat \chi=0.
    % Only difference in entry from UB is that firms make single agent
    % calculation to not enter as cost \chi Tc rises vs. risk benefit.
    % Benefit if enter comes directly from UB.
    % Once entry determined, new price and usage equilibrium required.
    % Less firms enter than true EQ, so less choice, higher prices---CS LB sure, but PS?

%{
clear all
if exist('~/IntlMedDevMkts/code'):q
    
cd('~/IntlMedDevMkts/code')
else
cd('~/Dropbox/IntlMedDevMkts/code')
end
%}
%addpath('csvwrite_with_headers')

cd('~/IntlMedDevMkts/code')

%{
bootstrap = 0
modifier_id = 4
param_to_change = 7
usflag = 0
discount = 3
mc_robust = 1
siga2 = 1
sigmmaac2 = 1
%}

bs_str = int2str(bootstrap);
modstr = int2str(modifier_id);
paramstr = int2str(param_to_change);
usflagstr = int2str(usflag);
discntstr = int2str(discount);
mcstr = int2str(mc_robust);
sigstr = int2str(siga2);
sigacstr = int2str(sigmmaac2);


modvec_fc = [.1 .2 .5 1 2 5 10];
modvec_other = [.5, .75, .9, 1, 1.1, 1.33, 2];
modvec_sigmaac2 = [.1, .2, .5, .75, .9, 1, 1.1, 1.33, 2, 5, 10];
modifier_fc = modvec_fc(modifier_id);
modifier_other = modvec_other(modifier_id);
modifier_sigmaac2 = modvec_sigmaac2(sigmmaac2);
mcvec = [.5, .25 .75];
mcmod = mcvec(mc_robust);
sigA2modvec = [0, .1, .2, .3, .4, .5, .6, .7, .8, .9, 1];
mod_siga2 = sigA2modvec(siga2);
    
if param_to_change == 1
	mod_fc = modifier_fc;
	mod_sigq = 1;
	mod_rho = 1;
	mod_siginv = 1;
elseif param_to_change == 2
    mod_fc = 1;
	mod_sigq = modifier_other;
	mod_rho = 1;
	mod_siginv = 1;
elseif param_to_change == 3
    mod_fc = 1;
	mod_sigq = 1;
	mod_rho = modifier_other;
	mod_siginv = 1;
elseif param_to_change == 4
    mod_fc = 1;
	mod_sigq = 1;
	mod_rho = 1;
	mod_siginv = modifier_sigmaac2;
else
    mod_fc = 1;
	mod_sigq = 1;
	mod_rho = 1;
	mod_siginv = 1;
end
%%
TrialCost = 16 .* mod_fc; %GK


for clin=1:31
%clin = 13
Tc = clin - 1;
clin

%bootstrap = 0 % 0 for full sample; change for bootstrap samples
QALYs = .05;
DollarsPerQALY = 100000;


%% --------------------------------------------------------------------------
%--------------------------------------------------------------------------
% Import data

%sort tj
%outsheet t j tj age clinical USlater USeventual profit_lifetime pay DES tg zeros Vjt sj p_w Mt p_w_m1 sjg_m1 Jg using EUdata_H_agg.csv, replace
D_agg = importdata('../data/EUdata_agg.csv');
Data_agg = D_agg.data;
%sort tj h
%outsheet t j h tj th Q w_ht s0 sght thg using EUdata_Nht.csv, replace 
D_h = importdata('../data/EUdata_h.csv');
Data_h = D_h.data;

[  t, j, j_true , age, clinical, amc, sj, s0, p, pm1 , ageIV, dum_prod, old_j, USeventual, USe, USe_jt, ...
    sjg , Jg , dum_g , g, tj,th,thg,frac_zeros_jt,Nht,Ht,dum_ght,qm1, ...
    h,th_ght, eta_jht, etaQW_jht, Mht, Mt , p_jht , t_ht  , Mht_ht , t_jht, t_ght, pay, pct_life_profit j_intersect] ...
    = ImportData_fcn( Data_agg , Data_h , bootstrap );

if discount == 1
   disc_firm = (0.99).^(age-1);
   disc_govt = (0.99).^(t-1);
   disc_govt_t = (0.99).^(unique(t)-1);
elseif discount == 2
   disc_firm = 1;
   disc_govt = (0.99).^(t-1);
   disc_govt_t = (0.99).^(unique(t)-1);
elseif discount == 3
   disc_firm = (0.99).^(age-1);
   disc_govt = 1;
   disc_govt_t = 1
else
   disc_firm = 1;
   disc_govt = 1;
   disc_govt_t = 1;
end

%variables for convenience
lnsjs0 = reallog(sj./s0);
lnsjg = reallog(sjg);
Lnsjg = dum_g.*repmat(lnsjg,1,size(dum_g,2));
LnsjgIV = [ dum_g.*repmat(reallog(Jg),1,size(dum_g,2)) , dum_g.*repmat(reallog(Jg).^2,1,size(dum_g,2)) ]  ;
Xe = [ dum_prod ];
X = [ Lnsjg , -p , Xe ];
Z = [ LnsjgIV , -pm1 , Xe ];
%
J = ones(size(age,1),1);
J_j = ones(max(j),1);
%
num_uniq_thg=numel(unique(thg));
num_uniq_th_ght=numel(unique(th_ght));
num_uniq_tj=numel(unique(tj));
num_uniq_t_ht=numel(unique(t_ht));
%
aT=36;
pct_life_profit = grpstats(pct_life_profit,age,'mean');
pct_life_profit = pct_life_profit(1:aT);


%% --------------------------------------------------------------------------
%--------------------------------------------------------------------------
% Parameters from Estimation

% model params to use for subsequent analyses
if bootstrap>0
    Parameters_D = importdata(strcat('../temp/b_Estimation/Parameters_D_',bs_str,'.csv')); 
else
    Parameters_D = importdata(strcat('../temp/Parameters_D_',bs_str,'.csv')); % 0 -> bootstrap ##
end

Parameters_D = Parameters_D(:,3);
Sigma=[Parameters_D(1:8,end);Parameters_D(10,end)];
rho = Parameters_D(9,end)./Sigma(1) .* mod_rho; %GK
sigmaQ = (Parameters_D(end-4:end-3,end)) .* mod_sigq; %GK 
sigmaQ2_inv=1./sigmaQ.^2;
scale = Parameters_D(end-2);
if bootstrap>0
    Parameters_QjFE = importdata(strcat('../temp/b_Estimation/Parameters_QjFE_', bs_str, '.csv')); 
else
    Parameters_QjFE = importdata(strcat('../temp/Parameters_QjFE_', bs_str, '.csv')); % 0 -> bootstrap ##
end

QjFE = Parameters_QjFE(:,3);
thetap=Sigma(1);
Lambda=Sigma(2:3);
lambda=dum_g*Lambda;
lambda_ght=dum_ght*Lambda;
sigmaH2 = Sigma(4:5);
sigmaH2_jt = dum_g*sigmaH2;
sigmaEU2_inv = Sigma(6);
sigmaAc2_inv  = Sigma(7).* mod_siginv; %GK
if siga2  > 1
	sigmaA2_inv  = Sigma(7)*mod_siga2*ones(size(amc,1),1);
else
	sigmaA2_inv  = Sigma(8)*ones(size(amc,1),1);
end


if usflag==1
sigmaA2_inv  = USe_jt*[sigmaAc2_inv;Sigma(8)];
end

gammaH = Sigma(9);
R = sigmaH2_jt./ (2*(1-lambda).^2);
%sigma2_jt = 1./( USe_jt*sigmaQ2_inv + sigmaEU2_inv + amc.*sigmaA2_inv + clinical.*sigmaAc2_inv );
%w_signals_jt = sigma2_jt.*(amc.*sigmaA2_inv + clinical.*sigmaAc2_inv);
sigma2_jt = 1./( USe_jt*(1./(Parameters_D(end-4:end-3,end).^2)) + sigmaEU2_inv + amc.*Sigma(8) + clinical.*Sigma(7) );
w_signals_jt = sigma2_jt.*(amc.*Sigma(8) + clinical.*Sigma(7));
d_jt = lnsjs0 - lnsjg.*lambda - (1-lambda).*R - .5*gammaH*(w_signals_jt.*sigma2_jt)./(1-lambda);
%xi_jt = d_jt + thetap*p + rho*.5*sigma2_jt - dum_prod*QjFE;
xi_jt = d_jt + thetap*p + (Parameters_D(9,end)./Sigma(1))*.5*sigma2_jt - dum_prod*QjFE;

if bootstrap>0
    Parameters_S = importdata(strcat('../temp/b_Estimation/Parameters_S_', bs_str, '.csv')); 
else
    Parameters_S = importdata(strcat('../temp/Parameters_S_',bs_str,'.csv')); % 0 -> bootstrap ##
end
%pB_jt = Parameters_S(:,3);
%mc_jt = Parameters_S(:,4);
%mc_jht = mc_jt(tj);
mc_g = mcmod*grpstats(p, dum_g(:,2), 'min');
mc_jt = dum_g*mc_g;
mc_jht = mc_jt(tj);
%
[d_jht,q_jt,Ep_jt,adjAV_jt,CS_t] ...
    = fcn_Welfare( J,J_j, Sigma , dum_g , lnsjs0 , lnsjg , USe_jt , sigmaQ2_inv , amc , clinical , ...
        tj , etaQW_jht , eta_jht , thg , dum_ght , th_ght , th , Mht , p_jht , mc_jht , t_ht , Mht_ht , Mt , ...
        num_uniq_thg, num_uniq_th_ght, num_uniq_tj, num_uniq_t_ht, ...
        scale );  
%
B_jt = (p-mc_jt) ./ (adjAV_jt + p - mc_jt);
pB_jt=B_jt;
pB_jt(B_jt>.99,:)=.99;
pB_jt(B_jt<.01,:)=.01;



%% --------------------------------------------------------------------------
%--------------------------------------------------------------------------
% Welfare and Counterfactuals

agemax=grpstats(age,j,'max');
agemin=grpstats(age,j,'min');

% Qj1 estimates after EU trials
Qj1 = QjFE + xi_jt(age==agemin(j));
%Qj1 = Qj1 - mean(Qj1-QjFE); %remove bias here

Jall = ones(size(age,1),1);
Jall_j = ones(max(j),1);
j_index = [1:1:max(j)]';
%
if param_to_change == 5
    pre2004_DES = [23,24,52,53,54,55,138,139,151,152];
    pre2004_DES = j_index(ismember(j_intersect, pre2004_DES));
    Jall = Jall - sum(dum_prod(:,pre2004_DES),2);
    Jall_j(pre2004_DES') = 0;
elseif param_to_change == 6
    pre2004_stents = [11,12,18,22,23,24,27,45,52,53,54,55,5,60,61,64,65,66,76,77,80,81,90,91,94,95,96,97,102,128,134,138,139,142,143,149,150,151,152,154,155,167,168];
    pre2004_stents = j_index(ismember(j_intersect, pre2004_stents));
    Jall = Jall - sum(dum_prod(:,pre2004_stents),2);
    Jall_j(pre2004_stents') = 0;
end

% set important parameters
sample=10; %MRG about 10pct of market, so need to blow up aggregate profit and surplus estimates
newMt = mean(Mt)*sample*ones(size(Mt,1),1);
newMht = Mht.*newMt(tj)./Mt(tj);
newMht_ht = Mht_ht.*grpstats(newMht./Mht,th,'mean');

%-------------------------------------------------------------------------
%-------------------------------------------------------------------------
% Compute welfare numbers for counterfactual regulatory parameters:
    % UB adjust entry timing J(Tc) and risk \sigma(Tc) for Tc
    % Compute pricing equilibrium
    % Compute CS and PS for UB
    % LB adjust who enters (using E\pi from UB and Tc\chi)
    % Compute new pricing equilibrium
    % Compute CS and PS for LB
%-------------------------------------------------------------------------

amcC=age-Tc-1;
agemaxC=agemax-Tc;
agemaxC(agemaxC>36)=36;
agemaxC(agemaxC<1)=1;

%-------------------------------------------------------------------------
% Expected profits from (Tc,Jall,Qj1) for entry decisions

% entry delayed by Tc
Jub = Jall;
Jub(age<=Tc) = 0;
Jub(pay(j)==0) = Jall(pay(j)==0); %policy only affects new entrants
Jub_j = Jall_j;
Jub_j(agemax<=Tc) = 0;
Jub_j(pay==0) = Jall_j(pay==0); %policy only affects new entrants
% price Eq -- want delay to matter here
sigma2_jt = 1./( USe_jt*sigmaQ2_inv + sigmaEU2_inv + amcC.*sigmaA2_inv + Tc.*sigmaAc2_inv );
w_signals_jt = sigma2_jt.*(amcC.*sigmaA2_inv + Tc.*sigmaAc2_inv);
% simulate mean beliefs from signals
EQ_jt = dum_prod*Qj1; % E mean beliefs: EQ_jt = sigma2_jt .* ( (USe_jt*sigmaQ2_inv + sigmaEU2_inv).*(dum_prod*Qj1) + amcC.*sigmaA2_inv.*(dum_prod*Qj1) + Tc.*sigmaAc2_inv.*(dum_prod*Qj1) );
Sims=20;
pi = zeros(numel(unique(j)),Sims);
for seed=1:Sims
rng(seed+122,'twister'); %need to simulate path of xi_jt
xi_jt_sim = (sigma2_jt.^.5) .* random('Normal',0,1,size(xi_jt,1),1); % deviations from E mean beliefs
d_jt_nop = EQ_jt - rho*.5*sigma2_jt + xi_jt_sim;
% policy only affects new entrants
sigma2_jt(pay(j)==0) =  1./( USe_jt((pay(j)==0),:)*sigmaQ2_inv + sigmaEU2_inv + amc(pay(j)==0).*sigmaA2_inv(pay(j)==0) + clinical(pay(j)==0).*sigmaAc2_inv ); %policy only affects new entrants
d_jt_nop(pay(j)==0) = dum_prod((pay(j)==0),:)*QjFE - rho*.5*sigma2_jt(pay(j)==0) + xi_jt(pay(j)==0) ; %policy only affects new entrants
w_signals_jt(pay(j)==0) = sigma2_jt(pay(j)==0).*(amc(pay(j)==0).*sigmaA2_inv(pay(j)==0) + clinical(pay(j)==0).*sigmaAc2_inv); %policy only affects new entrants
% here we go...
sigma2_jht = gammaH*(w_signals_jt.*sigma2_jt);
d_jht_nop_fore = d_jt_nop(tj,:) + (sigmaH2_jt(tj,:).^.5).*etaQW_jht + (sigma2_jht(tj,:).^.5).*eta_jht;
% risk
Risk_priors_UB = 1./(sigmaQ2_inv'.^.5);
Risk_mean_UB = mean(sigma2_jt.^.5);
%
p_start=p;
%Pub = fcn_pEq( Jub, t, t_jht, t_ght, tj, thg, th, th_ght, d_jht_nop_ub, thetap, lambda, lambda_ght, newMht, mc_jt, mc_jht, scale, newMt, pB_jt , p_start );
Pub=p_start;
% expected profits
[q_jt,CS_t] = fcn_Welfare2( Jub, tj, thg, th, th_ght, t_ht, d_jht_nop_fore, thetap, lambda, lambda_ght, ...
         num_uniq_thg, num_uniq_th_ght, num_uniq_tj, num_uniq_t_ht, newMht, mc_jht, scale, newMht_ht, newMt, Pub );
Epi_data = accumarray([j,ones(size(j,1),1)], q_jt.*(Pub-mc_jt).*disc_firm, [numel(unique(j)) 1], @sum); %0 for excluded by Tc delay
pi(:,seed) = Epi_data./pct_life_profit(agemaxC);
end
Epi = mean(pi,2);

%-------------------------------------------------------------------------
% LB: Naive single agent enter Jlb if Epi>FC(Tc); 
%   high pricing Plb=p(Jlb,sigma(Jlb,Tc)); 
%   low PSlb=PS(Jlb,Pub,sigma(Jub,Tc)) -- note different price and sigma
%   low CSlb=CS(Jlb,Plb,sigma(Jub,Tc)) -- note different sigma

% entry barrier FC(Tc)
FC = Tc*TrialCost*1e5;
Jlb0 = Jall;
Jlb0(Epi(j)<FC) = 0;
Jlb0(pay(j)==0) = 1; %policy only affects new entrants
Jlb = Jlb0.*Jub;
Jlb0_j = Jall_j;
Jlb0_j(Epi<FC) = 0;
Jlb0_j(pay==0) = 1; %policy only affects new entrants
Jlb_j = Jlb0_j.*Jub_j;
% sigmaQ2 prior changes with J -- don't want delay to affect this, just FC
QjFElb = QjFE(Jlb0_j>0);
%sigmaQ2lb_inv = [ 1./var(QjFElb(USe(Jlb0_j>0)==2)) ; 1./var(QjFElb(USe(Jlb0_j>0)==1)) ];
sigmaQ2lb_inv = sigmaQ2_inv; %if want to hold priors fixed with policy
% price Eq -- want delay, and FC, to matter here: plb=p(Jlb,sigma(Jlb,Tc))
sigma2_jt = 1./( USe_jt*sigmaQ2_inv + sigmaEU2_inv + amcC.*sigmaA2_inv + Tc.*sigmaAc2_inv );
w_signals_jt = sigma2_jt.*(amcC.*sigmaA2_inv + Tc.*sigmaAc2_inv);
% simulate mean beliefs from signals
%EQ_jt = sigma2_jt .* ( (USe_jt*sigmaQ2_inv + sigmaEU2_inv).*(dum_prod*Qj1) + amcC.*sigmaA2_inv.*(dum_prod*QjFE) + Tc.*sigmaAc2_inv.*(dum_prod*QjFE) ); % E mean beliefs
Sims=1;
for seed=1:Sims
rng(seed+122,'twister'); %need to simulate path of xi_jt
xi_jt_sim = (sigma2_jt.^.5) .* random('Normal',0,1,size(xi_jt,1),1); % deviations from E mean beliefs
d_jt_nop = EQ_jt - rho*.5*sigma2_jt + xi_jt_sim;
% policy only affects new entrants
sigma2_jt(pay(j)==0) =  1./( USe_jt((pay(j)==0),:)*sigmaQ2_inv + sigmaEU2_inv + amc(pay(j)==0).*sigmaA2_inv(pay(j)==0) + clinical(pay(j)==0).*sigmaAc2_inv ); %policy only affects new entrants
d_jt_nop(pay(j)==0) = dum_prod((pay(j)==0),:)*QjFE - rho*.5*sigma2_jt(pay(j)==0) + xi_jt(pay(j)==0) ; %policy only affects new entrants
w_signals_jt(pay(j)==0) = sigma2_jt(pay(j)==0).*(amc(pay(j)==0).*sigmaA2_inv(pay(j)==0) + clinical(pay(j)==0).*sigmaAc2_inv); %policy only affects new entrants
% here we go...
sigma2_jht = gammaH*(w_signals_jt.*sigma2_jt);
d_jht_nop_lb = d_jt_nop(tj,:) + (sigmaH2_jt(tj,:).^.5).*etaQW_jht + (sigma2_jht(tj,:).^.5).*eta_jht;
d_jht_nop_ub = d_jht_nop_lb;
% risk
Risk_priors_LB = 1./(sigmaQ2lb_inv'.^.5);
Risk_mean_LB = mean(sigma2_jt.^.5);
%
p_start=Pub;
%Plb = fcn_pEq( Jlb, t, t_jht, t_ght, tj, thg, th, th_ght, d_jht_nop_lb, thetap, lambda, lambda_ght, newMht, mc_jt, mc_jht, scale, newMt, pB_jt , p_start );
Plb=p_start;
%   low PSlb=PS(Jlb,Pub,sigma(Jub,Tc)) -- note different price and sigma
[q_jt,CS_t] = fcn_Welfare2( Jlb, tj, thg, th, th_ght, t_ht, d_jht_nop_ub, thetap, lambda, lambda_ght, ...
         num_uniq_thg, num_uniq_th_ght, num_uniq_tj, num_uniq_t_ht, newMht, mc_jht, scale, newMht_ht, newMt, Pub );
PS_LB_s(:,seed) = sum(q_jt.*(Pub-mc_jt).*disc_govt); %0 for excluded by Tc delay; FC no entry
avgP_LB_s(:,seed) = sum(q_jt.*Pub)./sum(q_jt);
%   low CSlb=CS(Jlb,Plb,sigma(Jub,Tc)) -- note different sigma
[q_jt,CS_t] = fcn_Welfare2( Jlb, tj, thg, th, th_ght, t_ht, d_jht_nop_ub, thetap, lambda, lambda_ght, ...
         num_uniq_thg, num_uniq_th_ght, num_uniq_tj, num_uniq_t_ht, newMht, mc_jht, scale, newMht_ht, newMt, Plb );
CS_LB_s(:,seed) = sum(CS_t.*disc_govt_t);
PctStent_LB_s(:,seed) = sum(q_jt)./sum(grpstats(newMt,t,'mean'));

%-------------------------------------------------------------------------
% UB: all enter Jub=Jall;
%   high PSub=PS(Jub,Plb,sigma(Jlb,Tc)) -- note different price and sigma
%   high CSub=CS(Jub,Pub,sigma(Jlb,Tc)) -- note different sigma

%   high PSub=PS(Jub,Plb,sigma(Jlb,Tc)) -- note different price and sigma
p_start=Plb;
%Plb_p1 = fcn_pEq_p1( Jub, Jlb, t, t_jht, t_ght, tj, thg, th, th_ght, d_jht_nop_lb, thetap, lambda, lambda_ght, newMht, mc_jt, mc_jht, scale, newMt, pB_jt , p_start ); %only replaces Plb for Jlb==0
Plb_p1=p_start;
[q_jt,CS_t] = fcn_Welfare2( Jub, tj, thg, th, th_ght, t_ht, d_jht_nop_lb, thetap, lambda, lambda_ght, ...
         num_uniq_thg, num_uniq_th_ght, num_uniq_tj, num_uniq_t_ht, newMht, mc_jht, scale, newMht_ht, newMt, Plb_p1 );
PS_UB_s(:,seed) = sum(q_jt.*(Plb_p1-mc_jt).*disc_govt); % don't need pmaxC bc TS effect will still be negative of removing?
avgP_UB_s(:,seed) = sum(q_jt.*Plb_p1)./sum(q_jt);
%   high CSub=CS(Jub,Pub,sigma(Jlb,Tc)) -- note different sigma
[q_jt,CS_t] = fcn_Welfare2( Jub, tj, thg, th, th_ght, t_ht, d_jht_nop_lb, thetap, lambda, lambda_ght, ...
         num_uniq_thg, num_uniq_th_ght, num_uniq_tj, num_uniq_t_ht, newMht, mc_jht, scale, newMht_ht, newMt, Pub );
CS_UB_s(:,seed) = sum(CS_t.*disc_govt_t);
PctStent_UB_s(:,seed) = sum(q_jt)./sum(grpstats(newMt,t,'mean'));

%-------------------------------------------------------------------------
% Summarize results into TS

%number of new products introduced
NewProducts_UB_s(:,seed) = sum( pay(Jub_j.*(1-old_j)>0) );
NewProducts_LB_s(:,seed) = sum( pay(Jlb_j.*(1-old_j)>0) );
%Fixed cost expended
%FC_UB_s(:,seed) = NewProducts_UB_s(:,seed) * FC;
%FC_LB_s(:,seed) = NewProducts_LB_s(:,seed) * FC;
disc_govt_jenter = grpstats(disc_govt,j,'max');
FC_UB_s(:,seed) = sum( pay(Jub_j.*(1-old_j)>0) .* FC .* disc_govt_jenter(Jub_j.*(1-old_j)>0) );%.*disc_govt
FC_LB_s(:,seed) = sum( pay(Jlb_j.*(1-old_j)>0) .* FC .* disc_govt_jenter(Jlb_j.*(1-old_j)>0) );%.*disc_govt
%Total surplus
TSa_UB_s(:,seed) = CS_UB_s(:,seed) + PS_UB_s(:,seed) - 0; 
TSa_LB_s(:,seed) = CS_LB_s(:,seed) + PS_LB_s(:,seed) - FC_LB_s(:,seed);
%stents and surplus per stent
TSps_UB_s(:,seed) = TSa_UB_s(:,seed)./PctStent_UB_s(:,seed)./sum(newMt);
TSps_LB_s(:,seed) = TSa_LB_s(:,seed)./PctStent_LB_s(:,seed)./sum(newMt);
end
% gather over Sims
PctStent_UB = mean(PctStent_UB_s,2);
PctStent_LB = mean(PctStent_LB_s,2);
CS_UB = mean(CS_UB_s,2);
CS_LB = mean(CS_LB_s,2);
avgP_UB = mean(avgP_UB_s,2);
avgP_LB = mean(avgP_LB_s,2);
PS_UB = mean(PS_UB_s,2);
PS_LB = mean(PS_LB_s,2);
NewProducts_UB = mean(NewProducts_UB_s,2);
NewProducts_LB = mean(NewProducts_LB_s,2);
FC_UB = mean(FC_UB_s,2);
FC_LB = mean(FC_LB_s,2);
TSa_UB = mean(TSa_UB_s,2);
TSa_LB = mean(TSa_LB_s,2);

%-------------------------------------------------------------------------
% Export results

Cfcl_Tc=[Risk_priors_UB';Risk_priors_LB';Risk_mean_UB;Risk_mean_LB;PctStent_UB;PctStent_LB;CS_UB;CS_LB;avgP_UB;avgP_LB;PS_UB;PS_LB;NewProducts_UB;NewProducts_LB;FC_UB;FC_LB;TSa_UB;TSa_LB];
Cfcl_Tc = [ bootstrap*ones(size(Cfcl_Tc,1),1) , Tc*ones(size(Cfcl_Tc,1),1) , [1:size(Cfcl_Tc,1)]' , Cfcl_Tc ];
filename = strcat('../temp/Cfcl_nop_v3/Cfcl_Tc',int2str(clin),'_param',paramstr,'_mod', modstr,'_b',bs_str,'_dc', discntstr, '_us', usflagstr,'_mc',mcstr,'_siga2',sigstr,'_sigac',sigacstr,'.csv');
csvwrite(filename,Cfcl_Tc)

J_UBLB_Tc = [ bootstrap*ones(size(J_j,1),1) , Tc*ones(size(J_j,1),1) , [1:size(J_j,1)]' , Jub_j , Jlb_j ];
filename = strcat('../temp/Cfcl_nop_v3/J_UBLB_Tc',int2str(clin),'_param',paramstr,'_mod', modstr,'_b',bs_str,'_dc', discntstr, '_us', usflagstr,'_mc',mcstr,'_siga2',sigstr,'_sigac',sigacstr,'.csv');
csvwrite(filename,J_UBLB_Tc)

if Tc==0
Parameters_Epi = [ bootstrap*ones(size(Epi,1),1) , [1:size(Epi,1)]' , Epi ];
mean(Epi)
std(Epi)
min(Epi)
filename = strcat('../temp/Cfcl_nop_v3/Parameters_Epi_',int2str(clin),'_param',paramstr,'_mod', modstr,'_b',bs_str,'_dc', discntstr, '_us', usflagstr,'_mc',mcstr,'_siga2',sigstr,'_sigac',sigacstr,'.csv');
csvwrite(filename,Parameters_Epi)
end

end

end

%
%exit

