* Figures 3 and 4 and 5 --- PV stents versions 

clear
set more off
cd  "~/Dropbox/Research/IntlMedDevMkts/MGanalysis/Balloons"
capture log close
log using Figures_3and4and5_Balloons_LabIDlevel.smcl, replace

********************************************************************
* clean up data
use balloons_labid, clear
gen US=(country=="US")

egen t=group(yyyy mm)
replace manufacturer="Abbott Vascular" if manufacturer=="Guidant"
egen j=group(manufacturer product)

bysort manufacturer product US: egen enter=min(t)
replace enter=. if enter<=3 //stuff already in market plus potential sampling variation

********************************************************************
* table 1
preserve
collapse enter, by(j US lab_id t)
gen ones=1 
bysort t US lab_id: egen Jt=total(ones)
bysort US: su Jt
collapse enter, by(j US lab_id)
gen ones=1 
bysort US lab_id: egen J=total(ones)
bysort US: su J
restore, preserve
collapse enter, by(manufacturer US lab_id t)
gen ones=1 
bysort t US lab_id: egen Mt=total(ones)
bysort US: su Mt
collapse enter, by(manufacturer US lab_id)
gen ones=1 
bysort US lab_id: egen M=total(ones)
bysort US: su M
restore
********************************************************************

gen Mht=diagnostic*2
bysort US lab_id t: egen Qht=total(q)
gen s0=1-Qht/Mht
su s0, detail
drop if s0<=0
gen sj=q/Q
gen lnd=ln(sj/s0)

gen age=t-enter
su age, detail
drop if age==0 | age==. //may undercount qjt if enter in middle of quarter

gen enterUS=enter if US==1
gen enterEU=enter if US==0
su enter enterUS enterEU US
gsort product -enterUS
by product: replace enterUS=enterUS[_n-1] if enterUS==.
gsort product -enterEU
by product: replace enterEU=enterEU[_n-1] if enterEU==.
* variable that denotes who enters US
gen USeventual = 0
replace USeventual = 1 if enterUS~=.

********************************************************************
* basics with raw data---EU and US

keep if age<=24
replace USeventual=1 if US==1

* and first differences within product
sort US lab_id product t
by US lab_id product: gen lnd_diff = abs(lnd-lnd[_n+1])
drop if lnd_diff==. // average over products of same age

quietly tab age, gen(aFE)
su age
local A `r(max)'
forvalues i = 1/`A' { 
	gen aEU_FE`i'=aFE`i'*(1-US) 
	}
forvalues i = 1/`A' { 
	gen aEUtrials_FE`i'=aFE`i'*(1-US)*USeventual 
	}	
********************************************************************
* raw data plots

bysort age US: egen d_mean = mean(lnd)
bysort age US: egen d_sd = sd(lnd)
bysort age US: egen d_diff_mean = mean(lnd_diff)

su lnd, detail
local lnd_u=ceil(`r(p75)')
local lnd_l=floor(`r(p25)')
su d_sd, detail
local sd_u=ceil(`r(p75)')
su lnd_diff, detail
local diff_u=ceil(`r(p25)')

* EU vs US, all products, raw

twoway (scatter d_mean age if US==0, mcolor(bluishgray8) msymbol("o")) ///
	(fpfitci lnd age if US==0, lcolor(navy) lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blwidth(thin)) ///
 	(scatter d_mean age if US==1, mcolor(erose) msymbol("o")) ///
	(fpfitci lnd age if US==1, lcolor(maroon) lpattern("-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(cranberry) blpattern("-") blwidth(thin)) ///
 	, legend( order( 3 "EU" 6 "US" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share") ylabel(`lnd_l'(.5)`lnd_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/Research/IntlMedDevMkts/Paper/fig_MeanVsAge_EU_US_Balloons_labid.eps, replace 

twoway (scatter d_sd age if US==0, mcolor(bluishgray8) msymbol("o")) ///
	(fpfitci d_sd age if US==0, lcolor(navy) lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blwidth(thin)) ///
 	(scatter d_sd age if US==1, mcolor(erose) msymbol("o")) ///
	(fpfitci d_sd age if US==1, lcolor(maroon) lpattern("-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(cranberry) blpattern("-") blwidth(thin)) ///
 	, legend( order( 3 "EU" 6 "US" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share: StDev Across Products") ylabel(0(.2)`sd_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/Research/IntlMedDevMkts/Paper/fig_StDevVsAge_EU_US_Balloons_labid.eps, replace 

twoway (scatter d_diff_mean age if US==0, mcolor(bluishgray8) msymbol("o")) ///
	(fpfitci lnd_diff age if US==0, lcolor(navy) lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blwidth(thin)) ///
 	(scatter d_diff_mean age if US==1, mcolor(erose) msymbol("o")) ///
	(fpfitci lnd_diff age if US==1, lcolor(maroon) lpattern("-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(cranberry) blpattern("-") blwidth(thin)) ///
 	, legend( order( 3 "EU" 6 "US" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share Change Between Months") ylabel(0(.2)`diff_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/Research/IntlMedDevMkts/Paper/fig_MeanFirstDiffVsAge_EU_US_Balloons_labid.eps, replace 
/*
* regressions for table below
*mean
reg lnd aFE1-aFE23 if US==0, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd aFE1-aFE23 if US==1, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd aFE1-aFE23 aEU_FE1-aEU_FE23, noconstant cluster(t)
lincom aEU_FE23-aEU_FE1
*sd
reg d_sd aFE1-aFE23 if US==0, noconstant cluster(t)
lincom aFE23-aFE1
reg d_sd aFE1-aFE23 if US==1, noconstant cluster(t)
lincom aFE23-aFE1
reg d_sd aFE1-aFE23 aEU_FE1-aEU_FE23, noconstant cluster(t)
lincom aEU_FE23-aEU_FE1
*diff
reg lnd_diff aFE1-aFE23 if US==0, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_diff aFE1-aFE23 if US==1, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_diff aFE1-aFE23 aEU_FE1-aEU_FE23, noconstant cluster(t)
lincom aEU_FE23-aEU_FE1
*/

********************************************************************
* use within-product variation
bysort US USeventual: egen group_m = mean(lnd)
bysort US prod: egen lnd_m = mean(lnd)
gen lnd_within = lnd-lnd_m+group_m

bysort age US USeventual: egen d_within_mean = mean(lnd_within)
bysort age US USeventual: egen d_within_sd = sd(lnd_within)
bysort age US USeventual: egen d_diff_within_mean = mean(lnd_diff)

* EU vs US, same products, within

twoway (scatter d_within_mean age if US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci lnd_within age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_within_mean age if US==1, mcolor(erose) msymbol("o")) ///
	(fpfitci lnd_within age if US==1, lcolor(maroon) lpattern("-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(cranberry) blpattern("-") blwidth(thin)) ///
 	, legend( order( 3 "EU (enter US)" 6 "US" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share (Within)") ylabel(`lnd_l'(.5)`lnd_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/Research/IntlMedDevMkts/Paper/fig_MeanVsAge_EU_US_within_Balloons_labid.eps, replace 

twoway (scatter d_within_sd age if US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci d_within_sd age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_within_sd age if US==1, mcolor(erose) msymbol("o")) ///
	(fpfitci d_within_sd age if US==1, lcolor(maroon) lpattern("-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(cranberry) blpattern("-") blwidth(thin)) ///
 	, legend( order( 3 "EU (enter US)" 6 "US" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share: StDev Across Products (Within)") ylabel(0(.2)`sd_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/Research/IntlMedDevMkts/Paper/fig_StDevVsAge_EU_US_within_Balloons_labid.eps, replace 

twoway (scatter d_diff_within_mean age if US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci lnd_diff age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_diff_within_mean age if US==1, mcolor(erose) msymbol("o")) ///
	(fpfitci lnd_diff age if US==1, lcolor(maroon) lpattern("-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(cranberry) blpattern("-") blwidth(thin)) ///
 	, legend( order( 3 "EU (enter US)" 6 "US" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share Change Between Months (Within)") ylabel(0(.2)`diff_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/Research/IntlMedDevMkts/Paper/fig_MeanFirstDiffVsAge_EU_US_within_Balloons_labid.eps, replace 
/*
* regressions for table below
*mean
reg lnd_within aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_within aFE1-aFE23 if US==1, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_within aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if USeventual==1, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
*sd
reg d_within_sd aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg d_within_sd aFE1-aFE23 if US==1, noconstant cluster(t)
lincom aFE23-aFE1
reg d_within_sd aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if USeventual==1, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
*diff
reg lnd_diff aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_diff aFE1-aFE23 if US==1, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_diff aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if USeventual==1, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
*/
* EU: Trials vs Not, within

twoway (scatter d_within_mean age if US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci lnd_within age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_within_mean age if US==0 & USeventual==0, mcolor(bluishgray8) msymbol("th")) ///
	(fpfitci lnd_within age if US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern(".....-") blwidth(thin)) ///
 	, legend( order( 3 "EU (enter US)" 6 "EU (don't enter US)" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share (Within)") ylabel(`lnd_l'(.5)`lnd_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/Research/IntlMedDevMkts/Paper/fig_MeanVsAge_EUtrials_EUnot_within_Balloons_labid.eps, replace 

twoway (scatter d_within_sd age if US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci d_within_sd age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_within_sd age if US==0 & USeventual==0, mcolor(bluishgray8) msymbol("th")) ///
	(fpfitci d_within_sd age if US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern(".....-") blwidth(thin)) ///
 	, legend( order( 3 "EU (enter US)" 6 "EU (don't enter US)" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share: StDev Across Products (Within)") ylabel(0(.2)`sd_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/Research/IntlMedDevMkts/Paper/fig_StDevVsAge_EUtrials_EUnot_within_Balloons_labid.eps, replace 

twoway (scatter d_diff_within_mean age if US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci lnd_diff age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_diff_within_mean age if US==0 & USeventual==0, mcolor(bluishgray8) msymbol("th")) ///
	(fpfitci lnd_diff age if US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern(".....-") blwidth(thin)) ///
 	, legend( order( 3 "EU (enter US)" 6 "EU (don't enter US)" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share Change Between Months (Within)") ylabel(0(.2)`diff_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/Research/IntlMedDevMkts/Paper/fig_MeanFirstDiffVsAge_EUtrials_EUnot_within_Balloons_labid.eps, replace
/*
* regressions for table below
*mean
reg lnd_within aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_within aFE1-aFE23 if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_within aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if US==0, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
*sd
reg d_within_sd aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg d_within_sd aFE1-aFE23 if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE23-aFE1
reg d_within_sd aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if US==0, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
*diff
reg lnd_diff aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_diff aFE1-aFE23 if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_diff aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if US==0, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
*/

********************************************************************
********************************************************************
* robustness to sample with similar initial quality estimates
/*
preserve
keep if US==0
gen temp1=0
replace temp1=lnd if age==1
bysort product: egen lnd1EU=total(temp1)
drop if lnd1EU==0
drop temp1
bysort USeventual: su lnd if age==1, detail
keep if lnd1EU>-8.92 & lnd1EU<-6.16 //minUS and maxEU
*keep if lnd1EU>-6.83 //p10US
*keep if lnd1EU<-6.56 //p90EU
bysort USeventual: su lnd if age==1, detail

* recompute sample stats
drop d_mean d_sd d_diff_mean group_m lnd_m lnd_within d_within_mean d_within_sd d_diff_within_mean
bysort age USeventual: egen d_mean = mean(lnd)
bysort age USeventual: egen d_sd = sd(lnd)
bysort age USeventual: egen d_diff_mean = mean(lnd_diff)

bysort USeventual: egen group_m = mean(lnd)
bysort prod: egen lnd_m = mean(lnd)
gen lnd_within = lnd-lnd_m+group_m

bysort age USeventual: egen d_within_mean = mean(lnd_within)
bysort age USeventual: egen d_within_sd = sd(lnd_within)
bysort age USeventual: egen d_diff_within_mean = mean(lnd_diff)

* EU: Trials vs Not, within --- overlapping sample only

twoway (scatter d_within_mean age if US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci lnd_within age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_within_mean age if US==0 & USeventual==0, mcolor(bluishgray8) msymbol("th")) ///
	(fpfitci lnd_within age if US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern(".....-") blwidth(thin)) ///
 	, legend( order( 3 "EU (in trials)" 6 "EU (not in trials)" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share (Within)") ylabel(-8(.5)-3) ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/Research/IntlMedDevMkts/Paper/fig_MeanVsAge_EUtrials_EUnot_within_Robustness_Overlapping.eps, replace 

twoway (scatter d_within_sd age if US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci d_within_sd age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_within_sd age if US==0 & USeventual==0, mcolor(bluishgray8) msymbol("th")) ///
	(fpfitci d_within_sd age if US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern(".....-") blwidth(thin)) ///
 	, legend( order( 3 "EU (in trials)" 6 "EU (not in trials)" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share: StDev Across Products (Within)") ylabel(0(.2)1.2) ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/Research/IntlMedDevMkts/Paper/fig_StDevVsAge_EUtrials_EUnot_within_Robustness_Overlapping.eps, replace 

twoway (scatter d_diff_within_mean age if US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci lnd_diff age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_diff_within_mean age if US==0 & USeventual==0, mcolor(bluishgray8) msymbol("th")) ///
	(fpfitci lnd_diff age if US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern(".....-") blwidth(thin)) ///
 	, legend( order( 3 "EU (in trials)" 6 "EU (not in trials)" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share Change Between Months (Within)") ylabel(0(.2).8) ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/Research/IntlMedDevMkts/Paper/fig_MeanFirstDiffVsAge_EUtrials_EUnot_within_Robustness_Overlapping.eps, replace

* regressions for table below
*mean
reg lnd_within aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_within aFE1-aFE23 if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_within aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if US==0, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
*sd
reg d_within_sd aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg d_within_sd aFE1-aFE23 if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE23-aFE1
reg d_within_sd aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if US==0, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
*diff
reg lnd_diff aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_diff aFE1-aFE23 if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_diff aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if US==0, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1

restore
********************************************************************

log close
