###################################################################
# Name              : CobbDouglas_OLS.R
# 
# Description       : This program estimates Cobb Douglas production 
#                     functions for cognitive and socio-emotional 
#                     skills (full specification)
###################################################################

Xnames                   <- c( "kids")
nS = 2                                           # Number of skills 

###################################################################
# Define function to estimate production function by OLS
# This function produces "naive" estimates not correcting for the 
# fact that we're using factor scores as well as adjusted 
# estimates correcting for that fact 
###################################################################
pf.ols.estim.func             <- function(scores, data, eps, mean, cov, prob, missing){
  
  # Load data
  setwd(dir_data)     
  measures <- read.csv(data, header=T)
  measures <- measures[order(measures$treat), ]
  n        <- nrow(measures)
  
  # Get estimates of measurement system Ineed for estimation of correction bias 
  totmean    <- matrix(0, nFI, nG)
  for (g in 1:nG)  totmean[,g] <- prob[[g]] %*% mean[[g]]

  # Define observables 
  Zall         <- cbind(measures$meanprice_juglibros_log_st, measures$FUmeanprice_log_st, measures$tpobc_pop1993_st)
  X1           <- cbind(measures$ln_nkids0_st) 
  Xnames       <- c( "kids")

  
  mscoresall   <- rbind(scores[[1]], scores[[2]])
  keep         <- which(complete.cases(cbind(Zall,X1, mscoresall)))
  keep1        <- which(complete.cases(cbind(Zall,X1, mscoresall)[which(measures$treat==1),]))
  keep2        <- which(complete.cases(cbind(Zall,X1, mscoresall)[which(measures$treat==2),]))
  treatnomiss  <- measures$treat[keep]
  
  if (missing=="FALSE"){
    fs   <- list()
    fs[[1]] <- scores[[1]][keep1,]
    fs[[2]] <- scores[[2]][keep2,]
  } else if (missing=="TRUE"){
    fs   <- scores
  }
  
  pos           <- c(2,4,5,6,7,8)

  X           <- X1[keep,]
  
  RHSnames    <- c("treat", "cog0", "ncog0",  "mat", "time", "cogmo", "ncogmo", Xnames)
  
  pf.ols   <-  pf.ols.func(fs, X, Xnames, treatnomiss, RHSnames, pos, totmean, mean, cov, prob, parametric=1)

  return(pf.ols)
} 

###################################################################
# Estimate production function on true data and bootstrapped samples 
# using function above 
###################################################################
for (boot in 0:Bootstrap){

    ## Estimate on true data 
  if (boot==0){  
   
       # Load input needed for function 
      setwd(dir_outputFM)
      load("trueFM.R")                # Estimates of the meausurement system 
      load("fs_true.R")               # Factor scores 
    
      # Estimate first stage and reduced forms 
      out_true           <- pf.ols.estim.func(list(fs_true[[5]],fs_true[[6]]), "measures.csv",  eps, mean.mix, cov.mix, prob.mix, missing="FALSE")
      
      # Rename output 
      pf_true       <- out_true[[1]]
      pfbias_true   <- out_true[[2]]
  } 

  ## Estimate on bootstrapped data
  if (boot==1 ){ 
    
      nof <- length(noflagFS)
 
      setwd(dir_outputFM)           
      load("fs_bstrap.R")              # Factor scores on the boostrapped samples 
      
      # Define output 
      pf_bstrap <- array(0, dim=c(nrow(pf_true), ncol(pf_true), nof))
      pfbias_bstrap <- array(0, dim=c(nrow(pfbias_true), ncol(pfbias_true), nof))
    
      # Estimate function on each bstrap sample
      for (b in 1:nof){
        # Estimate first stage and reduced forms 
          out_bstrap   <- pf.ols.estim.func(fs_bstrap_allBFGS[[noflagFS[b]]], paste("measures_b", noflagFS[b], ".csv", sep=""), 
                                      epsBoot[,noflag[b]],
                                      list(meanBoot[,,noflagFS[b],1], meanBoot[,,noflagFS[b],2]), 
                                      list(covBoot[,,noflagFS[b],1],covBoot[,,noflagFS[b],2]), 
                                      list(probBoot[,noflagFS[b],1], probBoot[,noflagFS[b],2]), 
                                      missing="FALSE")
          
          print(b)
          pf_bstrap[,,b]        <- out_bstrap[[1]]
          pfbias_bstrap[,,b]    <- out_bstrap[[2]]
      } 

  } 

} 

##############################################################################
# Create table of estimates (point estimate followed by bootstrapped 
# standard errors, 95% ci, p-value one tail test and p-value two tailed test)
############################################################################## 

outtrue     <- list(pf_true, pfbias_true)  
outb        <- list(pf_bstrap, pfbias_bstrap) 

outtable        <- list()
for (s in 1:2) {
  npar                 <- nrow(outtrue[[s]])
  outtable[[s]]        <- matrix(0, npar*5, nS)
  
  for (i in 1:npar){
    for (j in 1:nS){
      
      mean             <- mean(outb[[s]][i,j,])
      se               <- sd(outb[[s]][i,j,])
      t_stat           <- mean/se
      t_crit           <- (outb[[s]][i,j,] - mean)/se
      p_val            <- 1 - ecdf(t_crit)(t_stat)
      p_val2           <- 1 - ecdf(t_crit^2)(t_stat^2)
      
      outtable[[s]][(i*5-4), j]  <- round(mean,3)
      outtable[[s]][(i*5-3),j]   <- round(se,3) 
      outtable[[s]][(i*5-2), j]  <- paste("[", round(quantile(outb[[s]][i,j,], .025),3), ",", 
                                          round(quantile(outb[[s]][i,j,], .975),3), "]", sep="") 
      outtable[[s]][(i*5-1), j]  <- p_val 
      outtable[[s]][i*5, j]      <- p_val2 
    } 
  } 
} 


# Name output rows and columns 
pfnames   <- c("Intercept", "", "", "", "",
               "Treatment", "", "", "", "",
               "Log child's cognitive skill (t)","", "", "", "",
               "Log child's socio-emotional skill (t)", "", "", "", "",
               "Log material investment (t+1)", "", "","", "",
               "Log time investment (t+1)", "", "","", "",
               "Log mother's cognitive skill (t)", "", "", "", "",
               "Log mother's socio-emotional skill (t)", "", "", "","", 
               "Log number of children (t)", "", "","",""
               ) 

for (s in 1:2){
  rownames(outtable[[s]]) <- pfnames  
  colnames(outtable[[s]]) <- c("Cognitive skills", "Socio-emotional skills")
}


# Save output 
setwd(dir_outputPF)
save(pf_true, pfbias_true, pf_bstrap, pfbias_bstrap, outtrue, outb, outtable, file=paste("OUTPUT_OLS_pval", ".R", sep=""))
write.csv(cbind(outtable[[1]]), file=paste("PF_OLS_pval",  ".csv", sep=""))
write.csv(cbind(outtable[[2]]), file=paste("PFIAS_OLS_pval",  ".csv", sep=""))


