md.fullyinteract.1inv.flexfunc            <- function(invest, rdf, cogrdf_var, ncogrdf_var, start, posExoFS, posInvFS , posExoRF, posInvRF ,weighting){

  # Organize output to make it easier for next steps 
    matinv           <- invest[,1]
    timeinv          <- invest[,2]
    cogrdf           <- rdf[,1]
    ncogrdf          <- rdf[,2]
    
    Einvmat_int     <- matinv[1]
    Einvmat_T       <- matinv[2]
    Einvmat_exo     <- matinv[posExoFS[c(-1,-2)]]
    Einvmat_ins     <- matinv[posInvFS]
    
    Einvtime_int    <- timeinv[1]
    Einvtime_T      <- timeinv[2]
    Einvtime_exo    <- timeinv[posExoFS[c(-1,-2)]]
    Einvtime_ins    <- timeinv[posInvFS]  

  Ecogrdf_int      <- cogrdf[1]
  Ecogrdf_T        <- cogrdf[2]
  Ecogrdf_exo      <- cogrdf[c(3,5,7,9,11)]
  Ecogrdf_exo_T    <- cogrdf[c(4,6,8,10,12)]
  Ecogrdf_ins      <- cogrdf[c(13,15)]
  Ecogrdf_ins_T    <- cogrdf[c(14,16)]
  
  Encogrdf_int      <- ncogrdf[1]
  Encogrdf_T        <- ncogrdf[2]
  Encogrdf_exo      <- ncogrdf[c(3,5,7,9,11)]
  Encogrdf_exo_T    <- ncogrdf[c(4,6,8,10,12)]
  Encogrdf_ins      <- ncogrdf[c(13,15)]
  Encogrdf_ins_T    <- ncogrdf[c(14,16)]
  
  # Define moments 
  mindist.cog.func    <- function(outparam){ 

   
    Epf_int         <- outparam[1]
    Epf_T           <- outparam[2]
    Epf_exo         <- outparam[c(3,5,7,9,11)]
    Epf_exo_T       <- outparam[c(4,6,8,10,12)]
    Epf_mat         <- outparam[13]
    Epf_mat_T       <- outparam[14]
    
    intm            <- Ecogrdf_int - (Epf_int + Epf_mat  * Einvmat_int )
    
    Tm              <- Ecogrdf_T - (Epf_T + Epf_mat_T* Einvmat_int  + 
                                      (Epf_mat + Epf_mat_T)*Einvmat_T )
   
    exom            <- Ecogrdf_exo - (Epf_exo + Epf_mat * Einvmat_exo ) 
    
    exoTm           <- Ecogrdf_exo_T - (Epf_exo_T + Epf_mat_T * Einvmat_exo ) 
    
    endom           <- Ecogrdf_ins - (Epf_mat * Einvmat_ins)
    
    endoTm          <- Ecogrdf_ins_T - (Epf_mat_T * Einvmat_ins )

  
    allm            <- matrix(c(intm, Tm, exom, exoTm, endom, endoTm), 1, length(c(intm, Tm, exom, exoTm, endom, endoTm)))
    
    if (weighting==TRUE){
      #objfunc         <- as.numeric(allm %*% solve(nearPD(cogrdf_var)$mat) %*% t(allm))
    objfunc         <- as.numeric(allm %*% solve(make.positive.definite(cogrdf_var)) %*% t(allm))
    } 
    if (weighting==FALSE){
    objfunc         <- as.numeric(allm %*% t(allm))
    } 
    
    return(objfunc)  
  }
  
  cogpf            <- optim(start[,1], mindist.cog.func,  control=list(maxit=10000))

  
  
  
  ### Non-cognitive skill 
  mindist.ncog.func    <- function(outparam){ 
    
    Epf_int         <- outparam[1]
    Epf_T           <- outparam[2]
    Epf_exo         <- outparam[c(3,5,7,9,11)]
    Epf_exo_T       <- outparam[c(4,6,8,10,12)]
    Epf_time         <- outparam[13]
    Epf_time_T       <- outparam[14]
    
    intm            <- Encogrdf_int - (Epf_int  + Epf_time * Einvtime_int)
    
    Tm              <- Encogrdf_T - (Epf_T + Epf_time_T* Einvtime_int + 
                                       (Epf_time + Epf_time_T)*Einvtime_T)
    
    exom            <- Encogrdf_exo - (Epf_exo +  Epf_time * Einvtime_exo ) 
    exoTm           <- Encogrdf_exo_T - (Epf_exo_T +  Epf_time_T * Einvtime_exo ) 
    
    endom           <- Encogrdf_ins - ( Epf_time * Einvtime_ins)
    endoTm          <- Encogrdf_ins_T - ( Epf_time_T * Einvtime_ins)
    
    allm            <- matrix(c(intm, Tm, exom, exoTm, endom, endoTm), 1, length(c(intm, Tm, exom, exoTm, endom, endoTm)))
    
    if (weighting==TRUE){
      #objfunc         <- as.numeric(allm %*% solve(nearPD(ncogrdf_var)$mat) %*% t(allm))
      objfunc         <- as.numeric(allm %*% solve(make.positive.definite(ncogrdf_var)) %*% t(allm))
    } 
    if (weighting==FALSE){
      objfunc         <- as.numeric(allm %*% t(allm))
    } 
    
    return(objfunc)  
  }
   
   ncogpf           <- optim(start[,2], mindist.ncog.func ,  control=list(maxit=10000))
   
   pf <- cbind(cogpf$par, ncogpf$par)
  
  return(pf)
} 
