first.stage.func.MC                        <- function(fs, X, Xnames,Z, Znames,  treatnomiss, RHSnames , pos, totalmean, mean, cov, prob, parametric){
  

 Xall <- Z 
  
  
  fmla_mat    <- as.formula(paste("mat ~ ", paste(RHSnames, collapse= "+")))
  fmla_time   <- as.formula(paste("time ~ ", paste(RHSnames, collapse= "+")))

  
  
  # Compute correction matrix 

    A             <- bartlett.correction.mixt.func(list(fs[[1]][,pos], fs[[2]][,pos]), Xall, treatnomiss, nG=2, nF, nFpos=ncol(fs[[1]][,pos]), nX=ncol(Xall), pos, totalmean, mean, cov, prob, parametric)
    regdata       <- data.frame(cbind(rbind(fs[[1]],fs[[2]]), Xall, treatnomiss))




  colnames(regdata) <- c("cog1", "cog0", "mat", "time", "cogmo",  Znames, "treat")
  data_Xnoint       <- regdata[,c(-1, -3, -4, -ncol(regdata))]

  # Estimate investment function and correct coefficients
  mat            <- lm(fmla_mat, data=as.data.frame(regdata))
  mat_bias       <- as.matrix(mat$coefficients)
  matslo         <- solve(A) %*% as.vector(mat$coefficients)[c(-1, -2)]
  matint0        <- mean(regdata[which(treatnomiss==1),]$mat) - colMeans(data_Xnoint[which(treatnomiss==1),]) %*% matslo
  matint01       <- mean(regdata[which(treatnomiss==2),]$mat) - colMeans(data_Xnoint[which(treatnomiss==2),]) %*% matslo
  matint1        <- matint01 - matint0
  mat_correct    <- rbind(matint0, matint1, matslo)
  
  time            <- lm(fmla_time, data=as.data.frame(regdata))
  time_bias       <- as.matrix(time$coefficients)
  timeslo         <- solve(A) %*% as.vector(time$coefficients)[c(-1, -2)]
  timeint0        <- mean(regdata[which(treatnomiss==1),]$time) - colMeans(data_Xnoint[which(treatnomiss==1),]) %*% timeslo
  timeint01       <- mean(regdata[which(treatnomiss==2),]$time) - colMeans(data_Xnoint[which(treatnomiss==2),]) %*% timeslo
  timeint1        <- timeint01 - timeint0
  time_correct    <- rbind(timeint0, timeint1, timeslo)
  
  
  # Put estimates together
  est_correct     <- cbind(mat_correct, time_correct)
  est_bias        <- cbind(mat_bias, time_bias)
  rownames(est_correct) <- c("Intercept", "Treat", "cog0","cogmo", Znames)
  rownames(est_bias)    <- rownames(est_correct)
  
  # Compute residuals for Cragg Donals test
  n                 <- length( regdata$mat)
  cf_mat            <- as.matrix(regdata$mat, n, 1)  - matrix(1,n, 1) %*% matint0    -  treatnomiss %*% matint1 - as.matrix(data_Xnoint) %*% as.matrix(matslo)
  cf_time           <- as.matrix(regdata$time, n, 1)  - matrix(1,n, 1) %*% timeint0  -  treatnomiss %*% timeint1 - as.matrix(data_Xnoint) %*% as.matrix(timeslo)
  cf                <- cbind(cf_mat, cf_time)
  predict_mat       <- matrix(1,n, 1) %*% matint0    +  treatnomiss %*% matint1 + as.matrix(data_Xnoint) %*% as.matrix(matslo)
  predict_time      <- matrix(1,n, 1) %*% timeint0  + treatnomiss %*% timeint1 + as.matrix(data_Xnoint) %*% as.matrix(timeslo)
  predict_invest    <- cbind(predict_mat, predict_time)

 

   return(list(est_correct , est_bias, cf, predict_invest))
 }

