###################################################################
# Name              : SignalToNoiseRatio.R
# Description       : This program computes the signal to noise ratio
#                     for all the measures 
###################################################################
set.seed(08072018)  

# Load estimates from the true data 
setwd(dir_outputFM)
load("trueFM.R")

# Set seed to generate a sample of latent factors 
data          <- draw.factor.noins(mean.mix, cov.mix, prob.mix)
alldata       <- data[[1]]
attach(alldata)

# Compute signal to noise ratio 
percent_signal <- sig2noise.func(alldata)

# Save output 
setwd(dir_outputFM)
write.csv(percent_signal, file="sig2noise.csv") 