###################################################################
# Name              : EstimateMeasurementSystem.R
#
# Description       : This program produces graphs of the marginal
#                    product of investments using estimates of the PF
###################################################################


#########################################################
# Settings for the graphs 
#########################################################

# Settings for the graphs 
treat             <- 0 
ngrid             <- 40 

# Colors for the graph 
# Create a function interpolating colors in the range of specified colors 
jet.colors <- colorRampPalette(c("yellow", "red"))

# Generate the desired number of colors from this palette
nbcol     <- 100 
color     <- jet.colors(nbcol) 


#########################################################
# Generate the data and estimate the production function 
#########################################################
# Load data 
setwd(dir_outputFM)
load("trueFM.R")

data          <- draw.factor.noins(mean.mix, cov.mix, prob.mix)
alldata       <- data[[1]]
alllndata       <- data[[2]]
attach(alldata)
attach(alllndata)
save(alldata, file="alldata.R")
n             <- nrow(alldata)



addontitle    <- c("(Production function for cognitive skills)", "(Production function for socio-emotional skills)")

standskill    <- cbind(alldata$cog1, alldata$ncog1)
sdskill    <- apply(standskill, 2, sd)


# Grid of values of endowments to be used as inputs in the functions 
x1r      <- range(alldata$cog0)
x1seq    <- seq(x1r[1], x1r[2], length=ngrid)
x2r      <- range(alldata$ncog0)
x2seq    <- seq(x2r[1], x2r[2], length=ngrid)



#######################################################################################################################################
# GRAPH 1: Marginal product of material investment as a function of endowments in production function for cog skills
####################################################################################################################################### 

# Pick specification form where we're getting the results 
nameFirstStage <- c("FirstStage_toyprice_foodprice")
dir_outputPF      <- paste(dir,c("output/"), nameFM,  "/",  nameFirstStage, sep="")
setwd(dir_outputPF)
load("OUTPUT_IV_notreatment_parsinv_pval.R")

setwd(dir_outputFM)

mean.cog0    <- mean(alldata$cog0)
mean.ncog0   <- mean(alldata$ncog0)
mean.cogmo   <- mean(alldata$cogmo)
mean.ncogmo  <- mean(alldata$ncogmo)
mean.mat     <- mean(alldata$mat)
mean.time    <- mean(alldata$time)
mean.nkids   <- mean(exp(measures$ln_nkids0), na.rm=TRUE)

mp.1inv.func  <- function(x,skill){
  
  if (skill=="cog"){
    type <- alldata$cog1
    s=1
  }
  if (skill=="ncog"){
    type <- alldata$ncog1
    s=2
  }
  
  tfp           <- pf_true[1,s]
  scog0         <- pf_true[2,s]
  sncog0        <- pf_true[3,s]
  scogmo        <- pf_true[4,s]
  sncogmo       <- pf_true[5,s]
  snkids        <- pf_true[6,s]
  smat          <- pf_true[7,s]
 
  output.func <- function(x){
    out <- exp(tfp + scog0 * log(x) + sncog0 * log(mean.ncog0) + scogmo * log(mean.cogmo)  + sncogmo * log(mean.ncogmo) +  snkids * log(mean.nkids) + smat * log(mean.mat))
  }
  
    mpout <- smat   * (output.func(x)/sd(type)) * sd(alldata$mat) / mean.mat

  return(mpout)
}
 
setwd(dir_outputFM)
pdf("MPcogmatcog.pdf")
old.par <- par( no.readonly = TRUE )
par( oma = c( 0, 0, 2, 0 ) )
nf    <- layout(matrix(c(1,2), 1, 2, byrow = TRUE), heights=c(1.25,1), respect=TRUE)
layout.show(nf)
plot(x1seq, mp.1inv.func(x1seq,skill="cog"), type="l",
     xlab="Decile of baseline cognitive skill", ylab="Marginal product of material investment",
     cex.lab=.8, xaxt="n",yaxt="n",  ylim=c(0,4.7))
axis(1,at=x1seq[seq(1,ngrid,ngrid/10)], labels=seq(1,10), cex.axis =.7)
axis(2,at=seq(0, 4.7, 0.5), cex.lab = .8, cex.axis=.7)
dev.off()

#######################################################################################################################################
# GRAPH 2:  Marginal product of both investment as a function of endowments in production function for non-cog skills
####################################################################################################################################### 
# Pick specification form where we're getting the results 
nameFirstStage <- c("CobbDouglas_OLS")
dir_outputPF      <- paste(dir,c("Output/"), nameFM,  "/",  nameFirstStage, sep="")
setwd(dir_outputPF)
load("OUTPUT_OLS_pval.R")

setwd(dir_outputFM)
mp.func  <- function(x,skill){
  
  if (skill=="cog"){
    type <- alldata$cog1
    s=1
  }
  if (skill=="ncog"){
    type <- alldata$ncog1
    s=2
  }

tfp           <- pf_true[1,s]
tfptreat      <- pf_true[2,s]
scog0         <- pf_true[3,s]
sncog0        <- pf_true[4,s]
smat          <- pf_true[5,s]
stime         <- pf_true[6,s]
scogmo        <- pf_true[7,s]
sncogmo       <- pf_true[8,s]
snkids        <- pf_true[9,s]


output.func <- function(x){
  out <- exp(tfp + scog0 * log(mean.cog0) + sncog0 * log(x) + scogmo * log(mean.cogmo)  + sncogmo * log(mean.ncogmo) +  
               snkids * log(mean.nkids) + smat * log(mean.mat) + stime * log(mean.time))
}
  
mpout <-  ((smat * output.func(x)  * sd(alldata$mat)/ mean.mat) +  (stime * output.func(x)  * sd(alldata$time) /mean.time))/sd(type)
  return(mpout)
}



pdf("MPncoginvncog.pdf")
old.par <- par( no.readonly = TRUE )
par( oma = c( 0, 0, 2, 0 ) )
nf    <- layout(matrix(c(1,2), 1, 2, byrow = TRUE), heights=c(1.25,1), respect=TRUE)
layout.show(nf)
plot(x2seq, mp.func (x2seq, skill="ncog"), type="l",
     xlab="Decile of baseline socio-emotional skill", ylab="Marginal product of investment",cex.lab=.8, xaxt="n",yaxt="n", ylim=c(0,4.7))
axis(1,at=x2seq[seq(1,ngrid,ngrid/10)], labels=seq(1,10), cex.axis =.7)
axis(2,at=seq(0, 4.7, 0.5), cex.lab = .8, cex.axis=.7)

dev.off()

