###################################################################
# Name              : latentfactors_noinstruments_MC.R
# 
# Description       : This file specifies the measurement system
#                     to be estimated (e.g. number of factors, which 
#                     measures are dedicated to which factor) as well as 
#                     starting values for the estimation algorithm 
#                     for the simple version of the model used in the 
#                     Monte Carlo exercise. 
###################################################################

# Set some parameters
nG                 <- 2             # Number of groups (here 2 for treated and controls)
nM                 <- 2             # Number of mixtures 
nI                 <- 0             # Number of instruments (that are assumed to be measured without error)
nF                 <- 5             # Number of factors (excluding instruments that are assumed to be measured without error)
nFI                <- nF + nI       # Total number of factors 
skill              <- c(1,2)        # 1 for cognitive skill, 2 for non-cognitive skill 
nS                 <- length(skill) # Number of production functions
nD                 <- 10000         # Number of draws from factor distribution 
nInvest            <- 2  
invar              <- 0             # 0 if we assume all loadings and intercepts of the measurement system are invariant across treatment and control groups 

parametric         <- 0 

# Define measures for each factor 
cog1  <- cbind(b_tot_cog1_st, b_tot_lr1_st, b_tot_le1_st, b_tot_mf1_st, mac_words1_st, mac_phrases1_st) 
  
cog0  <- cbind(b_tot_cog0_st, b_tot_lr0_st, b_tot_le0_st, b_tot_mf0_st, mac_words0_st)  
  
mat  <- cbind(fci_play_mat_type1_st, Npaintbooks1_st, Ntoysbought1_st, Nthingsmove1_st, Ntoysshape1_st)
 
time  <- cbind(fci_play_act1_st, home_stories1_st,  home_read1_st, home_toys1_st, home_name1_st)

cogmo <- cbind(edu_yrs_mo0_st,raventot_st, peabody_mo1_st,adult_books0_st, adult_mags0_st)

# Set the names of each factor for the output 
namef <- c("cog1",  "cog0", "mat", "time", "cogmo")

# Number of measures for each factor 
Ncog1       <- ncol(cog1)  
Ncog0       <- ncol(cog0)
Nmat        <- ncol(mat)
Ntime       <- ncol(time)
Ncogmo      <- ncol(cogmo)

#  Create dataset of measurements for estimation 
y        <- cbind(cog1, cog0, mat, time, cogmo)  

nZI      <- ncol(y)                    # Total number of measures 
nZ       <- nZI - nI                   # Total numebr of measures assumed to have some measurement error 
  
startSeq <- c(1, 
              1+Ncog1,
              1+Ncog1+Ncog0, 
              1+Ncog1+Ncog0+Nmat,
              1+Ncog1+Ncog0+Nmat+Ntime)

endSeq <- c(startSeq[2:nFI]-1, ncol(y))
  
freelambda <- matrix(0, nZ, nF) 
for (i in 1:nF) freelambda[startSeq[i]:endSeq[i], i]     <- 2 
for (i in 1:nF) freelambda[startSeq[i], i]               <- 1
rownames(freelambda) <- colnames(y)[1:nZ]

# Configuration of correlated measurement error (0=0, 1 = freely estimated)
freeuniq <- matrix(0, nZ, nZ)
diag(freeuniq) <- 1

# Restrictions on the means by treatment 
freemean     <- matrix(0,nG, nZ) 
freemean[2,] <- 1   #No restriction 

if (parametric == 1){
  # Initial values for M step: this is a list with (sigma, mean, prop)
  if (nM==2){
    mean0 <-  rbind(rep(.5, nZI), rep(-.5, nZI))
    sigma0 <- list(diag(nZI), diag(nZI))
    prop0  <- c(.5, .5)
  }
  if (nM ==3){
    mean0                 <- rbind(rep(.3, nZI), rep(0, nZI), rep(-.3, nZI))
    sigma0                <- list(diag(nZI), diag(nZI), diag(nZI))
    prop0                 <- c(.3, .4, .3)
  }
  
  if (nM ==4){
    mean0                 <- rbind(rep(.5, nZI), rep(0.25, nZI), rep(-0.25, nZI), rep(-.5, nZI))
    sigma0                <- list(diag(nZI), diag(nZI), diag(nZI), diag(nZI))
    prop0                 <- c(.25, .25, .25, .25)
  }
  mstep.start <- list(list(mean0, sigma0, prop0), list(mean0, sigma0, prop0))
  
  
  #Initial values for the least squares optimization step
  param.start <- c(rep(1,nZ),                              # Variance of measurement error
                   rep(rep(1, .5*nF*(nF+1)), nM*nG),       # Factor var-cov matrices
                   rep(rep(1, nF), nM-1 + nM*(nG-1)),      # Factor means
                   rep(1,length(which(freelambda==2))))     # Free factor loadings
  
}else if (parametric == 0){
  eps_start   <- rep(0.5,length(which(freeuniq[upper.tri(freeuniq, diag=T)]==1)) )
  cov_start   <- rep(0.5, 0.5*nF*(nF+1)*2) 
  mean_start  <- rep(0, nF)                   
  lambda_start <- rep(1, length(which(freelambda==2)))    
  param.start <- c(eps_start, cov_start, mean_start, lambda_start)  
}

  




