###################################################################
# Name              : AssembleBootstrapFS.R
# Description       : This program puts together the factor score
#                     estimates on bootstrapped samples 
###################################################################

# Run measurement specification file 
setwd(dir_anal)                            
source(inputFM) 

# Put all the results from the different nodes together in a list called "allbootFS" 
cores              <- length(pos)             # Total number of nodes 
allbootFS          <- list()
setwd(dir_outputFM)                           
for (b in 1:cores){  
  nameBootFS         <- paste("BootFS", pos[b], ".R", sep="")
  load(nameBootFS)
  allbootFS[[b]] <- fs_bstrap  
}

# Save the different components of this list into separate objectives
allbsample          <- bsample * cores 
fs_bstrap_all       <- list()
fs_bstrap_allBFGS   <- list()
fs_bstrap_allCG     <- list()

# Flag the boostrapped samples for which we couldn't estimate 
# factor scores 

noflagFS <- c(0)
for (c in 1:cores){
  for (r in 1:(allbsample/cores)){
  tryCatch({
    if (is.numeric(dim( allbootFS[[c]][[r]][[5]]))=="TRUE"){
    noflagFS <- c(noflagFS,(c-1)*(allbsample/cores) + r)
    } 
  }, error=function(e){print((c-1)*(allbsample/cores) + r)})
  }
}
noflagFS <- noflagFS[-1]

for (c in 1:cores){
  for (r in 1:(allbsample/cores)){
    if (length(which(noflagFS == (c-1)*(allbsample/cores) + r)==1)){
      for (g in 1:nG){
        fs_bstrap_all[[(c-1)*(allbsample/cores) + r]]    <- list(allbootFS[[c]][[r]][[2]] ,  allbootFS[[c]][[r]][[3]] )  
        fs_bstrap_allBFGS[[(c-1)*(allbsample/cores) + r]]    <- list(allbootFS[[c]][[r]][[5]] ,  allbootFS[[c]][[r]][[6]] )  
        fs_bstrap_allCG[[(c-1)*(allbsample/cores) + r]]    <- list(allbootFS[[c]][[r]][[8]] ,  allbootFS[[c]][[r]][[9]] )  
      }  
    }

  } 
} 

nofFS  <- length(noflagFS)
# Save output 
setwd(dir_outputFM)  
save(fs_bstrap_all,fs_bstrap_allBFGS, fs_bstrap_allCG, file="fs_bstrap.R")

