function rcind = rcindCreate(reclen,explen,Tmx,fst)
%
% This function creates 0-1 recession indicators from a series of
% recession and expansion lengths passed in. Inputs are:
% 
%   reclen      vector of recession lengths
%   explen      vector of expansion lenghts
%   Tmx         max length of generated series
%   fst         start date of first recession in sample (default=1)
%
% The timing assumption is that the recession captured by the length in
% reclen(j) immediately precedes the expansion captured by the length in
% explen(j).
%
% Output rcind is Tmx-vector of 0-1 indicators.
%
% For Beaudry, Galizia, and Portier, Putting the Cycle Back into Business
% Cycle Analysis (2019).

%%

rcind = zeros(Tmx,1);       % allocate memory for output

nrec = size(reclen,1);      % number of recessions
nexp = size(explen,1);      % number of expansions

% put start date of first recession into t0
if nargin == 4
    t0 = fst;
else
    t0 = 1;
end

rctr = 0;       % initialize counter for recession number
while t0 <= Tmx         % as long as we haven't surpassed the max number of periods
    rctr = rctr+1;          % advance counter
    
    if rctr <= nrec         % if we haven't used up all the recessions yet
        t1 = min(t0+reclen(rctr)-1,Tmx);    % set t1 to period # of last period of current recession
        rcind(t0:t1) = 1;                   % set indicators to 1 for current recession
        if rctr <= nexp                     % if we haven't used up all the expansions yet
            t0 = t1 + explen(rctr) + 1;         % set t0 to period # of first period of next recession
        else                                % otherwise
            t0 = Tmx+1;                         % set t0 to be greater than Tmx so we exit loop
        end
    else                    % otherwise
        t0 = Tmx+1;                         % set t0 to be greater than Tmx so we exit loop
    end
end
