function parsopt = MFNK_Est_FrmData(MM,shk,MP,OP,EstPars,parsin,mnopt)
%
% This function estimates the parameters based on the data and options
% passed in.
% 
% Inputs:
%   MM          struct variable containing data moments to be matched
%   shk         row vector of shock innovations
%   MP          struct variable of model parameters; depending on which
%                   parameters are estimated, some of these parameters will
%                   remain constant throughout the estimation, while others
%                   will be updated at each new set of estimated parameters
%   OP          struct variable containing non-model variables/parameters
%   EstPars     cell array indicating which model parameters are to be
%                   estimated, as well as any parameter transformations to
%                   be made (to capture parameter restrictions)
%   parsin      vector of parameter values to initialize estimation with
%   mnopt       struct variable containing optimization options
%
% Outputs:
%   parsopt     vector of optimized parameter values
%
% For Beaudry, Galizia, and Portier, Putting the Cycle Back into Business
% Cycle Analysis (2019).

%% Estimation

% call function to get objective function at initial parameters
fvopt0 = MFNK_Est_fn(parsin,MM,shk,MP,OP,EstPars);

% this block sequentially runs the optimization up to nruns times, with each
% optimization initalized from the previous result (more robust to getting
% stuck in some region of the parameter space).
for j = 1:mnopt.nruns
    
    % optimize
    [parsopt,fvopt1] = fminsearch(@(pars) MFNK_Est_fn(pars,MM,shk,MP,OP,EstPars),...
        parsin,mnopt.fminsopt);

    % back up parameters found thus far (in case of error somewhere, we can
    % use these as a starting point)
    MPsv = MFNK_Est_prtr(parsopt,MP,EstPars);   % call function to obtain all
                                                % model parameters at
                                                % current optimum
    save('ParBackup','parsopt','MPsv')  % save them

    parsin = parsopt;       % set initial parameters as previously optimized ones
    
    % if the new minimized objective function is close enough to the last
    % ones, convergence has occurred and we are done estimating
    if abs(fvopt1-fvopt0) <= 1e-6
        disp('OPTIMAL PARAMETERS FOUND')
        break;
    end
    
    fvopt0 = fvopt1;        % update initial ojbective function value
end



