% This code simulated Smets-Wouters (AER) with their esyimated parameters

% Number of similations
nz=10000;
% nz=1000;
% length of a simulation
hor = 270;




var   ewma epinfma  zcapf rkf kf pkf    cf invef yf labf wf rrf mc zcap rk k pk    c inve y lab pinf w r a  b g qs  ms  spinf sw kpf kp ;    

varexo ea eb eg  eqs  em  epinf ew  ;  
 
parameters curvw cgy curvp constelab constepinf constebeta cmaw cmap calfa 
czcap csadjcost ctou csigma chabb  cfc 
cindw cprobw cindp cprobp csigl clandaw 
crpi crdy cry crr 
crhoa  crhob crhog crhoqs crhoms crhopinf crhow  
ctrend cg
crl crlf;

% SW aer parametrization


gg=1.0045;

hh=1:hor;
hh0=51:50+hor;
ddate(1)=1948;
for i=2:hor
ddate(i)=ddate(i-1)+.25;
end;
 
samp=find(ddate==1948):find(ddate==2015.25); % for Total hours data



// fixed parameters
ctou=.025;
clandaw=1.5;
cg=0.18;
curvp=10;
curvw=10;
crl=0;
crlf=0;


// estimated parameters (mode)

crhoa      =    0.9826; 
crhob      =    0.1391; 
crhog      =    0.9686; 
crhoqs     =    0.6121; 
crhoms     =    0.1999; 
crhopinf   =    0.9856; 
crhow      =    0.9818; 
cmap       =    0.8340; 
cmaw       =    0.9337; 
csadjcost  =    6.3144; 
csigma     =    1.2679; 
chabb      =    0.8056; 
cprobw     =    0.7668; 
csigl      =    2.5201; 
cprobp     =    0.5304; 
cindw      =    0.5345; 
cindp      =    0.1779; 
czcap      =    0.3597; 
cfc        =    1.6670; 
crpi       =    1.8685; 
crr        =    0.8739; 
cry        =    -2; 
crdy       =    0.1282; 
constepinf =    0.6365; 
constebeta =    0.1126; 
constelab  =    1.3263; 
ctrend     =    0.5113; 
cgy        =    0.5881; 
calfa      =    0.2024; 





model(linear); 

% @#include "sw_stst.mod"
#cpie=1+constepinf/100;
#cgamma=1+ctrend/100 ;
#cbeta=1/(1+constebeta/100);

#clandap=cfc;
#cbetabar=cbeta*cgamma^(-csigma);
#cr=cpie/(cbeta*cgamma^(-csigma));
#crk=(cbeta^(-1))*(cgamma^csigma) - (1-ctou);
#cw = (calfa^calfa*(1-calfa)^(1-calfa)/(clandap*crk^calfa))^(1/(1-calfa));
//cw = (calfa^calfa*(1-calfa)^(1-calfa)/(clandap*((cbeta^(-1))*(cgamma^csigma) - (1-ctou))^calfa))^(1/(1-calfa));
#cikbar=(1-(1-ctou)/cgamma);
#cik=(1-(1-ctou)/cgamma)*cgamma;
#clk=((1-calfa)/calfa)*(crk/cw);
#cky=cfc*(clk)^(calfa-1);
#ciy=cik*cky;
#ccy=1-cg-cik*cky;
#crkky=crk*cky;
#cwhlc=(1/clandaw)*(1-calfa)/calfa*crk*cky/ccy;
#cwly=1-crk*cky;

#conster=(cr-1)*100;

// flexible economy

	      0*(1-calfa)*a + 1*a =  calfa*rkf+(1-calfa)*(wf)  ;
	      zcapf =  (1/(czcap/(1-czcap)))* rkf  ;
	      rkf =  (wf)+labf-kf ;
	      kf =  kpf(-1)+zcapf ;
	      invef = (1/(1+cbetabar*cgamma))* (  invef(-1) + cbetabar*cgamma*invef(1)+(1/(cgamma^2*csadjcost))*pkf ) +qs ;
          pkf = -rrf-0*b+(1/((1-chabb/cgamma)/(csigma*(1+chabb/cgamma))))*b +(crk/(crk+(1-ctou)))*rkf(1) +  ((1-ctou)/(crk+(1-ctou)))*pkf(1) ;
	      cf = (chabb/cgamma)/(1+chabb/cgamma)*cf(-1) + (1/(1+chabb/cgamma))*cf(+1) +((csigma-1)*cwhlc/(csigma*(1+chabb/cgamma)))*(labf-labf(+1)) - (1-chabb/cgamma)/(csigma*(1+chabb/cgamma))*(rrf+0*b) + b ;
	      yf = ccy*cf+ciy*invef+g  +  crkky*zcapf ;
	      yf = cfc*( calfa*kf+(1-calfa)*labf +a );
	      wf = csigl*labf 	+(1/(1-chabb/cgamma))*cf - (chabb/cgamma)/(1-chabb/cgamma)*cf(-1) ;
	      kpf =  (1-cikbar)*kpf(-1)+(cikbar)*invef + (cikbar)*(cgamma^2*csadjcost)*qs ;

// sticky price - wage economy

	      mc =  calfa*rk+(1-calfa)*(w) - 1*a - 0*(1-calfa)*a ;
	      zcap =  (1/(czcap/(1-czcap)))* rk ;
	      rk =  w+lab-k ;
	      k =  kp(-1)+zcap ;
	      inve = (1/(1+cbetabar*cgamma))* (  inve(-1) + cbetabar*cgamma*inve(1)+(1/(cgamma^2*csadjcost))*pk ) +qs ;
          pk = -r+pinf(1)-0*b +(1/((1-chabb/cgamma)/(csigma*(1+chabb/cgamma))))*b + (crk/(crk+(1-ctou)))*rk(1) +  ((1-ctou)/(crk+(1-ctou)))*pk(1) ;
	      c = (chabb/cgamma)/(1+chabb/cgamma)*c(-1) + (1/(1+chabb/cgamma))*c(+1) +((csigma-1)*cwhlc/(csigma*(1+chabb/cgamma)))*(lab-lab(+1)) - (1-chabb/cgamma)/(csigma*(1+chabb/cgamma))*(r-pinf(+1) + 0*b) +b ;
	      y = ccy*c+ciy*inve+g  +  1*crkky*zcap ;
	      y = cfc*( calfa*k+(1-calfa)*lab +a );
	      pinf =  (1/(1+cbetabar*cgamma*cindp)) * ( cbetabar*cgamma*pinf(1) +cindp*pinf(-1) 
               +((1-cprobp)*(1-cbetabar*cgamma*cprobp)/cprobp)/((cfc-1)*curvp+1)*(mc)  )  + spinf ; 
	      w =  (1/(1+cbetabar*cgamma))*w(-1)
               +(cbetabar*cgamma/(1+cbetabar*cgamma))*w(1)
               +(cindw/(1+cbetabar*cgamma))*pinf(-1)
               -(1+cbetabar*cgamma*cindw)/(1+cbetabar*cgamma)*pinf
               +(cbetabar*cgamma)/(1+cbetabar*cgamma)*pinf(1)
               +(1-cprobw)*(1-cbetabar*cgamma*cprobw)/((1+cbetabar*cgamma)*cprobw)*(1/((clandaw-1)*curvw+1))*
               (csigl*lab + (1/(1-chabb/cgamma))*c - ((chabb/cgamma)/(1-chabb/cgamma))*c(-1) -w) 
               + 1*sw ;
	      r =  crpi*(1-crr)*pinf + crlf*lab(+1) - crl*lab
               +cry*(1-crr)*(y-yf)     
               +crdy*(y-yf-y(-1)+yf(-1))
               +crr*r(-1)
               +ms  ;
	      a = crhoa*a(-1)  + ea;
	      b = crhob*b(-1) + eb;
	      g = crhog*(g(-1)) + eg + cgy*ea;
	      qs = crhoqs*qs(-1) + eqs;
	      ms = crhoms*ms(-1) + em;
	      spinf = crhopinf*spinf(-1) + epinfma - cmap*epinfma(-1);
	          epinfma=epinf;
	      sw = crhow*sw(-1) + ewma - cmaw*ewma(-1) ;
	          ewma=ew; 
	      kp =  (1-cikbar)*kp(-1)+cikbar*inve + cikbar*cgamma^2*csadjcost*qs ;

end; 

shocks;
var ea;
stderr 0.5017;
var eb;
stderr 0.3583;
var eg;
stderr  0.6752;
var eqs;
stderr 0.5678;
var em;
stderr 0.2290;
var epinf;
stderr 0.2181;
var ew;
stderr  0.2663;
end;



steady;
check;


%% Stochastic simulations


nj=0;

while nj<nz;
    nj=nj+1;
    disp(nj);
    

stoch_simul(periods=355,nocorr,nofunctions,nomoments,irf=0,noprint);
    


    pred=[16 25];
    for i=[14 16 20 21 25];
        if i==pred,
            s1=['V' deblank(M_.endo_names(i,:)) ' = (oo_.endo_simul(' num2str(i) ',1:options_.periods-1)) ;'];% Levels
            eval(s1);
        else
            s1=['V' deblank(M_.endo_names(i,:)) ' = (oo_.endo_simul(' num2str(i) ',2:options_.periods)) ;'];% Levels
            eval(s1);
        end;
    end;


    
     for t=1:350
        for i=[16 20 25];
            s1=['VV' deblank(M_.endo_names(i,:)) '(t) = (1+V' deblank(M_.endo_names(i,:)) '(t) /100)*gg^t;'];
            eval(s1);
        end
        s1=['VV' deblank(M_.endo_names(21,:)) '(t) = (1+V' deblank(M_.endo_names(21,:)) '(t) /100)*1;'];
        eval(s1);
        s1=['VV' deblank(M_.endo_names(14,:)) '(t) = (1+V' deblank(M_.endo_names(21,:)) '(t) /100)*1;'];
        eval(s1);
    end
    


    
    lh=(VVlab(hh0))';


X0h=lh;


Xbph(:,nj)=(X0h(samp)-mean(X0h(samp)))*100;
    


end;  % end of simulations


%% Estimating Spectral density

TT = 1024;                   % number of points in fft
nkern=13;                    % Kernel
kr = hamming(nkern);

Tsp = length((samp));                    % size of simulated data set, minus 1, before cutting

% number of points in one side of fft
Todd = logical(mod(TT,2));
if Todd
    TT2 = (TT+1)/2;
else
    TT2 = TT/2 + 1;
end

kr = kr/sum(kr);                            % normalize weights to sum to one
nkr = numel(kr);                            % length of kernel function



for nj=1:nz
    [datspecT,~] = DatSpec([Xbph(:,nj)],kr,0,TT);        % call external spectrum estimation function
    spXbpLevel(:,nj)  = squeeze(datspecT(1,1,:));
end

spXm=mean(spXbpLevel,2);

spXmh=spXm;

save  SWSimulatedSpectrum spXmh;



