function [fnvl,coefs,MM,SM] = MFNK_Est_fn(pars,MMdat,shk,MP,OP,EstPars)
%
% This function returns the value of the minimization objective function
% using the values of the estimated parameters contained in the input pars.
% 
% Inputs:
%   pars        vector of parameter values
%   MMdat       struct variable containing targeted data features/moments
%   shk         row vector of shock innovations
%   MP          struct variable of model parameters; depending on which
%                   parameters are estimated, some of these parameters will
%                   remain constant, while others will be updated based on
%                   the values in pars
%   OP          struct variable containing non-model variables/parameters
%   EstPars     cell array indicating which model parameters are to be
%                   estimated, as well as any parameter transformations to
%                   be made (to capture parameter restrictions)
%
% Outputs:
%   fnvl        value of the objective function
%   coefs       vector of coefficients on monomials in the perturbation
%                   solution
%   MM          struct variable containing model moments
%   SM          struct variable of full model simulation results
%
% For Beaudry, Galizia, and Portier, Putting the Cycle Back into Business
% Cycle Analysis (2019).

%% Update MP to reflect parameter values in pars

MP = MFNK_Est_prtr(pars,MP,EstPars);

%% Get simulated moments

% call function to get (non-smoothed) spectra and moments for each simulated data set
[SM,coefs,fnadd,exfl] = MFNK_Est_SimMom(shk,MP,OP);

if exfl == -1       % if there was a problem, set the objective function to
                        % the penalty value returned and exit
    MM = [];
    fnvl = fnadd;
    return;
end

% smooth hours spectra, average across simulations, and load into MM struct
MM.specl = mean(SM.speclall(:,1:SM.nact),2);     % mean of simulated one-sided spectra
conspecl = [MM.specl(OP.nkr:-1:2);MM.specl;MM.specl(end-1:-1:end-OP.nkr+1)]; % extend for wrap-around kernel-smoothing
conspecl = conv(conspecl,OP.kr,'same');       % kernel-smooth
MM.specl = conspecl(OP.nkr:OP.TT2+OP.nkr-1);     % drop extra frequencies added for wrap-around

% smooth risk premium spectra, average across simulations, and load into MM struct
MM.specRP = mean(SM.specRPall(:,1:SM.nact),2);     % mean of simulated one-sided spectra
conspecRP = [MM.specRP(OP.nkr:-1:2);MM.specRP;MM.specRP(end-1:-1:end-OP.nkr+1)]; % extend for wrap-around kernel-smoothing
conspecRP = conv(conspecRP,OP.kr,'same');       % kernel-smooth
MM.specRP = conspecRP(OP.nkr:OP.TT2+OP.nkr-1);     % drop extra frequencies added for wrap-around

MM.mm = mean(SM.mmsall(:,1:SM.nact),2); % load average of higher moments into MM struct

%% Get objective function

% differences between data and model moments
m1 = MM.specl(OP.spcmp) - MMdat.specl(OP.spcmp);
m2 = MM.specRP(OP.spcmp) - MMdat.specRP(OP.spcmp);
m3 = MM.mm - MMdat.datmm;

M = [m1;m2;m3];     % concatenate

totsqdiff = sum(M.^2);   % total squared deviation

fnvl = log(totsqdiff) + fnadd;  % set objective function
