% This is a marginally modified version of the Fernandez-Villaverde's code


% Basic RBC Model as described in Chapter 1 of Cooley,
% Frontiers of Business Cycle Research
%
% Details:
%   1) Computation in levels, 1st order approximation.
%   2) Calculates also by perturbation investment (i) and labor
%   productivity (y_l).
%   3) Calibration from Cooley and Prescott.
%
% Jesus Fernandez-Villaverde
% Philadelphia, March 3, 2005




%----------------------------------------------------------------
% 0. Housekeeping
%----------------------------------------------------------------

% Number of simulations
nz=10000;
% nz=1000;
% length of a simulation
hor = 270;




gg=1.0156^0.25;
hh=1:hor;
hh0=51:50+hor;
ddate(1)=1948;
for i=2:hor
    ddate(i)=ddate(i-1)+.25;
end;

samp=find(ddate==1948):find(ddate==2015.25); % for Total hours data






%----------------------------------------------------------------
% 1. Defining variables
%----------------------------------------------------------------

var y c k i l y_l z;
varexo e;

parameters theta delta rho sigma gamma beta alpha eta;

%----------------------------------------------------------------
% 2. Calibration
%----------------------------------------------------------------

% Technology
theta  = 0.4;
delta  = 0.012;
rho    = 0.95;
sigma  = 0.007;
gamma  = (gg)-1;

% Preferences
beta   = 0.987;
alpha  = 0.64;
eta    = (1.012^0.25)-1;

%----------------------------------------------------------------
% 3. Model
%----------------------------------------------------------------

model;
((1+gamma)/c) = beta*(1/c(+1))*(1+theta*exp(z(+1))*(k^(theta-1))*(l(+1)^(1-theta))-delta);
alpha*c/((1-alpha)*(1-l)) = (1-theta)*exp(z)*(k(-1)^theta)*(l^(-theta));
c+i = y;
y = exp(z)*(k(-1)^theta)*(l^(1-theta));
i = (1+gamma)*(1+eta)*k-(1-delta)*k(-1);
y_l = y/l;
z = rho*z(-1)+e;
end;

%----------------------------------------------------------------
% 4. Computation
%----------------------------------------------------------------

initval;
k = 24;
c = 1.33;
l = 0.31;
z = 0;
e = 0;
end;

shocks;
var e = sigma^2;
end;

steady;

%% Stochastic simulations

nj=0;

while nj<nz;
    nj=nj+1;
    disp(nj);
    
    
    stoch_simul(periods=355,nocorr,nofunctions,nomoments,irf=0,noprint);
    
    
    
    pred=[3 7];
    for i=[1:7];
        if i==pred,
            s1=['V' deblank(M_.endo_names(i,:)) ' = (oo_.endo_simul(' num2str(i) ',1:options_.periods-1)) ;'];% Levels
            eval(s1);
        else
            s1=['V' deblank(M_.endo_names(i,:)) ' = (oo_.endo_simul(' num2str(i) ',2:options_.periods)) ;'];% Levels
            eval(s1);
        end;
    end;
    
    
    VVl=Vl;
    
   
    
    lh=log(VVl(hh0))';
    
    
    X0=lh;
    
    
    Xbp(:,nj)=(X0(samp)-mean(X0(samp)))*100;
    
    
    
end;  % end of simulations


%% Estimating Spectral density

TT = 1024;                   % number of points in fft
nkern=13;                    % Kernel
kr = hamming(nkern);

Tsp = length((samp));                    % size of simulated data set, minus 1, before cutting

% number of points in one side of fft
Todd = logical(mod(TT,2));
if Todd
    TT2 = (TT+1)/2;
else
    TT2 = TT/2 + 1;
end

kr = kr/sum(kr);                            % normalize weights to sum to one
nkr = numel(kr);                            % length of kernel function



for nj=1:nz
    [datspecT,~] = DatSpec([Xbp(:,nj)],kr,0,TT);        % call external spectrum estimation function
    spXbpLevel(:,nj)  = squeeze(datspecT(1,1,:));
end

spXm=mean(spXbpLevel,2);

spXmh=spXm;

save RBCSimulatedSpectrum spXmh;



