/* This do file is used to test for reduced-form evidence of strategic bidding 
by testing bid response to a nuclear outage.
*/

clear


local regressoutdesc AER-table3.out

use bidslope_MC_nuke.dta, clear

*BIG DROP IN NUCLEAR OUTPUT OCCURRED ON T=42818.25
g post=(T>=42818.25)


g big=(name=="REL" | name=="TXU" | name=="CAL")
	*three largest among 12 CH firms 
g small=(name=="TEN-F" | name=="GAR" | name=="BTU")
	*three smallest among 12 CH firms

g size=.
replace size=0.195 if name=="REL"
replace size=0.169615  if name=="TXU"
replace size=0.156923  if name=="CAL"
replace size=0.152308  if name=="GUAD"
replace size=0.135385  if name=="CPL"
replace size=0.104615  if name=="LPP"
replace size=0.103462  if name=="COGLY"
replace size=0.086154  if name=="WTU"
replace size=0.07      if name=="TEN-G"
replace size=0.055385  if name=="TEN-F"
replace size=0.044231  if name=="GAR"
replace size=0.021538  if name=="BTU"


g bigALL=(size>=0.104615)  
	*biggest 6
g smallALL=(bigALL==0)


*Largest and Smallest Three (Table 3 of paper)
reg bid_dq_dp post if big, robust
eststo,title("Big3")
reg bid_dq_dp post if small, robust
eststo,title("Small3")
reg bid_dq_dp post MC_dq_dp if big, robust
eststo,title("Big3-MC")
reg bid_dq_dp post MC_dq_dp if small, robust
eststo,title("Small3-MC")
reg bid_dq_dp post MC_dq_dp i.bidder if big, robust
eststo,title("Big3-MC-FE")
reg bid_dq_dp post MC_dq_dp i.bidder if small, robust
eststo,title("Small3-MC-FE")

*All firms split into Small and Large (robustness result)
reg bid_dq_dp post if bigALL, robust
eststo,title("BigAll")
reg bid_dq_dp post if smallALL, robust
eststo,title("SmallAll")
reg bid_dq_dp post MC_dq_dp if bigALL, robust
eststo,title("BigAll-MC")
reg bid_dq_dp post MC_dq_dp if smallALL, robust
eststo,title("SmallAll-MC")
reg bid_dq_dp post MC_dq_dp i.bidder if bigALL, robust
eststo,title("BigAll-MC-FE")
reg bid_dq_dp post MC_dq_dp i.bidder if smallALL, robust
eststo,title("SmallAll-MC-FE")

estout using `regressoutdesc', cells(b(star fmt(%9.2f) ) se(fmt(%9.2f) par(`"="("'`")""')) ) stats(depvar N r2, fmt(0 0 %9.4f) labels(DepVar "N" "R^2")) label wrap starlevels(+ 0.05 * 0.01) legend varlabels(_cons Constant) replace

