/* This do file is used to compute profits under the estimated model during the outgage
period and then compares these to those in the data and under the best-response model.

*/

use QC.dta, clear
replace aucid=aucid+0.19921875
merge 1:1 aucid bidderid using data_outgage.dta
sort aucid bidderid
drop _merge
merge 1:1 aucid bidderid using profits_best_response.dta
drop _merge

* gen dates
gen days=int(aucid/100)
gen month=200208 if days>=366 & days<=396
replace month=200209 if days>=398 & days<=426
replace month=200210 if days>=427 & days<=457
replace month=200211 if days>=458 & days<=487
replace month=200212 if days>=488 & days<=518
replace month=200301 if days>=519 & days<=549

gen PC = 37.83841 if month==200208 
replace PC=28.82169 if month==200209
replace PC=28.38333 if month==200210
replace PC=32.34535 if month==200211
replace PC=29.14105 if month==200212
replace PC=32.24647 if month==200301

gen pcqc=QC*PC

drop if profit_real==-999999

foreach k of varlist profit_pre profit_real profit_xpo {
gen fixed_`k'=`k'+pcqc
}

gen ss = cond(aucid<42818.25 | aucid>48418.25,0,1)
xi: reg fixed_profit_real fixed_profit_xpo if ss==1, vce(cluster bidderid)
gen sample=1 if e(sample)==1
estimates store xpo

xi: reg fixed_profit_real fixed_profit_pre if sample==1, vce(cluster bidderid)
estimates store ch

xi: reg fixed_profit_real fixed_profit_pre fixed_profit_xpo  if sample==1, vce(cluster bidderid)
estimates store chxpo
esttab xpo ch chxpo using "pred_outgage.tex", replace /*
*/ b(%8.4f) se(%8.4f) r2(%8.2f) tex label /*
*/ stats(meany N r2 market,  fmt(3 0 3) /*
*/ labels(`"Observations"' `"\(R^{2}\)"'))/*
*/ starlevels(* 0.10 ** 0.05 *** 0.01) title("Explaining variation in realized profits during outgage period") order(  )



use QC.dta, clear
replace aucid=aucid+0.19921875
merge 1:1 aucid bidderid using profit_model_dta.dta
sort aucid bidderid
drop _merge
merge 1:1 aucid bidderid using profits_best_response.dta
drop _merge
merge 1:1 aucid bidderid using profits_best_response_smooth.dta
drop _merge

* gen dates
gen days=int(aucid/100)
gen month=200208 if days>=366 & days<=396
replace month=200209 if days>=398 & days<=426
replace month=200210 if days>=427 & days<=457
replace month=200211 if days>=458 & days<=487
replace month=200212 if days>=488 & days<=518
replace month=200301 if days>=519 & days<=549

gen PC = 37.83841 if month==200208 
replace PC=28.82169 if month==200209
replace PC=28.38333 if month==200210
replace PC=32.34535 if month==200211
replace PC=29.14105 if month==200212
replace PC=32.24647 if month==200301

gen pcqc=QC*PC

drop if profit_real==-999999
drop *smooth

foreach k of varlist profit_pre profit_real profit_xpo {
gen fixed_`k'=`k'+pcqc
}

reg fixed_profit_real fixed_profit_xpo, vce(cluster bidderid)
estimate store f1xpo
gen sample=1 if e(sample)==1

xi: reg fixed_profit_real fixed_profit_pre if sample==1, vce(cluster bidderid)
estimate store f2

xi: reg fixed_profit_real fixed_profit_pre fixed_profit_xpo if sample==1, vce(cluster bidderid)
estimate store f3

