function output=inc_IQ_s_draw(id_vector,bigfirm_size,side,R,type_sim)
% Help: This function compute all counterfactual output when firms
% (id_vector) increase size to bigfirm_size. "id_vector" corresponds to a row  
% vector containing the IDs of all firms INC IQ. ("side=1"==choose 
% auctions on the INC side; "side=2"==choose those on the DEC side; 
% "side=0"==all auctions)


%-------------------------------------------------------------------------%
%                             Bidder IDs                                  %
%-------------------------------------------------------------------------%
                                                                                                                                                    %
%-------------------------------------------------------------------------%
%                        (1) Set Model Primitives                         %
%-------------------------------------------------------------------------%
format shortG                                                             %
bidders_CH = [4,5,19,27,6,15,29,24,23,8,16,9];                            % players in CH
gamma = [-0.726 14.594];
K=20;                                                                          
%-------------------------------------------------------------------------%
%                            (2) Load Data                                %
%-------------------------------------------------------------------------%
                                                                          %
dat = dlmread('full_pqs.csv',',');                           % bids data
dat2 = dlmread('totdemand_mcprice.csv',',');                     % total demand and market clearing price data
dat3 = dlmread('mcosts.csv',',');                  % marginal cost data
dat4 = dlmread('firm_size_new.csv',',');                                  % firm size data
                                                                          %
time_pq = dat(:,1);                                                       % auction IDs in bids data
p = dat(:,2);                                                             % price unit of bids
qinc = dat(:,3);                                                          % incremental bids
bidderid = dat(:,4);                                                      % firm IDs in the bids data
qcum = dat(:,5);                                                          % cumulative bids
                                                                          %
time_dem = dat2(:,1);                                                     % auction IDs in total demand and market clearing price data
totdem = dat2(:,2);                                                       % total demand 
mktcp = dat2(:,3);                                                        % actual market clearing price
                                                                          %
time_mc = dat3(:,1);                                                      % auction IDs in MC data
mc_unit = dat3(:,2);                                                      % price unit of marginal cost
mc_cum = dat3(:,5);                                                       % cumlative marginal cost
mc_inc_q = dat3(:,4);                                                     % incremental marginal cost
qse_id = dat3(:,3);                                                       % firm IDs in the MC data
                                                                          %
sizeid = dat4(:,1);                                                       % firm ID for firm size
firm_size_all = dat4(:,2);                                                % firm size
                                                                          %
%              (3) Find the Auctions That Are Studied                     %
%-------------------------------------------------------------------------%
                                                                          %
aucvec = unique(time_pq);                                                 % 
aucvec = [aucvec(1:25);aucvec(28:100);aucvec(116:119);aucvec(121:139);... %
    aucvec(143:end)];                                                     %
                                                                          %
aucvec_use=find_auc_CH(bidders_CH,aucvec,time_pq,bidderid,time_mc,qse_id);% 
                                                                          %
aucvec_use=find_auc_QC(aucvec_use,bidders_CH,time_pq,time_mc,p,qinc,...   %   
    bidderid,mc_unit,mc_inc_q,qse_id);                                    % 
aucvec_use=[aucvec_use(1:67);aucvec_use(69:88);aucvec_use(90:end)];       %
                                                                          %
aucvec_use=find_DEC_INC_ALL(side,aucvec_use,time_dem,totdem);             % "side=1"==choose INC side;"side=2"==choose DEC side;
                                                                          % "side=0"==all auctions
%-------------------------------------------------------------------------%
%                  (4) Simulate Firm Bids After INC IQ                    %                 
%-------------------------------------------------------------------------%
                                                                          %
[X, X_new]=find_X_Xnew_s(bigfirm_size,bidders_CH,id_vector,sizeid,...      % find covariate matrix (X) after INC IQ
    firm_size_all);                                                       %
                                                                        %
time_pq_fringe=fringe_dat(aucvec_use,bidders_CH,time_pq,p,qinc,bidderid); % find fringe firm bids
time_fringe = time_pq_fringe(:,1);                                        % auction ID for fringe data
p_fringe_all = time_pq_fringe(:,3);                                       % price unit of fringe bids
q_fringe_all = time_pq_fringe(:,4);                                       % fringe bids
                                                                          % 
qcont_mat_all = see_contract(aucvec_use,bidders_CH,time_pq,time_mc,...    % find contract position of bidders in CH 
    p,qinc,bidderid,mc_unit,mc_inc_q,qse_id);                             %
time_qcont = qcont_mat_all(:,1);                                          % auction ID for QC data
qcont_mat = qcont_mat_all(:,2:end);                                       % QC for bidders in CH
                                                                          %
[time_id_bids_IncIQ,n_pgrid] = find_bids_pre_draw(gamma,aucvec_use,time_dem,mktcp,...      % find predicted bids 
    time_mc,time_fringe,time_qcont,mc_unit,mc_inc_q,qse_id,p_fringe_all,...%
    q_fringe_all,bidders_CH,qcont_mat,X_new,K);  
                                                                          %
time_IncIQ = time_id_bids_IncIQ(:,1);                                     % auction ID of cft data
p_IncIQ = time_id_bids_IncIQ(:,3);                                        % price unit of cft 
qinc_IncIQ = time_id_bids_IncIQ(:,4:4+K);                                     % incremental bids of cft
qcum_IncIQ = time_id_bids_IncIQ(:,5+K:end);                                     % cumulative of cft
bidderid_IncIQ = time_id_bids_IncIQ(:,2);                                 % bidder ID of cft data
                                                                          %
im1000=find(mc_unit==-1000);                                              % MC has the convention that the first price point is at -1000, 
mc_unit(im1000)=-10001;                                                   % rather than at -10001, which is the convention with bids. 
i1000=find(mc_unit==1000);                                                % Change these prices to -10001 to be consistent with bids.
mc_unit(i1000)=10001;                                                     %
                                                                          %
%-------------------------------------------------------------------------%
%                   (5) Calculate Output After INC IQ                     %
%-------------------------------------------------------------------------%
                                                                          %
%output=[];                                                                % matrix recording outcomes for each auction
                                                                          %
tcost_mat=[];  
mktcp_mat=[];
tqcall_mat=[];

indcost_mat = [];
indprofit_mat = [];
qcall_mat = [];

                                                                          
for j1 = 1:length(aucvec_use)                                             % loop over auctions
                                                                          %    
%~~~~~~~~~~~~~~~~~~ (5.1) load data for this auction ~~~~~~~~~~~~~~~~~~~~~% 
                                                                          % 
    thisauc = aucvec_use(j1);                                             % ID of this auction
                                                                          %   
    totdemauc = totdem(find(time_dem==thisauc));                          % total demand 
                                                                          % 
    pauc = p(find(time_pq==thisauc));                                     % real bids 
    qauc = qinc(find(time_pq==thisauc));                                  %
    bidderidauc = bidderid(find(time_pq==thisauc));                       %
    biddervecauc = unique(bidderidauc);                                   %
                                                                          %
    iauc3 = find(ismember(time_mc,thisauc).*ismember(qse_id,biddervecauc));% find the marginal cost data         
    mcp_auc = mc_unit(iauc3);                                             % for firms that submitted bids
    mcq_auc = mc_inc_q(iauc3);                                            %
    qseidauc = qse_id(iauc3);                                             %
                                                                          %    
    qcont_mat_auc = qcont_mat(find(time_qcont==thisauc),:);               % contract positions of CH bidders 
                                                                          % in this auction  
                                                                          
 %%%%%%%%%%%%%%%%%% changed by Dongni on Oct 4 %%%%%%%%%%%%%%%%%%%%%%%%%%%%   
%output_auc_IncIQ_avg=zeros(length(bidders_CH),6);
%tcost_IncIQ_avg = 0;
%tqcall_IncIQ_avg = 0;

    tcost_mat(j1,1) = thisauc;
    mktcp_mat(j1,1) = thisauc;
    tqcall_mat(j1,1) = thisauc;
    
    indcost_sim = [];
    indprofit_sim = [];
    qcall_sim = [];

for r = 1:R
    
    type_r = type_sim(:,r);
    %disp('type_r');
    %disp(type_r);
    %pause;                                                                          
    pauc_IncIQ = p_IncIQ(find(time_IncIQ==thisauc));                      % bids after INC IQ  
    bidderidauc_IncIQ = bidderid_IncIQ(find(time_IncIQ==thisauc));        %
    qauc_IncIQ_r = qinc_IncIQ(find(time_IncIQ==thisauc),:);                   %
    
    qauc_IncIQ = [];   
    for j = 1:length(bidders_CH)
        if type_r(j)>20
            type_r(j)=20;
        end
        q_this = qauc_IncIQ_r((j-1)*n_pgrid+1:j*n_pgrid,(type_r(j)+1));
        qauc_IncIQ = [qauc_IncIQ;q_this];
    end 
    
    
%~~~~~~~~~~~~~ (5.2) find market clearing price after INC IQ ~~~~~~~~~~~~~%
                                                                          % 
    [pauc_IncIQ_all,qinc_auc_IncIQ_all,bidderid_auc_IncIQ_all]=...        % replace CH players' real bid with bids  
    replace_bids(bidders_CH,pauc,qauc,bidderidauc,pauc_IncIQ,...          % after INC IQ
    qauc_IncIQ,bidderidauc_IncIQ);                                        %
    [aggsq_IncIQ, aggsp_IncIQ] = agg_supply(pauc_IncIQ_all,...            % aggregate supply after INC IQ 
        qinc_auc_IncIQ_all);                                              % 
    mktcp_IncIQ = find_mktclr_new(aggsq_IncIQ,aggsp_IncIQ,totdemauc);     % market clearing price after INC IQ
                                                                          % 
%~~~~~~~~~~~~~~~~~~ (5.3) simulate output after INC IQ ~~~~~~~~~~~~~~~~~~~%
                                                                          % 
    %output_auc=[];                                                        % record output for this auction
    tqcall_IncIQ=0;                                                       % record quantity called in this auction
    tcost_IncIQ=0;  
    
    bidder_auc = [];%
    indcost_auc = [];
    indprofit_auc = [];
    qcall_auc = [];% record total cost for this auction
                                                                          % 
    for k1=1:length(biddervecauc)                                         % loop over bidders
                                                                          %          
        thisbidder = biddervecauc(k1);                                    % bidder ID
                                                                          %  
        mcpbidder = mcp_auc(find(qseidauc==thisbidder));                  % mc
        mcqbidder = mcq_auc(find(qseidauc==thisbidder));                  %
                                                                          %  
        pbidder_act = pauc(find(bidderidauc==thisbidder));                % real bids
        qbidder_act = qauc(find(bidderidauc==thisbidder));                %
                                                                          %  
        [pbidder_IncIQ,qbidder_IncIQ]=find_bids(pauc_IncIQ,qauc_IncIQ,... % bids after INC IQ 
    bidderidauc_IncIQ,pbidder_act,qbidder_act,thisbidder,bidders_CH);     % 
                                                                          %  
%        missing_MC_data = missing_MC_data+isempty(mcqbidder);            %
        if max(mcqbidder)==0 & max(qbidder_act)>0                         %
%            missing_MC_data = missing_MC_data+1;                         %
            mcqbidder = qbidder_act;                                      %
            mcpbidder = pbidder_act;                                      %
            ['Problem: Cannot INC that much so assumed mc is the bids']   %
        end                                                               %
                                                                          %          
        mcqcumbidder = cumsum(mcqbidder);                                 % cumulative mc
        ybidder_IncIQ = cumsum(qbidder_IncIQ);                            % cumulative bids
        qcall_IncIQ = find_qcall_new(mktcp_IncIQ,aggsq_IncIQ,...          % quantity called of this bidder
            aggsp_IncIQ,totdemauc,ybidder_IncIQ,pbidder_IncIQ);           %
        indcost_IncIQ = find_individualcost(mcqcumbidder,mcpbidder,...    % total cost of this bidder
            qcall_IncIQ,thisbidder);                                      %
        tqcall_IncIQ=tqcall_IncIQ+qcall_IncIQ;                            %
        tcost_IncIQ=tcost_IncIQ+indcost_IncIQ;                            %
        if ismember(thisbidder,bidders_CH)                                %
            qcont_bidder=qcont_mat_auc(find(bidders_CH==thisbidder));     %
            [profit_IncIQ,totcost_IncIQ] = find_profit1(mcqcumbidder,...  %
                mcpbidder,qcall_IncIQ,mktcp_IncIQ,qcont_bidder,thisbidder);
        end
                                                                          % 
%-------------------------------------------------------------------------%
%                            (6) Record Output                            %
%-------------------------------------------------------------------------%
                                                                          %            
        if ismember(thisbidder,bidders_CH)                                % record output if this firm is in CH
            bidder_auc=[bidder_auc;thisbidder];
            indcost_auc=[indcost_auc;indcost_IncIQ];
            indprofit_auc = [indprofit_auc;profit_IncIQ];
            qcall_auc = [qcall_auc;qcall_IncIQ]; 
        end
    end%
    
    
    tcost_mat(j1,r+1)=tcost_IncIQ;
    mktcp_mat(j1,r+1) = mktcp_IncIQ;
    tqcall_mat(j1,r+1) = tqcall_IncIQ;
      
    indcost_sim = [indcost_sim indcost_auc];
    indprofit_sim = [indprofit_sim indprofit_auc];
    qcall_sim = [qcall_sim qcall_auc];

    
end                                                                   
    indcost_sim = [bidder_auc indcost_sim];
    indprofit_sim = [bidder_auc indprofit_sim];
    qcall_sim = [bidder_auc qcall_sim];
    
    a=ones(size(bidder_auc,1),1);                                         %
    
    indcost_mat = [indcost_mat; [a*thisauc indcost_sim]];
    indprofit_mat = [indprofit_mat; [a*thisauc indprofit_sim]];
    qcall_mat = [qcall_mat;[a*thisauc qcall_sim]];                                                                      
                                                                          
end                                                                       % for j1 = 1:length(aucvec_use) 

filename2 = ['IncIQ_s_draw_tcost firm ' num2str(id_vector) ' incIQ to '...
    num2str(bigfirm_size) '_' num2str(side) '.xlsx'];      
xlswrite(filename2,tcost_mat);

filename3 = ['IncIQ_s_draw_mktcp firm ' num2str(id_vector) ' incIQ to '...
    num2str(bigfirm_size) '_' num2str(side) '.xlsx'];      
xlswrite(filename3,mktcp_mat);

filename4 = ['IncIQ_s_draw_tqcall firm ' num2str(id_vector) ' incIQ to '...
    num2str(bigfirm_size) '_' num2str(side) '.xlsx'];      
xlswrite(filename4,tqcall_mat);

filename5 = ['IncIQ_s_draw_indcost firm ' num2str(id_vector) ' incIQ to '...
    num2str(bigfirm_size) '_' num2str(side) '.xlsx'];      
xlswrite(filename5,indcost_mat);

filename6 = ['IncIQ_s_draw_indprofit firm ' num2str(id_vector) ' incIQ to '...
    num2str(bigfirm_size) '_' num2str(side)  '.xlsx'];      
xlswrite(filename6,indprofit_mat);

filename7 = ['IncIQ_s_draw_indqcall firm ' num2str(id_vector) ' incIQ to '...
    num2str(bigfirm_size) '_' num2str(side) '.xlsx'];      
xlswrite(filename7,qcall_mat);


end                                                                       %
%-------------------------------------------------------------------------%
