function qcall_i = find_qcall_new(mktclrp,aggsq,aggsp,totdemauc,ybidder,pbidder)

% Help: ASSUMES THAT THE BIDS ARE CONVERTED INTO INC CONVENTION
% calculates the market clearing quantity for bidder i
% given the market clearing price his cumulative bid function
% and the aggregate supply schedule

% first, find out if the bidder is marginal or not
% for the bidder to be marginal, he has to submit a bid equal to the market
% clearing price

indqexact = find(pbidder==mktclrp);

marg = ~isempty(indqexact);
% if the bidder is not marginal, qcall is on the bidder's supply schedule, 
% but different for INC and DEC hours

if ~marg
    % calculates the market clearing quantity for bidder i
    % given his cumulative quantity bid -- ybidder
    % and price points on his bid function -- pbidder
       
    % find the highest price on the bid curve below the mkt clr p
    indq_below = find(pbidder<mktclrp);     
    
    if ~isempty(indq_below)
        qcall_i = ybidder(indq_below(length(indq_below)));
    else
        qcall_i = 0;
    end
end % if not marginal
    
if marg
    %disp(['Marginal (Price Setting) Bidder']);
    
    indAS_below = find(aggsp < mktclrp);
    indAS_above = find(aggsp > mktclrp);

    if ~isempty(indAS_below) & ~isempty(indAS_above)
        ASmktp = aggsq(indAS_above(1)-1);
        ASbel = aggsq(indAS_below(length(indAS_below)));
        AS_step = ASmktp - ASbel;
        Q_rationed = totdemauc - ASbel;
    elseif isempty(indAS_above) | isempty(indAS_below)
        %disp(['isempty(indAS_above) | isempty(indAS_below)'])
        qcall_i = 0;
        return;
    end
    
    indi_below = find(pbidder<mktclrp);
    indi_above = find(pbidder>mktclrp);
    indi_equal = find(pbidder==mktclrp);
    
    if ~isempty(indi_above)
        qimktp = ybidder(indi_above(1)-1);
    else
        %disp(['No bids above mkt clearing price']);
        qimktp = ybidder(indi_equal(length(indi_equal)));
    end
    
    if ~isempty(indi_below)
        qibel = ybidder(indi_below(length(indi_below)));
    else
        %disp(['No bids below mkt clearing price']);
        qibel = ybidder(1);
    end
    
    qi_step = qimktp-qibel;
    
    ration = qi_step/AS_step;
    if ration == 1
        %disp(['No rationing']); 
    end    
    if ration < 1
       % disp(['Rationed by:',num2str(ration)])
    end
    qcall_i = qibel + Q_rationed*ration;
  
end    % if marginal
