function [bidders_CH,type_sim]=type_draw(R)

% find firm size in CH
dat4 = dlmread('firm_size_new.csv',',');
sizeid = dat4(:,1);
firm_size_all = dat4(:,2);
bidders_CH = [4,5,19,27,6,15,29,24,23,8,16,9];

firm_size = find_firm_size_CH(sizeid,firm_size_all,bidders_CH);
firm_size = firm_size/2600;
X = firm_size;
gamma = [-0.726240 14.593903]; 
% Tao
np=size(gamma,2); % number of parameters

tao1  = exp(gamma*[1;X(1:np-1,1)]);
tao2  = exp(gamma*[1;X(1:np-1,2)]);
tao3  = exp(gamma*[1;X(1:np-1,3)]);
tao4  = exp(gamma*[1;X(1:np-1,4)]);
tao5  = exp(gamma*[1;X(1:np-1,5)]);
tao6  = exp(gamma*[1;X(1:np-1,6)]);
tao7  = exp(gamma*[1;X(1:np-1,7)]);
tao8  = exp(gamma*[1;X(1:np-1,8)]);
tao9  = exp(gamma*[1;X(1:np-1,9)]);
tao10  = exp(gamma*[1;X(1:np-1,10)]);
tao11  = exp(gamma*[1;X(1:np-1,11)]);
tao12  = exp(gamma*[1;X(1:np-1,12)]);

K=20;

pd1=makedist('Poisson','lambda',tao1);
pd2=makedist('Poisson','lambda',tao2);
pd3=makedist('Poisson','lambda',tao3);
pd4=makedist('Poisson','lambda',tao4);
pd5=makedist('Poisson','lambda',tao5);
pd6=makedist('Poisson','lambda',tao6);
pd7=makedist('Poisson','lambda',tao7);
pd8=makedist('Poisson','lambda',tao8);
pd9=makedist('Poisson','lambda',tao9);
pd10=makedist('Poisson','lambda',tao10);
pd11=makedist('Poisson','lambda',tao11);
pd12=makedist('Poisson','lambda',tao12);

x = 0:1:K;
s1=pdf(pd1,x);
s2=pdf(pd2,x);
s3=pdf(pd3,x);
s4=pdf(pd4,x);
s5=pdf(pd5,x);
s6=pdf(pd6,x);
s7=pdf(pd7,x);
s8=pdf(pd8,x);
s9=pdf(pd9,x);
s10=pdf(pd10,x);
s11=pdf(pd11,x);
s12=pdf(pd12,x);

s1=s1./sum(s1);
s2=s2./sum(s2);
s3=s3./sum(s3);
s4=s4./sum(s4);
s5=s5./sum(s5);
s6=s6./sum(s6);
s7=s7./sum(s7);
s8=s8./sum(s8);
s9=s9./sum(s9);
s10=s10./sum(s10);
s11=s11./sum(s11);
s12=s12./sum(s12);

% draw bidder types from poisson distribution
type_sim=[];

% Fix the seed for replication
rng(1);
type_sim(1,:)= randsample([0:1:20],R,true,s1);
rng(1);
type_sim(2,:)= randsample([0:1:20],R,true,s2);
rng(1);
type_sim(3,:)= randsample([0:1:20],R,true,s3);
rng(1);
type_sim(4,:)= randsample([0:1:20],R,true,s4);
rng(1);
type_sim(5,:)= randsample([0:1:20],R,true,s5);
rng(1);
type_sim(6,:)= randsample([0:1:20],R,true,s6);
rng(1);
type_sim(7,:)= randsample([0:1:20],R,true,s7);
rng(1);
type_sim(8,:)= randsample([0:1:20],R,true,s8); 
rng(1);
type_sim(9,:)= randsample([0:1:20],R,true,s9);
rng(1);
type_sim(10,:)= randsample([0:1:20],R,true,s10);
rng(1);
type_sim(11,:)= randsample([0:1:20],R,true,s11);
rng(1);
type_sim(12,:)= randsample([0:1:20],R,true,s12); 

end
