function main_19_20(rr)

% HELP: This function is used to replicate estimation of the main
% specification in Hortacsu, Luco, Puller, and Zhu (2019), with data from
% 19-20 hr period. The file is executed using a batch scheduler and a
% compiled standalone executable of this file for
% efficiency. The submission file is not included here, but it is not
% necessary for estimation (it just makes sure all jobs are executed
% without using additional Matlab licenses).

rr = str2num(rr);
clearvars -except rr
parpool('local',9)
%% load data
format longG
dat = dlmread('full_pqs19.csv',',');
dat2 = dlmread('totdemand_mcprice_19.csv',',');
dat3 = dlmread('mcosts_19.csv',',');

dat4 = zeros(62,3);
dat4(:,1:2) = dlmread('firm_size_new_19.csv',',');
dat4(8,3) = 4;
dat4(9,3) = 5;
dat4(10,3) = 6;
dat4(12,3) = 8;
dat4(13,3) = 9;
dat4(18,3) = 15;
dat4(21,3) = 16;
dat4(25,3) = 19;
dat4(30,3) = 23;
dat4(31,3) = 24;
dat4(34,3) = 27;
dat4(35,3) = 29;

time = dat(:,1); % auction ID
p = dat(:,2); % price
qinc = dat(:,3); % quantity
bidderid = dat(:,4); % bidder ID

time2 = dat2(:,1); % auction ID
totdem = dat2(:,2); % total demand
mcp = dat2(:,3); % market clearing price
time3 = dat3(:,1); % auction ID
mc_unit = dat3(:,2); % marginal cost (p)
mc_inc_q = dat3(:,4); % incremental marginal cost (q)
qse_id = dat3(:,3); % bidder ID

id = dat4(:,1);
firm_size_all = dat4(:,2);

mc_firm = dat3(:,5); % marginal cost after incremental. Used to look at capacity


%% set parameters
hbid = 50;  % smoothing parameter for residual demand
K = 20;  % # of types in the auctions

bidders_CH = [8,9,25,34,10,18,35,31,30,12,21,13];
nbidders_CH = length(bidders_CH);

% find auctions consist of all bidders in CH
aucvec = unique(time);
aucvec_use = [];
for i1=1:length(aucvec)
    bidderidauc = bidderid(find(time==aucvec(i1)));
    biddervec = unique(bidderidauc);
    ext_pqs = sum(ismember(biddervec,bidders_CH));
    
    qse_idauc = qse_id(find(time3==aucvec(i1)));
    qsevec = unique(qse_idauc);
    ext_mc = sum(ismember(qsevec,bidders_CH));
    
    if ext_pqs==nbidders_CH && ext_mc==nbidders_CH;
        aucvec_use=[aucvec_use;aucvec(i1)];
    else
        aucvec_use=aucvec_use;
    end
end
n_aucs_use = length(aucvec_use);

% find auctions that have contract position
qcont_mat_all = see_contract(aucvec_use,n_aucs_use,bidders_CH,time,time3,p,qinc,bidderid,mc_unit,mc_inc_q,qse_id);
aucvec_use1 = [];
[a,b] = size(qcont_mat_all);
for i = 1:a
    measure = sum(find(qcont_mat_all(i,2:end)==-1e+06));
    if measure==0
        aucvec_use1=[aucvec_use1;qcont_mat_all(i,1)];
    else
        aucvec_use1=aucvec_use1;
    end
end
n_aucs_use1 = length(aucvec_use1);



%% find firm size in CH
firm_size = find_firm_size_CH(id,firm_size_all,bidders_CH);
firm_size = firm_size/2600;
X = firm_size;


%% find fringe bids % not make fringe steep
time_pq_fringe=fringe_dat(aucvec_use1,n_aucs_use1,bidders_CH,time,p,qinc,bidderid);
time4 = time_pq_fringe(:,1);
p_fringe_all = time_pq_fringe(:,3);
q_fringe_all = time_pq_fringe(:,4);

%% find contract position
qcont_mat_all = see_contract(aucvec_use1,n_aucs_use1,bidders_CH,time,time3,p,qinc,bidderid,mc_unit,mc_inc_q,qse_id);
time5 = qcont_mat_all(:,1);
qcont_mat = qcont_mat_all(:,2:end);

%% set initial value & search gamma
rng(round(abs(rr(1)*10000)))
x0=randn(1,2);
    
% Define triangular distribution to weight prices
pd1 = makedist('Triangular','a',1,'b',41,'c',81);

px = 1:1:81;
pdf1 = pdf(pd1,px)';

% Multiply each price point by the triangular probability before adding
% over them
PDF=repmat(pdf1,1,K+1,nbidders_CH,n_aucs_use1);

options = optimset('Display','iter','MaxIter',50000,'MaxFunEvals',500000,'TolFun',1e-10,'TolX',1e-7);

[param,func] = fminsearch(@(gamma) dif_mcp_sT(gamma,aucvec_use1,time,time2,time3,time4,...
time5,mc_unit,mc_inc_q,qse_id,p,qinc,bidderid,p_fringe_all,q_fringe_all,...
nbidders_CH,bidders_CH,qcont_mat,hbid,K,X,mcp,n_aucs_use1,PDF),x0,options);

delete(gcp)

%% Save data
filename = ['v_g0_' num2str(x0(1)) '.txt'];
output=[func param];

dlmwrite(filename,output,'delimiter','\t','precision','%.6f')

end
