function totcost = find_individualcost(mcqcumbidder,mcpbidder,qcall_i,whichbidder)
% Help: finds cost by "integrating" under MC function
%  Overall idea:  find length and width of each rectangle from q=0 to q=qcall_i and take dot product

error_n = -999999;
error_n = 0;


if isempty(mcqcumbidder)
    if qcall_i ==0
        totcost=0;
    else
        totcost=error_n;
    end
end


if (qcall_i>max(mcqcumbidder) | qcall_i<min(mcqcumbidder) )  
     if qcall_i==0
        totcost=0;
        return;
     else
        totcost= error_n;
        return;
     end   

else  %MAIN PART OF FUNCTION

%--extend the MC function so can evaluate MC(q) at every necessary q (in particular q=0 & qcall_i)

keeppts=find(abs(mcpbidder)<999);   %drop the MC=1000 and -1000 points -- should KEEP MC=-99 (mingen) points
mcqcumbidder1=mcqcumbidder(keeppts);
mcpbidder1=mcpbidder(keeppts);

mcqtemp = [0,qcall_i,mcqcumbidder1']';  %add 2 quantity points to evaluate MC at
mcptemp = [-666,-666,mcpbidder1']';     %MC vector with 2 prices that needed replacing (-666 used below so don't change)

sortedmc = sortrows([mcqtemp,mcptemp],1);
mcqcumbidder_new = sortedmc(:,1);
mcpbidder_new = sortedmc(:,2);


ng=length(mcqcumbidder_new);

for k=1:ng
    ind_mcq = find(mcqcumbidder_new(k)<=mcqcumbidder1);  %NOTE: use weak <= b/c not higher MC until move above the q
      if (~isempty(ind_mcq) & mcpbidder_new(k)==-666)  %only replace the missing (-666) prices with MC(q)
            mcpbidder_new(k)=mcpbidder1(min(ind_mcq));
      end
end


%find area under C(qcall_i)
mcq_inc = mcqcumbidder_new;

if qcall_i>0
    for j=2:ng
        mcq_inc(j)=mcqcumbidder_new(j)-mcqcumbidder_new(j-1);  %find incremental q_INC
    end
    limits = find(mcqcumbidder_new>0 & mcqcumbidder_new<=qcall_i);  %>0 to starts on first incremental (as long as 0 is a q point)
    totcost = mcq_inc(limits)'*mcpbidder_new(limits);  %"add" the rectangles
   
    ['MCqlimits, MCplimits'];
    [mcq_inc(limits), mcpbidder_new(limits)];
    
elseif qcall_i<0
    for j=2:ng
        mcq_inc(j)=mcqcumbidder_new(j)-mcqcumbidder_new(j-1);  %find incremental q_DEC
    end
    mcq_inc(1)=0; 
    limits = find(mcqcumbidder_new>qcall_i & mcqcumbidder_new<=0);    
    totcost = (-1) * mcq_inc(limits)'*mcpbidder_new(limits);

    ['MCqlimits, MCplimits'];
    [-mcq_inc(limits), mcpbidder_new(limits)];

elseif qcall_i==0
    totcost = 0;    
    return;
end

end  %main function

