## ======================================
## Table 1: Estimated annual U.S. hospitalizations and lab-confirmed illnesses 
## for top bacterial foodborne pathogens
## ======================================

  rm(list=ls())
  
  #Assume base R is running
  my.wd <- getSrcDirectory(function(x){x})
  
  #Check for errors
  if(grepl("error", tolower(class(my.wd)[1])) | my.wd==""){
    #Try to access working directory through R Studio API
    my.wd <- tryCatch(dirname(rstudioapi::getActiveDocumentContext()$path),
                      error = function(e) e)
    
  }
  
  #Set working directory
  setwd(my.wd)
  
## ======================================
## Read in data
## ======================================

  #Reportable illnesses from 1990-2015
  notif.dta <- read.csv("../Data/illness_reportable_1990_2015.csv", stringsAsFactors = FALSE)

  #LA ecoli from 1995-1999
  la.dta <- read.csv("../Data/illness_ecoli_1995_1999.csv", stringsAsFactors = FALSE)

  #Hospitalizations
  hosp.cty.yr.1983.2009 <- read.csv("../Data/hosp_county_year_1983_2009.csv", stringsAsFactors = FALSE)
  
## ======================================
## Summarize notifiables and hospitalizations by disease
## ======================================

  #Average annual illness counts by disease
  notif.summary <- aggregate(count~disease, data = subset(notif.dta, year%in%1995:1999 & county == "Los Angeles" & disease!="vibr"), FUN = mean)
  names(notif.summary)[names(notif.summary)=="count"] <- "LA.Illness.Count"
  
  #Add e-coli
  ecoli.row <- data.frame(disease = "ecoli", LA.Illness.Count = mean(la.dta$count))
  notif.summary <- rbind(notif.summary, ecoli.row)
  
  #Average annual hospitalizations
  hosp.summary <- aggregate(cbind(salm, camp, all.ecoli, list, staph)~county, 
                            data = subset(hosp.cty.yr.1983.2009, county == "19" & year%in%1995:1999), 
                            FUN = mean)
  
  #Merge in the hospitalization counts to the notifiable counts
  notif.summary$LA.Hospitalization.Count[notif.summary$disease=="salm"] <- hosp.summary$salm
  notif.summary$LA.Hospitalization.Count[notif.summary$disease=="camp"] <- hosp.summary$camp
  notif.summary$LA.Hospitalization.Count[notif.summary$disease=="ecoli"] <-hosp.summary$all.ecoli
  notif.summary$LA.Hospitalization.Count[notif.summary$disease=="list"] <- hosp.summary$list
  
  #Add staph
  staph.row <- data.frame(disease = "staph", LA.Illness.Count = NA, LA.Hospitalization.Count = hosp.summary$staph)
  notif.summary <- rbind(notif.summary, staph.row)
  
  #Order the table to match Scallan order
  notif.summary <- notif.summary[c(which(notif.summary$disease=="salm"),
                                   which(notif.summary$disease=="camp"),
                                   which(notif.summary$disease=="ecoli"),
                                   which(notif.summary$disease=="list"),
                                   which(notif.summary$disease=="staph")),]
  
  #Order the columns to match table order
  notif.summary <- notif.summary[,c("disease", "LA.Hospitalization.Count", "LA.Illness.Count")]
  
  #Round to whole numbers
  notif.summary[,c("LA.Hospitalization.Count", "LA.Illness.Count")] <- round(notif.summary[,c("LA.Hospitalization.Count", "LA.Illness.Count")])

## ======================================
## Output: Table
## ======================================
  print("Table 1: Estimated annual U.S. hospitalizations and lab-confirmed illnesses")
  print(notif.summary)
  