## ======================================
## Figure 1: Trends in LA (solid) and the rest of CA (dashed) of hospitalizations 
## for foodborne and (non- foodborne) digestive system disorders from 1995-1999.
## ======================================

  rm(list=ls())
  
  #Assume base R is running
  my.wd <- getSrcDirectory(function(x){x})
  
  #Check for errors
  if(grepl("error", tolower(class(my.wd)[1])) | my.wd==""){
    #Try to access working directory through R Studio API
    my.wd <- tryCatch(dirname(rstudioapi::getActiveDocumentContext()$path),
                      error = function(e) e)
    
  }
  
  #Set working directory
  setwd(my.wd)

## ==========================
## Read in data
## ==========================  
  
  #County population
  county.pop.1964.2015 <- read.csv("../Data/county_population_1964_2015.csv", stringsAsFactors = FALSE)

  #Hospitalizations
  hosp.cty.yr.1983.2009 <- read.csv("../Data/hosp_county_year_1983_2009.csv", stringsAsFactors = FALSE)
    
## ==========================
## Aggregate hospitalizations and population
## ==========================  

  #Aggregate population LA vs non-LA
  la.pop <- aggregate(pop~year+ifelse(Name=="Los Angeles", 1, 0), data = county.pop.1964.2015, FUN = sum)
  names(la.pop)[2] <- "la"
  
  ## Aggregate hospitalizations LA vs non-LA
  hosp.cty.yr.1983.2009$la <- as.numeric(hosp.cty.yr.1983.2009$county.name=="Los Angeles")
  fbi.yearly <- aggregate(cbind(jl.codes.mdc6.filter, control.jl.codes.filter)~la+year,
                        data = hosp.cty.yr.1983.2009, subset=year%in%1995:1999,FUN = sum)
  
  ## Merge hospitalizations and population 
  fbi.yearly <- merge(fbi.yearly, la.pop, by = c("la", "year"))
  fbi.yearly <- fbi.yearly[order(fbi.yearly$la),]

  #Create rates
  fbi.yearly$fbi.rate <- (fbi.yearly$jl.codes.mdc6.filter/fbi.yearly$pop)*100000
  fbi.yearly$ctrl.rate <- (fbi.yearly$control.jl.codes.filter/fbi.yearly$pop)*100000

## ==========================
## Output: Plot
## ========================== 
  
  #Colors for plot
  la.color <- "#636363"
  ca.color <- "#bdbdbd"
    
  #Code for plot  
  par(mfrow = c(1,2), mar=c(3,3,2,1), mgp=c(1.5,0.5,0), tcl=-0.3)
  
  #Plot foodborne
  plot(fbi.yearly$year[fbi.yearly$la==0], fbi.yearly$fbi.rate[fbi.yearly$la==0], 
       type = "n", 
       lty = 1,
       ylim = c(2.3,4.8),
       col = ca.color,
       ylab = "Hospitalization rate", xlab = "Year",
      main = "Foodborne")

  abline(v=1997.5,col=rgb(0,0,0,0.4),lwd=0.5)

  lines(fbi.yearly$year[fbi.yearly$la==0], fbi.yearly$fbi.rate[fbi.yearly$la==0],
        col=rgb(0,0,1,0.8),lty=5)
  lines(fbi.yearly$year[fbi.yearly$la==1], fbi.yearly$fbi.rate[fbi.yearly$la==1], type = "l", lty = 1, col =rgb(1,0,0,0.8),lwd=1.5)
  text(1998.3,4.6, "LA enacts\ngrading",cex=0.8,col=rgb(0,0,0,0.8))
    text(x = 1995.3, y = 4.15, label = "LA", cex = 0.8, col = "red")
    text(x = 1995.3, y = 2.4, label = "CA", cex = 0.8, col = "blue")


  #Plot nonfoodborne
  plot(fbi.yearly$year[fbi.yearly$la==0], fbi.yearly$ctrl.rate[fbi.yearly$la==0], 
       type = "n", 
       lty = 1,
       col = ca.color,
       ylim = c(570,660),
       ylab = "Hospitalization rate", xlab = "Year",
       main = "Digestive System")

  abline(v=1997.5,col=rgb(0,0,0,0.4),lwd=0.5)
  lines(fbi.yearly$year[fbi.yearly$la==1], fbi.yearly$ctrl.rate[fbi.yearly$la==1],
        col=rgb(1,0,0,0.8),lwd=1.5)
  lines(fbi.yearly$year[fbi.yearly$la==0], fbi.yearly$ctrl.rate[fbi.yearly$la==0],
        lty=5, col = rgb(0,0,1,0.8))
  
## ==========================
## Correlation counts reported in J&L
## ========================== 

  ## Correlation 
  #LA Foodborne
  cor.test(100000*(c(401,431,405,351,309)/fbi.yearly$pop[fbi.yearly$la==1]),
           fbi.yearly$fbi.rate[fbi.yearly$la==1])
  
  #CA Foodborne
  cor.test(100000*(c(607, 675, 634, 654, 601)/fbi.yearly$pop[fbi.yearly$la==0]),
           fbi.yearly$fbi.rate[fbi.yearly$la==0])
  
  #LA Digestive
  cor.test(100000*(c(54412, 56692, 59585, 61305, 60915)/fbi.yearly$pop[fbi.yearly$la==1]),
           fbi.yearly$ctrl.rate[fbi.yearly$la==1])
  
  #CA Digestive
  cor.test(100000*(c(128949, 131623,139645,145261,148338)/fbi.yearly$pop[fbi.yearly$la==0]),
           fbi.yearly$ctrl.rate[fbi.yearly$la==0])

